/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.ee.action;

import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.VoaFileAttachment;
import gov.va.med.esr.common.model.ee.VoaFileAttachmentDetail;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.EligibilityDocType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.conversion.UIConversionService;
import gov.va.med.esr.ui.ee.action.EligibilityAction;
import gov.va.med.esr.ui.ee.action.EligibilityEditActionForm;
import gov.va.med.esr.ui.ee.action.VOAAttahmentEditActionForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.service.ServiceConfigurationException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EligibilityEditAction
extends EligibilityAction {
    private static final int ADD_NEW_DISABILITIES_COUNT = 8;
    public static final String NO_VET_IND_YES_WITH_INELIGIBILE_DATE_MESSAGE_KEY = "error.noVetIndYesWithIneligibleDate";

    public void afterPropertiesSet() throws Exception {
        if (this.getPersonService() == null || this.getLookupService() == null || this.getEnrollmentService() == null) {
            throw new ServiceConfigurationException("Missing required service(s)(searchService/lookupService/enrollmentCalculateService");
        }
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setUpdatedPerson(request, null);
        return mapping.findForward("cancel");
    }

    public ActionForward acceptChanges(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EligibilityEditActionForm eligibilityForm = this.getEligibilityForm(form);
        Person updatedPersonClone = (Person)this.getUpdatedPerson(request).clone();
        this.conversionService.convert((Object)eligibilityForm, (Object)updatedPersonClone);
        this.conversionService.merge((Object)this.getSelectedPerson(request), (Object)updatedPersonClone);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        if (!isAddAPerson) {
            VOAAttahmentEditActionForm vOAAttahmentEditActionForm = null;
            BigDecimal key = new BigDecimal(updatedPersonClone.getPersonEntityKey().getKeyValueAsString());
            List voaAttachments = this.getVoaApplicationService().findVoaAttachmentByPersonId(key.abs());
            if (voaAttachments != null && !voaAttachments.isEmpty()) {
                for (VoaFileAttachment voaFileAttachment : voaAttachments) {
                    List voaFormAttachements = eligibilityForm.getVoaAttachments();
                    for (int i = 0; i < voaFormAttachements.size(); ++i) {
                        vOAAttahmentEditActionForm = (VOAAttahmentEditActionForm)((Object)voaFormAttachements.get(i));
                        if (!voaFileAttachment.getEntityKey().getKeyValueAsString().equals(vOAAttahmentEditActionForm.getParentKey())) continue;
                        Set voaAttachmentDetails = voaFileAttachment.getAttachmentDetailLst();
                        for (VoaFileAttachmentDetail voaFileAttachmentDetail : voaAttachmentDetails) {
                            if (!voaFileAttachmentDetail.getVoaFileAttachment().getEntityKey().getKeyValueAsString().equals(vOAAttahmentEditActionForm.getParentKey())) continue;
                            voaFileAttachmentDetail.setEligibilityDocType((EligibilityDocType)this.getLookupService().getByCode(EligibilityDocType.class, vOAAttahmentEditActionForm.getVoaAttachmentDocTypeCode()));
                        }
                    }
                    this.getVoaApplicationService().updateAttachmentAttributes(voaFileAttachment);
                }
            }
        }
        if (updatedPersonClone != null && this.getEnrollmentService().isServicePeriodNeeded(updatedPersonClone)) {
            this.setUpdatedPerson(request, updatedPersonClone);
            return mapping.findForward("servicePeriod");
        }
        try {
            if (!isAddAPerson) {
                updatedPersonClone = this.getEnrollmentService().updateEligibilityData(updatedPersonClone);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (updatedPersonClone != null) {
            this.updateSelectedPerson(request, updatedPersonClone);
            this.setUpdatedPerson(request, null);
        }
        return mapping.findForward("acceptChanges");
    }

    public ActionForward updateVoaAttachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EligibilityEditActionForm eligibilityForm = this.getEligibilityForm(form);
        Person updatedPersonClone = (Person)this.getUpdatedPerson(request).clone();
        this.conversionService.convert((Object)eligibilityForm, (Object)updatedPersonClone);
        this.conversionService.merge((Object)this.getSelectedPerson(request), (Object)updatedPersonClone);
        VOAAttahmentEditActionForm vOAAttahmentEditActionFormInComming = null;
        BigDecimal key = new BigDecimal(updatedPersonClone.getPersonEntityKey().getKeyValueAsString());
        List voaAttachmentsOnFile = this.getVoaApplicationService().findVoaAttachmentByPersonId(key.abs());
        if (voaAttachmentsOnFile != null && !voaAttachmentsOnFile.isEmpty()) {
            for (VoaFileAttachment voaFileAttachmentOnFile : voaAttachmentsOnFile) {
                List voaFormAttachementsInComming = eligibilityForm.getVoaAttachments();
                HashSet<VoaFileAttachmentDetail> newAttachments = new HashSet<VoaFileAttachmentDetail>();
                for (int i = 0; i < voaFormAttachementsInComming.size(); ++i) {
                    vOAAttahmentEditActionFormInComming = (VOAAttahmentEditActionForm)((Object)voaFormAttachementsInComming.get(i));
                    if (vOAAttahmentEditActionFormInComming.getVoaAttachmentDocTypeCode().equals("99")) continue;
                    if (voaFileAttachmentOnFile.getEntityKey().getKeyValueAsString().equals(vOAAttahmentEditActionFormInComming.getParentKey())) {
                        Set voaAttachmentDetailsOnFile;
                        if (vOAAttahmentEditActionFormInComming.isParent() && vOAAttahmentEditActionFormInComming.getVoaAttachmentFileName() != null && vOAAttahmentEditActionFormInComming.getVoaAttachmentFileName().equals(voaFileAttachmentOnFile.getFileName())) {
                            String value = request.getParameter("voaAttachment[" + i + "].voaAttachmentAccept");
                            if (value != null) {
                                voaFileAttachmentOnFile.setAttchmentAcceptableInd(new Boolean(true));
                                vOAAttahmentEditActionFormInComming.setVoaAttachmentAccept("on");
                            } else {
                                voaFileAttachmentOnFile.setAttchmentAcceptableInd(new Boolean(false));
                                vOAAttahmentEditActionFormInComming.setVoaAttachmentAccept(null);
                            }
                        }
                        if ((voaAttachmentDetailsOnFile = voaFileAttachmentOnFile.getAttachmentDetailLst()).size() > 0) {
                            Iterator iterator = voaAttachmentDetailsOnFile.iterator();
                            boolean matchFound = false;
                            while (iterator.hasNext()) {
                                VoaFileAttachmentDetail voaFileAttachmentDetailOnFile = (VoaFileAttachmentDetail)iterator.next();
                                if (!voaFileAttachmentDetailOnFile.getVoaFileAttachment().getEntityKey().getKeyValueAsString().equals(vOAAttahmentEditActionFormInComming.getParentKey())) continue;
                                voaFileAttachmentDetailOnFile.setEligibilityDocType((EligibilityDocType)this.getLookupService().getByCode(EligibilityDocType.class, vOAAttahmentEditActionFormInComming.getVoaAttachmentDocTypeCode()));
                                newAttachments.add(voaFileAttachmentDetailOnFile);
                                voaAttachmentDetailsOnFile.remove(voaFileAttachmentDetailOnFile);
                                matchFound = true;
                                break;
                            }
                            if (!matchFound) {
                                VoaFileAttachmentDetail newDetail = new VoaFileAttachmentDetail();
                                newDetail.setEligibilityDocType((EligibilityDocType)this.getLookupService().getByCode(EligibilityDocType.class, vOAAttahmentEditActionFormInComming.getVoaAttachmentDocTypeCode()));
                                newDetail.setVoaFileAttachment(voaFileAttachmentOnFile);
                                newAttachments.add(newDetail);
                            }
                        } else {
                            VoaFileAttachmentDetail detail1 = new VoaFileAttachmentDetail();
                            detail1.setEligibilityDocType((EligibilityDocType)this.getLookupService().getByCode(EligibilityDocType.class, vOAAttahmentEditActionFormInComming.getVoaAttachmentDocTypeCode()));
                            detail1.setVoaFileAttachment(voaFileAttachmentOnFile);
                            newAttachments.add(detail1);
                        }
                    }
                    vOAAttahmentEditActionFormInComming = null;
                }
                voaFileAttachmentOnFile.removeAllVoaAttachmentDetails();
                for (VoaFileAttachmentDetail attachmentDetails : newAttachments) {
                    voaFileAttachmentOnFile.addVoaAttachmentDetail(attachmentDetails);
                }
                this.getVoaApplicationService().updateAttachmentAttributes(voaFileAttachmentOnFile);
            }
        }
        return mapping.findForward("updateVOAAttachments");
    }

    public ActionForward addVoaAttachmentsDocTypes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EligibilityEditActionForm eligibilityForm = this.getEligibilityForm(form);
        String rowID = eligibilityForm.getActiveVOARowID();
        int rowNumber = 0;
        if (rowID != null && !rowID.equals("")) {
            rowNumber = Integer.parseInt(rowID);
        }
        VOAAttahmentEditActionForm vOAAttahmentEditActionFormInComming = null;
        VOAAttahmentEditActionForm vOAAttahmentEditActionFormNew = new VOAAttahmentEditActionForm();
        List voaFormAttachementsInComming = eligibilityForm.getVoaAttachments();
        vOAAttahmentEditActionFormInComming = (VOAAttahmentEditActionForm)((Object)voaFormAttachementsInComming.get(rowNumber));
        vOAAttahmentEditActionFormNew.setVoaAttachmentFileName(vOAAttahmentEditActionFormInComming.getVoaAttachmentFileName());
        vOAAttahmentEditActionFormNew.setVoaAttachmentFileType(vOAAttahmentEditActionFormInComming.getVoaAttachmentFileType());
        vOAAttahmentEditActionFormNew.setVoaAttachmentUpdated(vOAAttahmentEditActionFormInComming.getVoaAttachmentUpdated());
        vOAAttahmentEditActionFormNew.setVoaAttachmentUpdatedBy(vOAAttahmentEditActionFormInComming.getVoaAttachmentUpdatedBy());
        vOAAttahmentEditActionFormNew.setVoaAttachmentFileBuffer(vOAAttahmentEditActionFormInComming.getVoaAttachmentFileBuffer());
        vOAAttahmentEditActionFormNew.setParentKey(vOAAttahmentEditActionFormInComming.getParentKey());
        voaFormAttachementsInComming.add(rowNumber + 1, vOAAttahmentEditActionFormNew);
        eligibilityForm.setVoaAttachments(voaFormAttachementsInComming);
        return mapping.findForward("success");
    }

    public ActionForward preview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EligibilityEditActionForm eligibilityForm = this.getEligibilityForm(form);
        Person updatedPersonClone = (Person)this.getUpdatedPerson(request).clone();
        this.conversionService.convert((Object)eligibilityForm, (Object)updatedPersonClone);
        this.conversionService.merge((Object)this.getSelectedPerson(request), (Object)updatedPersonClone);
        updatedPersonClone = this.getEnrollmentService().assessEEImpact(updatedPersonClone, true, true, false);
        if (updatedPersonClone != null) {
            this.setUpdatedPerson(request, updatedPersonClone);
        }
        return mapping.findForward("eligibilityEditReview");
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EligibilityEditActionForm eligibilityForm = this.getEligibilityForm(form);
        eligibilityForm.setAddAPerson(SessionManager.isAddAPerson(request));
        Person person = (Person)this.getSelectedPerson(request).clone();
        this.setUpdatedPerson(request, person);
        UIConversionService uiConversionService = (UIConversionService)this.conversionService;
        uiConversionService.convert(person, (Object)eligibilityForm);
        eligibilityForm.setCampLejeuneDisabled(!this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        SessionManager.setAttribute(request, "clveligible", this.getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        this.populateWireFrame(eligibilityForm, person, request);
        return mapping.findForward("success");
    }

    private void populateWireFrame(EligibilityEditActionForm eligibilityForm, Person person, HttpServletRequest request) throws Exception {
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        if (!isAddAPerson) {
            BigDecimal key = new BigDecimal(person.getPersonEntityKey().getKeyValueAsString());
            List eeService = this.getVoaApplicationService().findVoaAttachmentByPersonId(key.abs());
            if (eeService != null && !eeService.isEmpty()) {
                Iterator itrVoaAttachment = eeService.iterator();
                VoaFileAttachment voaFileAttachment = null;
                ArrayList<VOAAttahmentEditActionForm> voaAttachments = new ArrayList<VOAAttahmentEditActionForm>();
                while (itrVoaAttachment.hasNext()) {
                    VOAAttahmentEditActionForm vOAAttahmentEditActionForm = new VOAAttahmentEditActionForm();
                    voaFileAttachment = (VoaFileAttachment)itrVoaAttachment.next();
                    vOAAttahmentEditActionForm.setVoaAttachmentFileName(voaFileAttachment.getFileName());
                    String[] fileType = voaFileAttachment.getFileMimeType().split("/");
                    if (fileType != null && fileType.length > 1) {
                        vOAAttahmentEditActionForm.setVoaAttachmentFileType(fileType[1]);
                    } else if (fileType != null && fileType.length > 0) {
                        vOAAttahmentEditActionForm.setVoaAttachmentFileType(voaFileAttachment.getFileMimeType());
                    }
                    vOAAttahmentEditActionForm.setContentType(voaFileAttachment.getFileMimeType());
                    vOAAttahmentEditActionForm.setVoaAttachmentUpdated(voaFileAttachment.getAttachmentReviewDate());
                    vOAAttahmentEditActionForm.setVoaAttachmentUpdatedBy(voaFileAttachment.getAttachmentReviewUserName());
                    vOAAttahmentEditActionForm.setVoaAttachmentFileBuffer(voaFileAttachment.getAttachmentImage() != null ? voaFileAttachment.getAttachmentImage().getFileImage() : null);
                    vOAAttahmentEditActionForm.setParentKey(voaFileAttachment.getEntityKey().getKeyValueAsString());
                    vOAAttahmentEditActionForm.setParent(true);
                    if (voaFileAttachment.getAttchmentAcceptableInd() == Boolean.TRUE) {
                        vOAAttahmentEditActionForm.setVoaAttachmentAccept("on");
                    }
                    voaAttachments.add(vOAAttahmentEditActionForm);
                    Set docTypesSet = voaFileAttachment.getAttachmentDetailLst();
                    Iterator itr = docTypesSet.iterator();
                    int docTypeCounter = 0;
                    while (itr.hasNext()) {
                        VoaFileAttachmentDetail voaFileAttachmentDetail = null;
                        voaFileAttachmentDetail = (VoaFileAttachmentDetail)itr.next();
                        if (docTypeCounter == 0) {
                            vOAAttahmentEditActionForm.setVoaAttachmentDocType(voaFileAttachmentDetail.getEligibilityDocType().getName());
                            vOAAttahmentEditActionForm.setVoaAttachmentDocTypeCode(voaFileAttachmentDetail.getEligibilityDocType().getCode());
                            vOAAttahmentEditActionForm.setParentKey(voaFileAttachmentDetail.getVoaFileAttachment().getEntityKey().getKeyValueAsString());
                            vOAAttahmentEditActionForm.setVoaAttachmentUpdated(voaFileAttachmentDetail.getModifiedOn());
                            vOAAttahmentEditActionForm.setVoaAttachmentUpdatedBy(voaFileAttachmentDetail.getModifiedBy().getName());
                            vOAAttahmentEditActionForm.setParent(true);
                        } else if (docTypeCounter != 0) {
                            VOAAttahmentEditActionForm newVOAAttahmentEditActionForm = new VOAAttahmentEditActionForm();
                            newVOAAttahmentEditActionForm.setVoaAttachmentDocType(voaFileAttachmentDetail.getEligibilityDocType().getName());
                            newVOAAttahmentEditActionForm.setVoaAttachmentDocTypeCode(voaFileAttachmentDetail.getEligibilityDocType().getCode());
                            newVOAAttahmentEditActionForm.setParentKey(voaFileAttachmentDetail.getVoaFileAttachment().getEntityKey().getKeyValueAsString());
                            newVOAAttahmentEditActionForm.setVoaAttachmentUpdated(voaFileAttachmentDetail.getModifiedOn());
                            newVOAAttahmentEditActionForm.setVoaAttachmentUpdatedBy(voaFileAttachmentDetail.getModifiedBy().getName());
                            newVOAAttahmentEditActionForm.setParent(false);
                            voaAttachments.add(newVOAAttahmentEditActionForm);
                        }
                        ++docTypeCounter;
                    }
                    eligibilityForm.setVoaAttachments(voaAttachments);
                }
            } else {
                eligibilityForm.setVoaAttachments(new ArrayList());
            }
        }
    }

    public ActionForward openDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        VOAAttahmentEditActionForm attachmentForm = null;
        EligibilityEditActionForm eligibilityForm = this.getEligibilityForm(form);
        List attachments = eligibilityForm.getVoaAttachments();
        Iterator itr = attachments.iterator();
        String docName = request.getParameter("documentName");
        byte[] buffer = null;
        while (itr.hasNext()) {
            attachmentForm = (VOAAttahmentEditActionForm)((Object)itr.next());
            String fileName = attachmentForm.getVoaAttachmentFileName();
            if (!docName.equals(fileName)) continue;
            buffer = attachmentForm.getVoaAttachmentFileBuffer();
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            response.setContentType(attachmentForm.getContentType());
            ServletOutputStream outStream = null;
            try {
                outStream = response.getOutputStream();
                outStream.write(buffer);
                outStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mapping.findForward("displayDoc");
    }

    public ActionForward addPow(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EligibilityEditActionForm eligibilityForm = this.getEligibilityForm(form);
        eligibilityForm.setPowInd("Yes");
        eligibilityForm.addNewPow();
        eligibilityForm.setAddPOWSource(eligibilityForm.getPowIdList().size() - 1);
        return mapping.findForward("addPow");
    }

    public ActionForward setNoPow(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EligibilityEditActionForm eligibilityForm = this.getEligibilityForm(form);
        eligibilityForm.setPowInd("No");
        eligibilityForm.initPow();
        return mapping.findForward("addPow");
    }

    public ActionForward setVeteranIndNo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurpleHeart ph;
        EligibilityEditActionForm eligibilityForm = this.getEligibilityForm(form);
        eligibilityForm.setVeteranIndicator("n");
        if (eligibilityForm.getPowInd() != null && eligibilityForm.getPowInd().equals("Yes")) {
            eligibilityForm.setPowInd("No");
        }
        eligibilityForm.initPow();
        eligibilityForm.removeAllDisability();
        eligibilityForm.setServiceConnected(null);
        if (eligibilityForm.getUnemployable().equals("y")) {
            eligibilityForm.setUnemployable("n");
        }
        if (eligibilityForm.getPermanentTotal().equals("y")) {
            eligibilityForm.setPermanentTotal("n");
        }
        eligibilityForm.setPermanentTotalEffDate(null);
        if (eligibilityForm.getIsReceivingCompensation().equals("y")) {
            eligibilityForm.setIsReceivingCompensation("n");
        }
        if (eligibilityForm.getAidAttendance().equals("y")) {
            eligibilityForm.setAidAttendance("n");
        }
        if (eligibilityForm.getHousebound().equals("y")) {
            eligibilityForm.setHousebound("n");
        }
        if (eligibilityForm.getVaPension().equals("y")) {
            eligibilityForm.setVaPension("n");
        }
        eligibilityForm.setTotalCheckAmount(null);
        eligibilityForm.setTotalMonthlyCheckAmount(null);
        if (eligibilityForm.getEligibleForMedicaid().equals("y")) {
            eligibilityForm.setEligibleForMedicaid("n");
            eligibilityForm.setMedicaidUpdatedDate(eligibilityForm.getTodayDate());
        }
        if (eligibilityForm.getDisabilityRetirementIndicator().equals("y")) {
            eligibilityForm.setDisabilityRetirementIndicator("n");
        }
        if (eligibilityForm.getDischargeDueDisability().equals("y")) {
            eligibilityForm.setDischargeDueDisability("n");
        }
        eligibilityForm.setAgentOrangeLocation(null);
        eligibilityForm.setRadiationExposureMethod(null);
        if (eligibilityForm.getEnvironmentalContaminationExposure().equals("y")) {
            eligibilityForm.setEnvironmentalContaminationExposure("n");
        }
        if (eligibilityForm.getCampLejeuneInd().equals("y")) {
            eligibilityForm.setCampLejeuneInd("n");
        }
        if ((ph = this.getSelectedPerson(request).getPurpleHeart()) == null || ph.getStatus() == null) {
            eligibilityForm.setPhStatus(null);
        } else if (ph.getPhIndicator() != null && ph.getPhIndicator().booleanValue()) {
            eligibilityForm.setPhStatus(DecorationStatus.CODE_REJECTED.getCode());
        } else {
            eligibilityForm.setPhStatus(ph.getStatus().getCode());
        }
        return mapping.findForward("addDisability");
    }

    public ActionForward setVeteranIndYes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EligibilityEditActionForm eligibilityForm = this.getEligibilityForm(form);
        eligibilityForm.setVeteranIndicator("y");
        PurpleHeart ph = this.getSelectedPerson(request).getPurpleHeart();
        if (ph == null || ph.getStatus() == null) {
            eligibilityForm.setPhStatus(null);
        } else {
            eligibilityForm.setPhStatus(ph.getStatus().getCode());
        }
        return mapping.findForward("addDisability");
    }

    public ActionForward addRatedDisability(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EligibilityEditActionForm eligibilityForm = this.getEligibilityForm(form);
        for (int i = 0; i < 8; ++i) {
            eligibilityForm.addNewDisability(i);
        }
        eligibilityForm.setAddedRatedDisability("y");
        return mapping.findForward("addDisability");
    }

    public ActionForward removeAllRatedDisability(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EligibilityEditActionForm eligibilityForm = this.getEligibilityForm(form);
        eligibilityForm.removeAllDisability();
        eligibilityForm.setFocusButton("removeAllRatedDisability");
        eligibilityForm.setServiceConnected(null);
        eligibilityForm.setUnemployable("n");
        eligibilityForm.setPermanentTotal("n");
        eligibilityForm.setPermanentTotalEffDate(null);
        eligibilityForm.setIsReceivingCompensation("n");
        if (!(eligibilityForm.getAidAttendance().equals("y") || eligibilityForm.getHousebound().equals("y") || eligibilityForm.getVaPension().equals("y"))) {
            eligibilityForm.setTotalCheckAmount(null);
            eligibilityForm.setTotalMonthlyCheckAmount(null);
        }
        return mapping.findForward("addDisability");
    }

    protected EligibilityEditActionForm getEligibilityForm(ActionForm form) {
        return form instanceof EligibilityEditActionForm ? (EligibilityEditActionForm)form : null;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.addRatedDisability", "addRatedDisability");
        map.put("button.removeAllRatedDisability", "removeAllRatedDisability");
        map.put("button.reviewImpact", "preview");
        map.put("button.acceptChanges", "acceptChanges");
        map.put("button.cancel", "cancel");
        map.put("eligibilityView.link.edit", "edit");
        map.put("button.discardChanges", "edit");
        map.put("button.addPow", "addPow");
        map.put("button.setNoPow", "setNoPow");
        map.put("button.setVeteranIndNo", "setVeteranIndNo");
        map.put("button.setVeteranIndYes", "setVeteranIndYes");
        map.put("link.openDocument", "openDocument");
        map.put("button.ADD_VoaDocTypes", "addVoaAttachmentsDocTypes");
        map.put("button.UPDATE_Attributes", "updateVoaAttachments");
        return map;
    }
}

