/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.ee.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.HealthBenefitProfile;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.Pension;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.ee.SpinalCordInjury;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.DiagnosticExtremity;
import gov.va.med.esr.common.model.lookup.Disability;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EligibilityStatusPendVerfiReason;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.EligibilityVerificationSource;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.POWCampLocation;
import gov.va.med.esr.common.model.lookup.POWDataSource;
import gov.va.med.esr.common.model.lookup.POWDocumentType;
import gov.va.med.esr.common.model.lookup.PensionReasonCode;
import gov.va.med.esr.common.model.lookup.PrisonerOfWarLocation;
import gov.va.med.esr.common.model.lookup.RadiationExposureMethod;
import gov.va.med.esr.common.model.lookup.RejectionRemark;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.SpinalCordInjuryType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.ee.action.EligibilityEditActionForm;
import gov.va.med.esr.ui.ee.action.EligibilityEditReviewActionForm;
import gov.va.med.esr.ui.ee.action.EligibilityEnrollmentConversionService;
import gov.va.med.esr.ui.ee.action.EligibilityViewForm;
import gov.va.med.esr.ui.ee.action.ServicePeriodForm;
import gov.va.med.esr.ui.util.ConvertUtils;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.ObjectUtils;

public class EligibilityConversionService
extends EligibilityEnrollmentConversionService {
    public void merge(Object source, Object target) throws Exception {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        PersonHelperService helper = this.getPersonHelperService();
        if (source instanceof Person && target instanceof Person) {
            Person currentPerson = (Person)source;
            Person updatedPerson = (Person)target;
            if (!ObjectUtils.equals((Object)this.getLookupCode((Lookup)helper.getEligibilityStatus(currentPerson)), (Object)this.getLookupCode((Lookup)helper.getEligibilityStatus(updatedPerson))) || !ObjectUtils.equals((Object)JspUtils.displayValue((Object)this.getEligStatusDate(currentPerson), null), (Object)JspUtils.displayValue((Object)this.getEligStatusDate(updatedPerson), null))) {
                this.setEligVerSource(updatedPerson, (EligibilityVerificationSource)lookupCacheService.getByCodeFromCache(EligibilityVerificationSource.class, EligibilityVerificationSource.CODE_CEV.getName()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        PersonHelperService helper = this.getPersonHelperService();
        if (source instanceof Person) {
            try {
                Person person = (Person)source;
                if (target instanceof EligibilityViewForm) {
                    this.convertEligView(person, (EligibilityViewForm)((Object)target), helper);
                    return;
                }
                if (target instanceof EligibilityEditActionForm) {
                    this.convertEligEdit(person, (EligibilityEditActionForm)((Object)target), helper);
                    return;
                }
                if (target instanceof EligibilityEditReviewActionForm) {
                    this.convertEligReview(person, (EligibilityEditReviewActionForm)((Object)target), helper);
                    return;
                }
                if (!(target instanceof ServicePeriodForm)) throw new ConversionServiceException("Type mismatch: Expecting EligibilityViewForm or EligibilityEditActionForm or EligibilityEditReviewActionForm, Received " + target.getClass().getName());
                ServicePeriodForm formBean = (ServicePeriodForm)((Object)target);
                formBean.setPrimaryElig(this.getPrimaryEligibilityType(person));
                formBean.setPeriodOfService(this.getPeriodOfService(person));
                formBean.setServicePeriodList(this.getServicePeriodList(this.getPrimaryEligibilityType(person)));
                return;
            }
            catch (Exception ex) {
                throw new ConversionServiceException("Conversion Failed", ex);
            }
        }
        if (source instanceof EligibilityEditActionForm) {
            try {
                if (!(target instanceof Person)) return;
                this.convertEligEdit((EligibilityEditActionForm)((Object)source), (Person)target, helper);
                return;
            }
            catch (Exception ex) {
                throw new ConversionServiceException("Conversion Failed on convertEligEdit", ex);
            }
        }
        if (!(source instanceof ServicePeriodForm) || !(target instanceof Person)) throw new ConversionServiceException("Type mismatch: Expecting Person, Received " + source.getClass().getName());
        ServicePeriodForm formBean = (ServicePeriodForm)((Object)source);
        Person person = (Person)target;
        try {
            this.setPeriodOfService(person, formBean.getPeriodOfService(), this.getLookupCacheService());
            return;
        }
        catch (Exception e) {
            throw new ConversionServiceException("Conversion Failed on convert period of service", e);
        }
    }

    private Vector getServicePeriodList(EligibilityType type) throws Exception {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        Collection list = lookupCacheService.getFromCache("gov.va.med.esr.common.model.lookup.ServicePeriod");
        Vector<ServicePeriod> subList = new Vector<ServicePeriod>();
        if (list != null) {
            for (ServicePeriod obj : list) {
                if (!obj.isSubSetForNonVeteranCode(type.getCode())) continue;
                subList.add(obj);
            }
        }
        return subList;
    }

    private void convertEligView(Person person, EligibilityViewForm formBean, PersonHelperService helper) throws Exception {
        formBean.setVeteranIndicator(person.getVeteran());
        formBean.setPrimaryElig(this.getPrimaryEligibilityDesc(person));
        formBean.setApplicationDate(EligibilityConversionService.getApplicationDate(person));
        formBean.setScPercentage(this.getServiceConnectedPercentage(person));
        formBean.setEnrollmentEffDate(this.getEnrollEffDate(helper.getEnrollmentDetermination(person)));
        formBean.setEffectiveDateCombinedRating(this.getEffectiveDateCombinedRating(person));
        formBean.setTotalCheck(this.getTotalCheckAmount(person));
        formBean.setEligStatus(helper.getEligibilityStatus(person));
        formBean.setEligVerMethod(this.getEligVerMethod(person));
        formBean.setEligStatusDate(this.getEligStatusDate(person));
        formBean.setAACIndicator(this.getAACIndicator(person));
        formBean.setEligVerSource(this.getEligVerSource(person));
        formBean.setEligVerSourceFacility(this.getEligVerSourceFacility(person));
        formBean.setMSDSQueryStatus(helper.getMSDSQueryStatus(person));
        formBean.setEligStatusPVReason(helper.getEligStatusPendingVerficationReason(person));
        formBean.setEligStatusPVReasonExplain(this.getEligStatusPendingVerfReasonExplain(person));
        HealthBenefitProfile hbp = person.getHealthBenefitProfile();
        if (hbp != null) {
            Set plans = hbp.getHealthBenefitPlans();
            formBean.setCurrentNumberOfHealthBenefitPlans(plans.size());
        } else {
            formBean.setCurrentNumberOfHealthBenefitPlans(0);
        }
        PurpleHeart ph = person.getPurpleHeart();
        if (ph == null || ph.getStatus() == null) {
            formBean.setPhStatus(null);
        } else {
            formBean.setPhStatus(ph.getStatus());
        }
        PrisonerOfWar pow = person.getPrisonerOfWar();
        if (pow == null) {
            formBean.setPowIndicator(null);
            formBean.setPowEpisodes(null);
        } else {
            formBean.setPowIndicator(pow.getPowIndicator());
            formBean.setPowEpisodes(pow.getEpisodes());
        }
        formBean.setScDisbilities(this.getDisabilities(person));
        formBean.setOtherEligCodes(this.getOtherEligCodes(person));
        formBean.setOtherEligFactors(this.getOtherEligFactors(person));
        formBean.setIneligibilityFactor(person.getIneligibilityFactor());
        formBean.setIncomeTestDate(this.getIncomeTestDate(person));
        formBean.setIncomeTestFacility(this.getIncomeTestFacility(person));
        formBean.setIncomeTestStatus(this.getIncomeTestStatusDesc(person));
        formBean.setIncomeTestYear(this.getIncomeTestYear(person));
        formBean.setIncomeTestLastEdited(this.getIncomeTestLastEdited(person));
    }

    private void convertPow(EligibilityEditActionForm eeForm, PrisonerOfWar pow) {
        Set powSet;
        eeForm.setPowInd(ConvertUtils.convertYesNoNoDataString(pow == null || pow.getPowIndicator() == null ? null : pow.getPowIndicator().toBoolean()));
        eeForm.initPow();
        if (pow != null && (powSet = pow.getEpisodes()) != null) {
            for (Object data : powSet) {
                if (data == null || !(data instanceof POWEpisode)) continue;
                POWEpisode powEpisode = (POWEpisode)data;
                Long days = null;
                if (powEpisode.getReleaseDate() != null && powEpisode.getCaptureDate() != null) {
                    days = DateUtils.getDays((ImpreciseDate)powEpisode.getCaptureDate(), (ImpreciseDate)powEpisode.getReleaseDate(), (boolean)true);
                }
                eeForm.addPow(powEpisode.getEntityKey(), powEpisode.getConfinementLocation() == null ? "" : powEpisode.getConfinementLocation().getCode(), JspUtils.displayValue((Object)powEpisode.getCaptureDate(), null), JspUtils.displayValue((Object)powEpisode.getReleaseDate(), null), days == null ? "" : days.toString(), powEpisode.getDataSource() == null ? "" : powEpisode.getDataSource().getCode(), powEpisode.getDocumentType() == null ? "" : powEpisode.getDocumentType().getCode(), powEpisode.getCampLocation() == null ? "" : powEpisode.getCampLocation().getCode(), powEpisode.getCampLocation() == null ? "" : powEpisode.getCampLocation().getCode(), powEpisode.getCampLocation() == null ? "" : powEpisode.getCampLocation().getName(), powEpisode.getCampLocation() == null ? "" : powEpisode.getCampLocation().getDescription(), JspUtils.displayValue((Object)powEpisode.getDateEntered(), null));
            }
        }
    }

    private void convertEligReview(Person person, EligibilityEditReviewActionForm eeForm, PersonHelperService helper) throws Exception {
        eeForm.setEnrollStatus(helper.getEnrollmentStatus(person));
        eeForm.setAppDate(EligibilityConversionService.getApplicationDate(person));
        eeForm.setEligStatus(helper.getEligibilityStatus(person));
        eeForm.setEligStatusDate(this.getEligStatusDate(person));
        eeForm.setEligVerSourceFacility(this.getEligVerSourceFacility(person));
        eeForm.setEligVerMethod(this.getEligVerMethod(person));
        eeForm.setPrimaryEligCode(this.getPrimaryEligibilityDesc(person));
        eeForm.setTotalCheckAmt(this.getTotalCheckAmount(person));
        eeForm.setOtherEligCodes(this.getOtherEligCodes(person));
        eeForm.setOtherEligFactors(this.getOtherEligFactors(person));
        eeForm.setEnrollmentPriority(EligibilityConversionService.getEnrollmentPriority(person));
        eeForm.setScIndicator(this.isServiceConnected(person));
        eeForm.setScPercentage(this.getServiceConnectedPercentage(person));
        eeForm.setEditedDate(this.getEnrollModifiedDate(person));
        eeForm.setEditedBy("");
        eeForm.setEligStatusPVReason(helper.getEligStatusPendingVerficationReason(person));
        eeForm.setEligStatusPVReasonExplain(this.getEligStatusPendingVerfReasonExplain(person));
        eeForm.setEligStatusDate(this.getEligStatusDate(person));
        Person proposedPerson = eeForm.getProposedPerson();
        eeForm.setEnrollStatusProposed(helper.getEnrollmentStatus(proposedPerson));
        eeForm.setApplicationDateProposed(EligibilityConversionService.getApplicationDate(proposedPerson));
        eeForm.setEligStatusProposed(helper.getEligibilityStatus(proposedPerson));
        eeForm.setEligStatusDateProposed(this.getEligStatusDate(proposedPerson));
        eeForm.setEligVerSourceFacilityProposed(this.getEligVerSourceFacility(proposedPerson));
        eeForm.setEligVerMethodProposed(this.getEligVerMethod(proposedPerson));
        eeForm.setPrimaryEligCodeProposed(this.getPrimaryEligibilityDesc(proposedPerson));
        eeForm.setTotalCheckAmtProposed(this.getTotalCheckAmount(proposedPerson));
        eeForm.setOtherEligCodesProposed(this.getOtherEligCodes(proposedPerson));
        eeForm.setOtherEligFactorsProposed(this.getOtherEligFactors(proposedPerson));
        eeForm.setEnrollmentPriorityProposed(EligibilityConversionService.getEnrollmentPriority(proposedPerson));
        eeForm.setScIndicatorProposed(this.isServiceConnected(proposedPerson));
        eeForm.setScPercentageProposed(this.getServiceConnectedPercentage(proposedPerson));
        eeForm.setEditedDateProposed(new Date());
        eeForm.setEditedByProposed("");
    }

    private void convertEligEdit(Person person, EligibilityEditActionForm eeForm, PersonHelperService helper) throws Exception {
        eeForm.setDeathDate(JspUtils.displayValue((Object)(person.getDeathRecord() == null ? null : person.getDeathRecord().getDeathDate()), null));
        eeForm.setBirthDate(JspUtils.displayValue((Object)(person.getBirthRecord() == null ? null : person.getBirthRecord().getBirthDate()), null));
        eeForm.setTodayDate(JspUtils.displayValue((Object)new Date(), null));
        eeForm.setVeteranIndicator(this.getVeteranIndicator(person));
        eeForm.setOldVeteranIndicator(this.getVeteranIndicator(person));
        EligibilityStatus eligStatus = helper.getEligibilityStatus(person);
        if (eligStatus == null) {
            eeForm.setEligibilityStatus("");
        } else {
            eeForm.setEligibilityStatus(eligStatus.getCode());
        }
        eeForm.setEligibilityStatusDate(JspUtils.displayValue((Object)this.getEligStatusDate(person), null));
        eeForm.setOldEligibilityStatusDate(JspUtils.displayValue((Object)this.getEligStatusDate(person), null));
        EligibilityStatusPendVerfiReason eligStatusReason = helper.getEligStatusPendingVerficationReason(person);
        if (eligStatusReason == null) {
            eeForm.setEligStatusPendingVerficationReason("");
        } else {
            eeForm.setEligStatusPendingVerficationReason(eligStatusReason.getCode());
        }
        eeForm.setEligStatusPendingVerfReasonExplain(this.getEligStatusPendingVerfReasonExplain(person));
        eeForm.setVerificationMethod(this.getEligVerMethod(person));
        eeForm.setServiceConnected(this.getServiceConnectedPercentage(person));
        eeForm.setEffectiveDateCombinedRating(JspUtils.displayValue((Object)this.getEffectiveDateCombinedRating(person), null));
        this.convertPow(eeForm, person.getPrisonerOfWar());
        PurpleHeart ph = helper.getPurpleHeart(person);
        if (ph == null || ph.getStatus() == null) {
            eeForm.setPhStatus(null);
        } else {
            eeForm.setPhStatus(ph.getStatus().getCode());
        }
        eeForm.setAidAttendance(ConvertUtils.convertYesNo(this.isAidAttendance(person)));
        eeForm.setHousebound(ConvertUtils.convertYesNo(this.isHousebound(person)));
        eeForm.setVaPension(ConvertUtils.convertYesNo(this.isVAPension(person)));
        eeForm.setOldvaPension(ConvertUtils.convertYesNo(this.isVAPension(person)));
        eeForm.setIsReceivingCompensation(ConvertUtils.convertYesNoUnknown(this.isReceivingVADisabilityCompensation(person)));
        BigDecimal checkAmount = this.getTotalCheckAmount(person);
        if (checkAmount == null) {
            eeForm.setTotalCheckAmount(null);
            eeForm.setTotalMonthlyCheckAmount(null);
        } else if (checkAmount.equals(BigDecimal.valueOf(0L))) {
            eeForm.setTotalCheckAmount("0");
            eeForm.setTotalMonthlyCheckAmount("0");
        } else {
            eeForm.setTotalCheckAmount(checkAmount.toString());
            eeForm.setTotalMonthlyCheckAmount(checkAmount.divide(BigDecimal.valueOf(12L), 2, 0).toString());
        }
        eeForm.setUnemployable(ConvertUtils.convertYesNo(this.isUnemployable(person)));
        eeForm.setPermanentTotal(ConvertUtils.convertYesNo(this.isPermanentTotal(person)));
        eeForm.setPermanentTotalEffDate(JspUtils.displayValue((Object)this.getPermanentTotalEffDate(person), null));
        IncompetenceRuling incompetenceRuling = person.getIncompetenceRuling();
        if (incompetenceRuling == null) {
            eeForm.setRatedIncompetent("nd");
            eeForm.setCivilDate("");
            eeForm.setVaDate("");
        } else {
            eeForm.setCivilDate(JspUtils.displayValue((Object)incompetenceRuling.getCivilRulingDate(), null));
            eeForm.setVaDate(JspUtils.displayValue((Object)incompetenceRuling.getVaRulingDate(), null));
            eeForm.setRatedIncompetent(ConvertUtils.convertYesNoNoData(incompetenceRuling.isIncompetent()));
        }
        eeForm.setEligibleForMedicaid(ConvertUtils.convertYesNoNoData(this.isEligibleForMedicaid(person)));
        Date medicaidUpdateDate = this.getMedicaidUpdatedDate(person);
        if (medicaidUpdateDate != null) {
            eeForm.setMedicaidUpdatedDate(DateUtils.formatForEdit((Date)medicaidUpdateDate, null));
        }
        Date serviceEntryDate = person.getMilitaryService() == null ? null : person.getMilitaryService().getServiceEntryDate();
        eeForm.setServiceEntryDate(JspUtils.displayValue((Object)serviceEntryDate, null));
        eeForm.setIneligibleDate(JspUtils.displayValue((Object)this.getIneligibleDate(person), null));
        eeForm.setIneligibleReason(this.getIneligibleReason(person));
        eeForm.setIneligibleVARODecision(this.getIneligibleVARODecision(person));
        eeForm.setDischargeDueDisability(ConvertUtils.convertYesNoNoData(this.getDischargeDueDisability(person)));
        eeForm.setDisabilityRetirementIndicator(ConvertUtils.convertYesNoNoData(this.getDisabilityRetirementIndicator(person)));
        eeForm.setAgentOrangeLocation(this.getAgentOrangeLocation(person));
        eeForm.setRadiationExposureMethod(this.getRadiationExposureMethod(person));
        Indicator indicator = null;
        EnvironmentalContaminationExposure ece = this.getEnvironmentalContaminationExposure(person);
        if (ece != null) {
            indicator = ece.getEnvironmentalContaminationExposureIndicator();
        }
        eeForm.setEnvironmentalContaminationExposure(ConvertUtils.convertYesNo(indicator == null ? Boolean.FALSE : indicator.toBoolean()));
        this.convertDisabilities(eeForm, person);
        eeForm.setPeriodOfService(this.getPeriodOfService(person));
        eeForm.setTricare(ConvertUtils.convertYesNo(this.isTricare(person)));
        eeForm.setSharingAgreement(ConvertUtils.convertYesNo(this.isSharingAgreement(person)));
        eeForm.setAlliedVeteranCountry(this.getAlliedVeteranCountry(person));
        eeForm.setChampa(ConvertUtils.convertYesNo(this.isChampa(person)));
        eeForm.setEmployee(ConvertUtils.convertYesNo(this.isEmployee(person)));
        eeForm.setCollateralOfVet(ConvertUtils.convertYesNo(this.isCollateralOfVet(person)));
        eeForm.setOtherFederalAgency(this.getOtherFederalAgency(person));
        this.populateCampLejeune(eeForm, person);
        Pension p = this.getPension(person);
        if (p != null) {
            eeForm.setPensionAwardEffectiveDate(JspUtils.displayValue((Object)p.getEffectiveDate(), null));
            eeForm.setPensionAwardReasonCode(p.getAwardReasonCode() == null ? "" : p.getAwardReasonCode().getCode());
            eeForm.setPensionAwardTerminationDate(JspUtils.displayValue((Object)p.getTerminationDate(), null));
            eeForm.setPensionAwardTerminationReasonCode1(p.getTerminationReasonCode1() == null ? "" : p.getTerminationReasonCode1().getCode());
            eeForm.setPensionAwardTerminationReasonCode2(p.getTerminationReasonCode2() == null ? "" : p.getTerminationReasonCode2().getCode());
            eeForm.setPensionAwardTerminationReasonCode3(p.getTerminationReasonCode3() == null ? "" : p.getTerminationReasonCode3().getCode());
            eeForm.setPensionAwardTerminationReasonCode4(p.getTerminationReasonCode4() == null ? "" : p.getTerminationReasonCode4().getCode());
        } else {
            eeForm.setPensionAwardEffectiveDate("");
            eeForm.setPensionAwardReasonCode("");
            eeForm.setPensionAwardTerminationDate("");
            eeForm.setPensionAwardTerminationReasonCode1("");
            eeForm.setPensionAwardTerminationReasonCode2("");
            eeForm.setPensionAwardTerminationReasonCode3("");
            eeForm.setPensionAwardTerminationReasonCode4("");
        }
        eeForm.setSpinalCordInjury(person.getSpinalCordInjury() == null ? "" : person.getSpinalCordInjury().getSpinalCordInjuryType().getCode());
        eeForm.setNoseThroatRadium(this.getNoseThroatRadium(person));
    }

    private Pension getPension(Person person) {
        if (person != null && person.getMonetaryBenefitAward() != null && person.getMonetaryBenefitAward().getVAPension() != null) {
            return person.getMonetaryBenefitAward().getVAPension().getPension();
        }
        return null;
    }

    private void convertDisabilities(EligibilityEditActionForm eeForm, Person person) {
        ServiceConnectionAward scAward = person.getServiceConnectionAward();
        eeForm.initDisability();
        if (scAward != null && scAward.getRatedDisabilities() != null) {
            Set disList = scAward.getRatedDisabilities();
            eeForm.setSelectedDisabilityIndexes(new int[disList.size()]);
            int index = 0;
            for (Object data : disList) {
                RatedDisability rd;
                if (!(data instanceof RatedDisability) || (rd = (RatedDisability)data) == null || rd.getDisability() == null) continue;
                String idString = rd.getEntityKey() == null ? "" : rd.getEntityKey().getKeyValueAsString();
                eeForm.addDisability(rd.getEntityKey(), idString, rd.getDisability() == null ? "" : rd.getDisability().getCode(), rd.getDisability() == null ? "" : rd.getDisability().getName(), rd.getPercentage() == null ? "" : rd.getPercentage().toString(), rd.getDiagnosticExtremity() == null ? "" : rd.getDiagnosticExtremity().getCode(), JspUtils.displayValue((Object)rd.getOriginalEffectiveRatingDate(), null), JspUtils.displayValue((Object)rd.getRatingDate(), null));
                if (index >= disList.size()) continue;
                eeForm.getSelectedDisabilityIndexes()[index] = index;
                ++index;
            }
        }
    }

    private void convertEligEdit(EligibilityEditActionForm eeForm, Person person, PersonHelperService helper) throws Exception {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        if (person.getEligibilityVerification() == null && (eeForm.getEligibilityStatus() != null || eeForm.getEligibilityStatusDate() != null || eeForm.getVerificationMethod() != null)) {
            person.setEligibilityVerification(new EligibilityVerification());
        }
        this.setVeteranIndicator(person, eeForm.getVeteranIndicator());
        helper.setEligibilityStatus(eeForm.getEligibilityStatus(), person);
        this.setEligStatusDate(person, eeForm.getEligibilityStatusDate());
        this.setEligVerMethod(person, eeForm.getVerificationMethod());
        helper.setEligStatusPendingVerficationReason(eeForm.getEligStatusPendingVerficationReason(), person);
        this.setEligStatusPendingVerfReasonExplain(person, eeForm.getEligStatusPendingVerfReasonExplain());
        if (person.isVeteran() != null && person.isVeteran().booleanValue()) {
            this.setServiceConnectedPercentage(person, eeForm.getServiceConnected());
            this.setEffectiveDateCombinedRating(person, eeForm.getEffectiveDateCombinedRating());
            this.convertPow(person, eeForm, helper);
            this.setMonetaryBenefit(person, eeForm.getAidAttendance(), (MonetaryBenefitType)lookupCacheService.getByCodeFromCache(MonetaryBenefitType.class, MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getName()));
            this.setMonetaryBenefit(person, eeForm.getHousebound(), (MonetaryBenefitType)lookupCacheService.getByCodeFromCache(MonetaryBenefitType.class, MonetaryBenefitType.CODE_HOUSEBOUND.getName()));
            this.setMonetaryBenefit(person, eeForm.getVaPension(), (MonetaryBenefitType)lookupCacheService.getByCodeFromCache(MonetaryBenefitType.class, MonetaryBenefitType.CODE_VA_PENSION.getName()));
            this.setMonetaryBenefit(person, eeForm.getIsReceivingCompensation(), (MonetaryBenefitType)lookupCacheService.getByCodeFromCache(MonetaryBenefitType.class, MonetaryBenefitType.CODE_DISABILITY_COMPENSATION.getName()));
            this.setTotalCheckAmount(person, eeForm.getTotalCheckAmount());
            this.setUnemployable(person, eeForm.getUnemployable());
            this.setPermanentAndTotal(person, eeForm.getPermanentTotal());
            this.setPermanentAndTotalEffDate(person, eeForm.getPermanentTotalEffDate());
            ImpreciseDate dateWithTimeImpreciseDate = DateUtils.getImpreciseDate((String)eeForm.getMedicaidUpdatedDate(), (boolean)true);
            this.setEligibleForMedicaid(person, eeForm.getEligibleForMedicaid(), dateWithTimeImpreciseDate == null ? null : dateWithTimeImpreciseDate.getDate());
            this.setDischargeDueDisability(person, ConvertUtils.convertBoolean(eeForm.getDischargeDueDisability()));
            this.setDisabilityRetirementIndicator(person, ConvertUtils.convertBoolean(eeForm.getDisabilityRetirementIndicator()));
            this.setAgentOrangeExposure(person, (AgentOrangeExposureLocation)lookupCacheService.getByCodeFromCache(AgentOrangeExposureLocation.class, eeForm.getAgentOrangeLocation()));
            this.setRadiationExposureMethod(person, (RadiationExposureMethod)lookupCacheService.getByCodeFromCache(RadiationExposureMethod.class, eeForm.getRadiationExposureMethod()));
            this.setEnvironmentalContaminationExposure(person, eeForm.getEnvironmentalContaminationExposure());
            this.convertDisabilities(person, eeForm, helper);
            this.updateCLVFromGUI(eeForm, person);
        } else {
            this.setNonVeteranPropties(person, eeForm);
        }
        this.setRatedIncompetent(person, eeForm.getRatedIncompetent());
        this.setCivilDate(person, DateUtils.getImpreciseDate((String)eeForm.getCivilDate()));
        this.setVaDate(person, DateUtils.getImpreciseDate((String)eeForm.getVaDate()));
        this.setIneligibleDate(person, eeForm.getIneligibleDate());
        this.setIneligibleReason(person, eeForm.getIneligibleReason());
        this.setIneligibleVARODecision(person, eeForm.getIneligibleVARODecision());
        person.setReceivedPrimaryEligiblity(null);
        person.removeAllReceivedSecondaryEligibilities();
        String secondElig = eeForm.getTricare();
        if (secondElig != null && secondElig.equalsIgnoreCase("y")) {
            this.setNonVeteranElig(person, lookupCacheService, EligibilityType.TRICARE_CHAMPUS.getName());
        }
        if ((secondElig = eeForm.getSharingAgreement()) != null && secondElig.equalsIgnoreCase("y")) {
            this.setNonVeteranElig(person, lookupCacheService, EligibilityType.SHARING_AGREEMENT.getName());
        }
        if ((secondElig = eeForm.getAlliedVeteranCountry()) != null && secondElig.trim().length() > 0) {
            this.setAlliedCountry(person, lookupCacheService, secondElig);
        }
        if ((secondElig = eeForm.getChampa()) != null && secondElig.equalsIgnoreCase("y")) {
            this.setNonVeteranElig(person, lookupCacheService, EligibilityType.CHAMPVA.getName());
        }
        if ((secondElig = eeForm.getEmployee()) != null && secondElig.equalsIgnoreCase("y")) {
            this.setNonVeteranElig(person, lookupCacheService, EligibilityType.EMPLOYEE.getName());
        }
        if ((secondElig = eeForm.getCollateralOfVet()) != null && secondElig.equalsIgnoreCase("y")) {
            this.setNonVeteranElig(person, lookupCacheService, EligibilityType.COLLATERAL_OF_VETERAN.getName());
        }
        if ((secondElig = eeForm.getOtherFederalAgency()) != null && secondElig.trim().length() > 0) {
            this.setOtherFederalAgency(person, lookupCacheService, secondElig);
        }
        this.setPeriodOfService(person, eeForm.getPeriodOfService(), lookupCacheService);
        this.setPensionDataFromFormToPerson(person, eeForm, lookupCacheService);
        this.setSpinalCordInjury(person, eeForm.getSpinalCordInjury(), eeForm, lookupCacheService);
        this.setNoseThroatRadium(person, eeForm.getNoseThroatRadium());
    }

    private void setSpinalCordInjury(Person person, String sciString, EligibilityEditActionForm eeForm, LookupCacheService lookupCacheService) throws Exception {
        SpinalCordInjury spi = person.getSpinalCordInjury();
        if (spi == null) {
            spi = new SpinalCordInjury();
            person.setSpinalCordInjury(spi);
        }
        spi.setSpinalCordInjuryType((SpinalCordInjuryType)lookupCacheService.getByCodeFromCache(SpinalCordInjuryType.class, eeForm.getSpinalCordInjury()));
    }

    private void setPensionDataFromFormToPerson(Person person, EligibilityEditActionForm eeForm, LookupCacheService lookupCacheService) throws Exception {
        Pension p;
        MonetaryBenefit ben;
        MonetaryBenefitAward awd = person.getMonetaryBenefitAward();
        if (awd == null) {
            awd = new MonetaryBenefitAward();
            awd.setPerson(person);
            person.setMonetaryBenefitAward(awd);
        }
        if ((ben = awd.getVAPension()) == null) {
            ben = new MonetaryBenefit();
            ben.setMonetaryBenefitAward(awd);
            ben.setType((MonetaryBenefitType)lookupCacheService.getByCodeFromCache(MonetaryBenefitType.class, MonetaryBenefitType.CODE_VA_PENSION.getCode()));
            awd.addMonetaryBenefit(ben);
        }
        if ((p = ben.getPension()) == null) {
            p = new Pension();
            p.setMonetaryBenefit(ben);
            ben.setPension(p);
        }
        p.setEffectiveDate(DateUtils.getDate((String)eeForm.getPensionAwardEffectiveDate()));
        p.setAwardReasonCode((PensionReasonCode)lookupCacheService.getByCodeFromCache(PensionReasonCode.class, eeForm.getPensionAwardReasonCode()));
        p.setTerminationDate(DateUtils.getDate((String)eeForm.getPensionAwardTerminationDate()));
        p.setTerminationReasonCode1((PensionReasonCode)lookupCacheService.getByCodeFromCache(PensionReasonCode.class, eeForm.getPensionAwardTerminationReasonCode1()));
        p.setTerminationReasonCode2((PensionReasonCode)lookupCacheService.getByCodeFromCache(PensionReasonCode.class, eeForm.getPensionAwardTerminationReasonCode2()));
        p.setTerminationReasonCode3((PensionReasonCode)lookupCacheService.getByCodeFromCache(PensionReasonCode.class, eeForm.getPensionAwardTerminationReasonCode3()));
        p.setTerminationReasonCode4((PensionReasonCode)lookupCacheService.getByCodeFromCache(PensionReasonCode.class, eeForm.getPensionAwardTerminationReasonCode4()));
    }

    private void convertPowEpisode(POWEpisode pow, EligibilityEditActionForm eeForm, int index) throws Exception {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        String loc = eeForm.getPowConfinementLocation(index);
        pow.setConfinementLocation((PrisonerOfWarLocation)lookupCacheService.getByCodeFromCache(PrisonerOfWarLocation.class, loc));
        pow.setCaptureDate(DateUtils.getImpreciseDate((String)eeForm.getPowCaptureDate(index)));
        pow.setReleaseDate(DateUtils.getImpreciseDate((String)eeForm.getPowReleaseDate(index)));
        if (pow.getCaptureDate() == null || pow.getReleaseDate() == null) {
            pow.setNumberOfDaysInCaptivity(null);
        } else {
            Long days = DateUtils.getDays((ImpreciseDate)pow.getCaptureDate(), (ImpreciseDate)pow.getReleaseDate(), (boolean)true);
            pow.setNumberOfDaysInCaptivity(days == null ? null : new Integer(days.intValue()));
        }
        pow.setDataSource((POWDataSource)lookupCacheService.getByCodeFromCache(POWDataSource.class, eeForm.getPowSource(index)));
        pow.setDocumentType((POWDocumentType)lookupCacheService.getByCodeFromCache(POWDocumentType.class, eeForm.getPowDocumentType(index)));
        pow.setCampLocation((POWCampLocation)lookupCacheService.getByCodeFromCache(POWCampLocation.class, eeForm.getPowCampLocation(index)));
    }

    private void convertPow(Person person, EligibilityEditActionForm eeForm, PersonHelperService helper) throws Exception {
        String powInd;
        if (StringUtils.isNotEmpty((String)eeForm.getPowInd())) {
            // empty if block
        }
        if ((powInd = ConvertUtils.convertIndicator(eeForm.getPowInd())) == null || StringUtils.equals((String)powInd, (String)Indicator.UNKNOWN.getCode())) {
            person.setPrisonerOfWar(null);
            return;
        }
        if (person.getPrisonerOfWar() == null) {
            person.setPrisonerOfWar(new PrisonerOfWar());
        }
        PrisonerOfWar pow = person.getPrisonerOfWar();
        pow.setPowIndicator((Indicator)this.getLookupCacheService().getByCodeFromCache(Indicator.class, powInd));
        if (eeForm.getPowIdList() == null || eeForm.getPowIdList().isEmpty()) {
            pow.removeAllEpisodes();
        } else {
            ArrayList<POWEpisode> updatedPowEpisodes = new ArrayList<POWEpisode>();
            for (int i = 0; i < eeForm.getPowIdList().size(); ++i) {
                POWEpisode powEpisode;
                EntityKey id = eeForm.getPowId(i);
                String loc = eeForm.getPowConfinementLocation(i);
                ImpreciseDate capDate = DateUtils.getImpreciseDate((String)eeForm.getPowCaptureDate(i));
                ImpreciseDate relDate = DateUtils.getImpreciseDate((String)eeForm.getPowReleaseDate(i));
                if (id != null) {
                    powEpisode = pow.getEpisodeByEntityKey(id);
                    if (powEpisode == null) continue;
                    if ((loc == null || loc.length() == 0) && capDate == null && relDate == null) {
                        pow.removeEpisodeByEntityKey(id);
                        continue;
                    }
                    this.convertPowEpisode(powEpisode, eeForm, i);
                    updatedPowEpisodes.add(powEpisode);
                    continue;
                }
                if (loc == null || loc.length() <= 0 || capDate == null || relDate == null) continue;
                powEpisode = new POWEpisode();
                this.convertPowEpisode(powEpisode, eeForm, i);
                updatedPowEpisodes.add(powEpisode);
            }
            pow.removeAllEpisodes();
            for (POWEpisode powEpisode : updatedPowEpisodes) {
                pow.addEpisode(powEpisode);
            }
        }
    }

    private void convertDisabilities(Person person, EligibilityEditActionForm eeForm, PersonHelperService helper) throws Exception {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        ServiceConnectionAward scAward = person.getServiceConnectionAward();
        ArrayList<RatedDisability> remainingDisabilities = new ArrayList<RatedDisability>();
        if (scAward != null) {
            if (eeForm.getSelectedDisabilityIndexes() != null || eeForm.getSelectedDisabilityIndexes().length != 0) {
                for (int i = 0; i < eeForm.getSelectedDisabilityIndexes().length; ++i) {
                    RatedDisability dis;
                    int index = eeForm.getSelectedDisabilityIndexes()[i];
                    EntityKey id = eeForm.getDisabilityId(index);
                    RatedDisability ratedDisability = dis = id == null ? null : scAward.getRatedDisabilityByEntityKey(id);
                    if (dis == null) {
                        Disability disability = (Disability)lookupCacheService.getByCodeFromCache(Disability.class, eeForm.getDisabilityCodes(index));
                        if (disability == null) continue;
                        dis = new RatedDisability();
                        scAward.addRatedDisability(dis);
                        dis.setDisability(disability);
                    }
                    DiagnosticExtremity de = (DiagnosticExtremity)lookupCacheService.getByCodeFromCache(DiagnosticExtremity.class, eeForm.getDiagnosticExtremity(index));
                    dis.setDiagnosticExtremity(de);
                    dis.setPercentage(JspUtils.parseInt((String)eeForm.getPercentage(index)));
                    dis.setOriginalEffectiveRatingDate(DateUtils.getImpreciseDate((String)eeForm.getOriginalEffectiveDate(index)));
                    dis.setRatingDate(DateUtils.getImpreciseDate((String)eeForm.getCurrentEffectiveDate(index)));
                    remainingDisabilities.add(dis);
                }
            }
            scAward.removeAllRatedDisability();
            for (RatedDisability disability : remainingDisabilities) {
                scAward.addRatedDisability(disability);
            }
        }
    }

    private void setNonVeteranPropties(Person person, EligibilityEditActionForm eeForm) throws Exception {
        MedicaidFactor mf;
        PrisonerOfWar pow;
        PurpleHeart ph;
        EnvironmentalContaminationExposure eexp;
        RadiationExposure rexp;
        AgentOrangeExposure aoe;
        SHAD shad;
        MilitaryService militaryService;
        ServiceConnectionAward scAward = person.getServiceConnectionAward();
        if (scAward != null) {
            scAward.setServiceConnectedPercentage(null);
            if (scAward.getServiceConnectedIndicator() != null && scAward.getServiceConnectedIndicator().booleanValue()) {
                scAward.setServiceConnectedIndicator(Boolean.FALSE);
            }
            if (scAward.getUnemployable() != null && scAward.getUnemployable().booleanValue()) {
                scAward.setUnemployable(Boolean.FALSE);
            }
            if (scAward.getPermanentAndTotal() != null && scAward.getPermanentAndTotal().booleanValue()) {
                scAward.setPermanentAndTotal(Boolean.FALSE);
                scAward.setPermanentAndTotalEffectiveDate(null);
            }
            scAward.removeAllRatedDisability();
        }
        Indicator noIndicator = (Indicator)this.getLookupCacheService().getByCodeFromCache(Indicator.class, Indicator.NO.getCode());
        MonetaryBenefitAward mba = person.getMonetaryBenefitAward();
        if (mba != null) {
            Set monetaryBenefits = mba.getMonetaryBenefits();
            for (MonetaryBenefit monetaryBenefit : monetaryBenefits) {
                if (monetaryBenefit.getMonetaryBenefitIndicator() == null || !Indicator.YES.getCode().equals(monetaryBenefit.getMonetaryBenefitIndicator().getCode())) continue;
                monetaryBenefit.setMonetaryBenefitIndicator(noIndicator);
            }
            mba.setCheckAmount(null);
        }
        if ((militaryService = person.getMilitaryService()) != null) {
            militaryService.setCombatVeteranEligibilityEndDate(null);
            if (militaryService.getDisabilityRetirementIndicator() != null && militaryService.getDisabilityRetirementIndicator().booleanValue()) {
                militaryService.setDisabilityRetirementIndicator(Boolean.FALSE);
            }
            if (militaryService.getDischargeDueToDisability() != null && militaryService.getDischargeDueToDisability().booleanValue()) {
                militaryService.setDischargeDueToDisability(Boolean.FALSE);
            }
        }
        if ((shad = person.getShad()) != null && shad.getShadIndicator() != null && Indicator.YES.getCode().equals(shad.getShadIndicator().getCode())) {
            shad.setShadIndicator(noIndicator);
        }
        if ((aoe = person.getAgentOrangeExposure()) != null && aoe.getAgentOrangeExposureIndicator() != null && Indicator.YES.getCode().equals(aoe.getAgentOrangeExposureIndicator().getCode())) {
            aoe.setAgentOrangeExposureIndicator(noIndicator);
            aoe.setLocation(null);
        }
        if ((rexp = person.getRadiationExposure()) != null && rexp.getRadiationExposureIndicator() != null && Indicator.YES.getCode().equals(rexp.getRadiationExposureIndicator().getCode())) {
            rexp.setRadiationExposureIndicator(noIndicator);
            rexp.setExposureMethod(null);
        }
        if ((eexp = person.getEnvironmentalContaminationExposure()) != null && eexp.getEnvironmentalContaminationExposureIndicator() != null && Indicator.YES.getCode().equals(eexp.getEnvironmentalContaminationExposureIndicator().getCode())) {
            eexp.setEnvironmentalContaminationExposureIndicator(noIndicator);
        }
        if ((ph = person.getPurpleHeart()) != null && ph.getPhIndicator() != null && ph.getPhIndicator().booleanValue()) {
            ph.setPhIndicator(Boolean.FALSE);
            ph.setStatus((DecorationStatus)this.getLookupCacheService().getByCodeFromCache(DecorationStatus.class, DecorationStatus.CODE_REJECTED.getName()));
            ph.setRejectionRemark((RejectionRemark)this.getLookupCacheService().getByCodeFromCache(RejectionRemark.class, RejectionRemark.CODE_ENTERED_IN_ERROR.getName()));
        }
        if ((pow = person.getPrisonerOfWar()) != null && pow.getPowIndicator() != null && Indicator.YES.getCode().equals(pow.getPowIndicator().getCode())) {
            pow.setPowIndicator(noIndicator);
            pow.setIcn(null);
            pow.setDateEntered(null);
            pow.setUser(null);
            pow.removeAllEpisodes();
        }
        if ((mf = person.getMedicaidFactor()) != null && mf.isEligibleForMedicaid() != null && mf.isEligibleForMedicaid().booleanValue()) {
            mf.setEligibleForMedicaid(Boolean.FALSE);
            mf.setLastUpdateDate(DateUtils.getCurrentDate());
        }
    }
}

