/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.ee.action;

import gov.va.med.esr.common.infra.TriState;
import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDescriptor;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.ee.SpinalCordInjury;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.ee.action.ClinicalDeterForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import java.util.Set;
import java.util.Vector;

public class ClinicalDeterConversionService
extends UIConversionServiceImpl {
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (!(source instanceof Person) || !(target instanceof ClinicalDeterForm)) {
            throw new ConversionServiceException("Type mismatch: Expecting Person, ClinicalDeterForm Received " + source.getClass().getName() + " and " + target.getClass().getName());
        }
        Person person = (Person)source;
        ClinicalDeterForm clinicalDeterForm = (ClinicalDeterForm)((Object)target);
        clinicalDeterForm.setConditions(ClinicalDeterConversionService.getConditions(person));
        clinicalDeterForm.setProcetures(ClinicalDeterConversionService.getProcedures(person));
        clinicalDeterForm.setDiagnosis(ClinicalDeterConversionService.getDiagnosis(person));
        clinicalDeterForm.setDescriptors(ClinicalDeterConversionService.getDescriptor(person));
        clinicalDeterForm.setCd(ClinicalDeterConversionService.getCatastrophicDisability(person));
        clinicalDeterForm.setMst(ClinicalDeterConversionService.getMilitarySexualTrauma(person));
        clinicalDeterForm.setNtr(ClinicalDeterConversionService.getNoseThroatRadium(person));
        clinicalDeterForm.setNtrTreatment(ClinicalDeterConversionService.receivedNTRTreatment(person));
        clinicalDeterForm.setSci(ClinicalDeterConversionService.getSpinalCordInjury(person));
    }

    public static Set getClinicalDeterminations(Person person) {
        return person.getClinicalDeterminations();
    }

    public static CatastrophicDisability getCatastrophicDisability(Person person) {
        return (CatastrophicDisability)person.getClinicalDeterminationByType(CatastrophicDisability.class);
    }

    public static MilitarySexualTrauma getMilitarySexualTrauma(Person person) {
        return (MilitarySexualTrauma)person.getClinicalDeterminationByType(MilitarySexualTrauma.class);
    }

    public static NoseThroatRadium getNoseThroatRadium(Person person) {
        return (NoseThroatRadium)person.getClinicalDeterminationByType(NoseThroatRadium.class);
    }

    public static SpinalCordInjury getSpinalCordInjury(Person person) {
        return (SpinalCordInjury)person.getClinicalDeterminationByType(SpinalCordInjury.class);
    }

    public static String receivedNTRTreatment(Person person) {
        NoseThroatRadium ntr = ClinicalDeterConversionService.getNoseThroatRadium(person);
        if (ntr != null) {
            if (ntr.getReceivingTreatment() != null && ntr.getReceivingTreatment().equals((Object)TriState.TRUE)) {
                return "Yes";
            }
            if (ntr.getReceivingTreatment() != null && ntr.getReceivingTreatment().equals((Object)TriState.FALSE)) {
                return "No";
            }
            if (ntr.getReceivingTreatment() != null && ntr.getReceivingTreatment().equals((Object)TriState.UNKNOWN)) {
                return "Unknown";
            }
        }
        return null;
    }

    public static Vector getConditions(Person person) {
        CatastrophicDisability cd = ClinicalDeterConversionService.getCatastrophicDisability(person);
        if (cd != null && cd.getConditions() != null) {
            Vector<Object> ret = new Vector<Object>();
            Object[] objs = cd.getConditions().toArray();
            for (int i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof CDCondition) || ((CDCondition)objs[i]).getCondition() == null) continue;
                ret.add(objs[i]);
            }
            return ret;
        }
        return null;
    }

    public static Vector getDiagnosis(Person person) {
        CatastrophicDisability cd = ClinicalDeterConversionService.getCatastrophicDisability(person);
        if (cd != null && cd.getDiagnoses() != null) {
            Vector<Object> ret = new Vector<Object>();
            Object[] objs = cd.getDiagnoses().toArray();
            for (int i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof CDDiagnosis) || ((CDDiagnosis)objs[i]).getDiagnosis() == null) continue;
                ret.add(objs[i]);
            }
            return ret;
        }
        return null;
    }

    public static Vector getDescriptor(Person person) {
        CatastrophicDisability cd = ClinicalDeterConversionService.getCatastrophicDisability(person);
        if (cd != null && cd.getCDDescriptors() != null) {
            Vector<Object> ret = new Vector<Object>();
            Object[] objs = cd.getCDDescriptors().toArray();
            for (int i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof CDDescriptor) || ((CDDescriptor)objs[i]).getDescriptorType() == null) continue;
                ret.add(objs[i]);
            }
            return ret;
        }
        return null;
    }

    public static Vector getProcedures(Person person) {
        CatastrophicDisability cd = ClinicalDeterConversionService.getCatastrophicDisability(person);
        if (cd != null && cd.getProcedures() != null) {
            Vector<Object> ret = new Vector<Object>();
            Object[] objs = cd.getProcedures().toArray();
            for (int i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof CDProcedure) || ((CDProcedure)objs[i]).getProcedure() == null) continue;
                ret.add(objs[i]);
            }
            return ret;
        }
        return null;
    }
}

