/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.ee.action;

import gov.va.med.esr.common.model.lookup.ApplicationStatus;
import gov.va.med.esr.common.model.person.EnrollmentApplication;
import gov.va.med.esr.ui.admin.action.SearchActionForm;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.fw.conversion.ConversionServiceException;
import java.util.Date;

public class AddPersonHistoryConversionService
extends UIConversionServiceImpl {
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (!(source instanceof EnrollmentApplication) || !(target instanceof SearchActionForm)) {
            throw new ConversionServiceException("Type mismatch: Expecting EnrollmentApplication, SearchActionForm Received " + source.getClass().getName() + " and " + target.getClass().getName());
        }
        EnrollmentApplication eap = (EnrollmentApplication)source;
        SearchActionForm searchActionForm = (SearchActionForm)((Object)target);
        searchActionForm.setAppSignatureDate(this.getApplicationSignatureDate(eap));
        searchActionForm.setAppMethod(this.getApplicationMethod(eap));
        searchActionForm.setAppEntryDate(this.getApplicationDate(eap));
        searchActionForm.setAppStatus(this.getApplicationStatus(eap));
        searchActionForm.setAppStatusTimeStamp(this.getModifiedDate(eap));
        searchActionForm.setAppCompletedDate(this.getCompletedDate(eap));
        searchActionForm.setAppUser(this.getCompletedPersonInfo(eap));
    }

    public String getCompletedPersonInfo(EnrollmentApplication eap) {
        String completedPerson = "";
        if (eap.getApplicationStatus() != null && eap.getApplicationStatus().equals((Object)ApplicationStatus.COMPLETE)) {
            completedPerson = eap.getModifiedBy().getName();
        }
        return completedPerson;
    }

    public String getCompletedDate(EnrollmentApplication eap) {
        String completedDate = "";
        if (eap.getApplicationStatus() != null && eap.getApplicationStatus().equals((Object)ApplicationStatus.COMPLETE)) {
            completedDate = DateUtils.format((Date)eap.getModifiedOn(), (String)"MM/dd/yyyy");
        }
        return completedDate;
    }

    public String getApplicationMethod(EnrollmentApplication eap) {
        String applicationMethod = "";
        if (eap.getApplicationMethod() != null) {
            applicationMethod = eap.getApplicationMethod().getCode();
        }
        return applicationMethod;
    }

    public String getApplicationStatus(EnrollmentApplication eap) {
        String applicationStatus = "";
        if (eap.getApplicationStatus() != null) {
            applicationStatus = eap.getApplicationStatus().getCode();
        }
        return applicationStatus;
    }

    public String getApplicationSignatureDate(EnrollmentApplication eap) {
        String applicationSignatureDate = "";
        if (eap.getSignatureDate() != null) {
            applicationSignatureDate = DateUtils.format((Date)eap.getSignatureDate(), (String)"MM/dd/yyyy");
        }
        return applicationSignatureDate;
    }

    public String getApplicationDate(EnrollmentApplication eap) {
        String applicationDate = "";
        if (eap.getApplicationDate() != null) {
            applicationDate = DateUtils.format((Date)eap.getApplicationDate(), (String)"MM/dd/yyyy");
        }
        return applicationDate;
    }

    public String getModifiedDate(EnrollmentApplication eap) {
        String modifiedDate = "";
        if (eap.getApplicationInProcess() != null) {
            modifiedDate = DateUtils.format((Date)eap.getApplicationInProcess().getModifiedOn(), (String)"MM/dd/yyyy");
        }
        return modifiedDate;
    }
}

