/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.ui.demographic.action.PersonAssociationAction;
import gov.va.med.esr.ui.demographic.action.PersonAssociationInfoForm;
import gov.va.med.fw.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PersonAssociationUpdateAction
extends PersonAssociationAction {
    public ActionForward display(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PersonAssociationInfoForm form = (PersonAssociationInfoForm)actionForm;
        Person person = this.getSelectedPerson(request);
        String associateId = form.getAssociateId();
        if (StringUtils.isNotEmpty((String)associateId)) {
            Association association = this.getAssociationById(person, associateId);
            if (association != null) {
                request.setAttribute("associateKey", (Object)association);
                this.conversionService.convert((Object)association, (Object)form);
            } else {
                this.addActionMessage(request, "message.associateNotFound");
            }
        }
        return mapping.findForward("display");
    }

    public ActionForward updateAssociate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String associateId;
        PersonAssociationInfoForm form = (PersonAssociationInfoForm)actionForm;
        Person person = this.getSelectedPerson(request);
        ActionForward overviewSuccessForward = new ActionForward(mapping.findForward("overviewWithMessage"));
        ActionForward displayForward = mapping.findForward("display");
        if (Country.isUSAddress((String)form.getCountry())) {
            if (!this.stateValid(form, AddressForm.class, "state", overviewSuccessForward, request)) {
                return displayForward;
            }
            if (!this.zipCodeMatchesCityAndState(form, AddressForm.class, "city", "state", "zipCode", request)) {
                return displayForward;
            }
        }
        if (StringUtils.isNotEmpty((String)(associateId = form.getAssociateId()))) {
            Person updatedPerson = (Person)person.clone();
            Association association = this.getAssociationById(updatedPerson, associateId);
            if (association != null) {
                this.conversionService.convert((Object)form, (Object)association);
                updatedPerson = this.getAssociationService().updateAssociation(updatedPerson, association);
                this.updateSelectedPerson(request, updatedPerson);
            } else {
                this.addActionMessage(request, "message.associateNotFound");
            }
        }
        return overviewSuccessForward;
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    protected Map getKeyMethodMap() {
        if (this.keyMethodMap == null) {
            this.keyMethodMap = new HashMap();
            this.keyMethodMap.put("button.display", "display");
            this.keyMethodMap.put("button.reset", "display");
            this.keyMethodMap.put("button.update", "updateAssociate");
            this.keyMethodMap.put("button.cancel", "cancel");
        }
        return this.keyMethodMap;
    }
}

