/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.ui.common.action.AddressConversionService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.demographic.action.PersonAssociationInfoForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;

public class PersonAssociationConversionService
extends AddressConversionService {
    public Object convert(Object source, Class targetClass) throws ConversionServiceException {
        return null;
    }

    @Override
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (source instanceof PersonAssociationInfoForm && target instanceof Association) {
            try {
                PersonAssociationInfoForm form = (PersonAssociationInfoForm)((Object)source);
                Association association = (Association)target;
                association.setRelationship(StringUtils.isBlank((String)form.getRelationship()) ? null : form.getRelationship());
                if (StringUtils.isNotEmpty((String)form.getRole())) {
                    AssociationType type = (AssociationType)this.getLookupCacheService().getByCodeFromCache(AssociationType.class, form.getRole());
                    association.setType(type);
                } else {
                    association.setType(null);
                }
                association.setOrganizationName(StringUtils.isBlank((String)form.getOrganizationName()) ? null : form.getOrganizationName());
                association.setFirstName(StringUtils.isBlank((String)form.getFirstName()) ? null : form.getFirstName());
                association.setMiddleName(StringUtils.isBlank((String)form.getMiddleName()) ? null : form.getMiddleName());
                association.setLastName(StringUtils.isBlank((String)form.getLastName()) ? null : form.getLastName());
                if (form.isAnyAddressFieldFilled()) {
                    Address address = association.getAddress();
                    if (address == null) {
                        address = new Address();
                        association.setAddress(address);
                    }
                    this.convertFormToAddress(form, address);
                } else {
                    association.setAddress(null);
                }
                association.setPrimaryPhone(StringUtils.isBlank((String)form.getPhone()) ? null : Phone.getFormattedPhone((String)form.getPhone()));
                association.setDeactivationDate(DateUtils.getDate((String)form.getDeactivationDate()));
            }
            catch (Exception ex) {
                throw new ConversionServiceException("Error while converting PersonAssociationInfoForm to Association.", ex);
            }
        }
        if (source instanceof Association && target instanceof PersonAssociationInfoForm) {
            try {
                Association association = (Association)source;
                PersonAssociationInfoForm form = (PersonAssociationInfoForm)((Object)target);
                form.setRelationship(association.getRelationship());
                if (association.getType() != null) {
                    form.setRole(association.getType().getCode());
                }
                form.setOrganizationName(association.getOrganizationName());
                form.setFirstName(association.getFirstName());
                form.setMiddleName(association.getMiddleName());
                form.setLastName(association.getLastName());
                Address address = association.getAddress();
                if (address != null) {
                    this.convertAddressToForm(address, form);
                }
                form.setPhone(Phone.getFormattedPhone((String)association.getPrimaryPhone()));
                Date phoneChangeDate = association.getPrimaryPhoneChangeDate();
                if (phoneChangeDate != null) {
                    form.setPhoneChangeDate(DateUtils.formatWithTime((Date)phoneChangeDate, null));
                }
                form.setDeactivationDate(DateUtils.format((Date)association.getDeactivationDate(), null));
            }
            catch (Exception ex) {
                throw new ConversionServiceException("Error while converting Association to PersonAssociationInfoForm.", ex);
            }
        }
    }
}

