/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.ui.demographic.action.PersonAssociationAction;
import gov.va.med.esr.ui.demographic.action.PersonAssociationInfoForm;
import gov.va.med.esr.ui.util.SessionManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class PersonAssociationAddAction
extends PersonAssociationAction {
    public ActionForward display(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PersonAssociationInfoForm form = (PersonAssociationInfoForm)actionForm;
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        form.setAddAPerson(isAddAPerson);
        return mapping.findForward("display");
    }

    public ActionForward clear(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PersonAssociationInfoForm form = (PersonAssociationInfoForm)actionForm;
        form.clearForm();
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        form.setAddAPerson(isAddAPerson);
        return mapping.findForward("display");
    }

    public ActionForward addAssociate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PersonAssociationInfoForm form = (PersonAssociationInfoForm)actionForm;
        Person person = this.getSelectedPerson(request);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        form.setAddAPerson(isAddAPerson);
        String errText = "{0} required for this role";
        ActionForward overviewSuccessForward = new ActionForward(mapping.findForward("overviewWithMessage"));
        ActionForward displayForward = mapping.findForward("display");
        if (!this.performRoleValidation(form, request, errText)) {
            return displayForward;
        }
        if (Country.isUSAddress((String)form.getCountry())) {
            boolean addressValid = true;
            if (!this.stateValid(form, AddressForm.class, "state", overviewSuccessForward, request)) {
                addressValid = false;
            }
            if (!this.zipCodeMatchesCityAndState(form, AddressForm.class, "city", "state", "zipCode", request)) {
                addressValid = false;
            }
            if (addressValid && form.getAddressLine1().length() == 0) {
                addressValid = false;
            }
            if (!this.validateAddressPhone(form, request)) {
                return displayForward;
            }
        }
        Association association = new Association();
        this.conversionService.convert((Object)form, (Object)association);
        Person updatedPerson = (Person)person.clone();
        updatedPerson.addAssociation(association);
        if (isAddAPerson) {
            if (association != null) {
                updatedPerson = association.getPerson();
            }
            association.setLastUpdateDate(new Date());
            this.updateSelectedPerson(request, updatedPerson);
        } else {
            updatedPerson = this.getAssociationService().updateAssociation(updatedPerson, association);
            this.updateSelectedPerson(request, updatedPerson);
        }
        return overviewSuccessForward;
    }

    private boolean performRoleValidation(PersonAssociationInfoForm form, HttpServletRequest request, String errText) throws Exception {
        String role = form.getRole();
        ActionMessages errors = form.getActionMessages(request);
        boolean valid = true;
        if (role.equals(AssociationType.CODE_POWER_OF_ATTORNEY.getCode()) || role.equals(AssociationType.CODE_GUARDIAN_VA.getCode()) || role.equals(AssociationType.CODE_GUARDIAN_CIVIL.getCode())) {
            String str = form.getOrganizationName();
            if (str.length() == 0) {
                valid = false;
                errors.add("orginazationName", new ActionMessage("errors.required", (Object)"Organization"));
            }
        } else if (role.equals(AssociationType.CODE_DESIGNEE.getCode())) {
            boolean validName = this.validateNames(errors, form);
            boolean validAddress = this.validateAddressPhone(form, request);
            valid = validName && validAddress;
        } else if (role.equals(AssociationType.CODE_EMERGENCY_CONTACT.getCode()) || role.equals(AssociationType.CODE_OTHER_EMERGENCY_CONTACT.getCode()) || role.equals(AssociationType.CODE_PRIMARY_NEXT_OF_KIN.getCode()) || role.equals(AssociationType.CODE_OTHER_NEXT_OF_KIN.getCode())) {
            boolean validRelationship = true;
            boolean validName = this.validateNames(errors, form);
            boolean validAddress = this.validateAddressPhone(form, request);
            if (form.getRelationship().length() == 0) {
                validRelationship = false;
                errors.add("relationship", new ActionMessage("errors.required", (Object)"Relationship"));
            }
            valid = validName && validAddress && validRelationship;
        }
        return valid;
    }

    private boolean validateAddressPhone(PersonAssociationInfoForm form, HttpServletRequest request) throws Exception {
        boolean addressComplete;
        String role = form.getRole();
        ActionMessages errors = form.getActionMessages(request);
        boolean valid = true;
        if ((role.equals(AssociationType.CODE_DESIGNEE.getCode()) || role.equals(AssociationType.CODE_EMERGENCY_CONTACT.getCode()) || role.equals(AssociationType.CODE_OTHER_EMERGENCY_CONTACT.getCode()) || role.equals(AssociationType.CODE_PRIMARY_NEXT_OF_KIN.getCode()) || role.equals(AssociationType.CODE_OTHER_NEXT_OF_KIN.getCode())) && !(addressComplete = this.isAddressComplete(form, request)) && form.getPhone().length() == 0) {
            valid = false;
            errors.add("phone", new ActionMessage("errors.detail", (Object)"Address or phone number is required"));
            errors.add("addressLine1", new ActionMessage("errors.detail", (Object)"Full Address or phone number is required"));
        }
        return valid;
    }

    private boolean isAddressComplete(PersonAssociationInfoForm form, HttpServletRequest request) {
        boolean isComplete = true;
        if (form.getAddressLine1().length() == 0 || form.getCity().length() == 0 || form.getState().length() == 0 || form.getZipCode().length() == 0) {
            isComplete = false;
        }
        return isComplete;
    }

    private boolean validateNames(ActionMessages errors, PersonAssociationInfoForm form) {
        boolean valid = true;
        String errText = "{0} required for this role";
        if (form.getFirstName().length() == 0) {
            valid = false;
            errors.add("firstName", new ActionMessage("errors.required", (Object)"First Name"));
        }
        if (form.getLastName().length() == 0) {
            valid = false;
            errors.add("lastName", new ActionMessage("errors.detail", (Object)"Last Name is required"));
        }
        return valid;
    }

    private void validateVAGuardian(HttpServletRequest request) {
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    protected Map getKeyMethodMap() {
        if (this.keyMethodMap == null) {
            this.keyMethodMap = new HashMap();
            this.keyMethodMap.put("button.addAssociate", "display");
            this.keyMethodMap.put("button.add", "addAssociate");
            this.keyMethodMap.put("button.clear", "clear");
            this.keyMethodMap.put("button.cancel", "cancel");
        }
        return this.keyMethodMap;
    }
}

