/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressValidationAction;
import gov.va.med.fw.model.EntityKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PersonAssociationAction
extends AddressValidationAction {
    public static final String DISPLAY = "display";
    public static final String OVERVIEW = "overview";
    public static final String OVERVIEW_WITH_MESSAGE = "overviewWithMessage";
    public static final String ASSOCIATE_ID = "associateId";
    public static final String ASSOCIATE_KEY = "associateKey";
    public static final String ASSOCIATIONS = "associations";
    public static final String USER_ACTION = "userAction";
    public static final String MESSAGE_ASSOCIATE_NOT_FOUND = "message.associateNotFound";
    public static final String MESSAGE_ASSOCIATION_ADDED = "message.association.added";
    public static final String MESSAGE_ASSOCIATION_UPDATED = "message.association.updated";

    public void afterPropertiesSet() {
        Validate.notNull((Object)this.getAssociationService(), (String)"An association service is a required component");
    }

    public ActionForward overview(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = this.getSelectedPerson(request);
        List associations = this.getSortedAssociations(person);
        request.setAttribute(ASSOCIATIONS, (Object)associations);
        return mapping.findForward(DISPLAY);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(OVERVIEW);
    }

    protected Association getAssociationById(Person person, String associateId) {
        EntityKey key = CommonEntityKeyFactory.createAssociationEntityKey((String)associateId);
        return person.getAssociationByEntityKey(key);
    }

    private List getSortedAssociations(Person person) {
        ArrayList associations = new ArrayList(person.getAssociations());
        Collections.sort(associations);
        return associations;
    }
}

