/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressValidationAction;
import gov.va.med.esr.ui.demographic.action.InsuranceInfoForm;
import gov.va.med.esr.ui.util.SessionManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class InsuranceInfoAction
extends AddressValidationAction {
    public static final String FORWARD_RETURN_TO_SAME_PAGE = "success";
    public static final String FORWARD_TO_OVERVIEW_PAGE = "overview";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InsuranceInfoForm insForm;
        InsuranceInfoForm insuranceInfoForm = insForm = form instanceof InsuranceInfoForm ? (InsuranceInfoForm)form : null;
        if (insForm != null) {
            boolean isAddAPerson = false;
            isAddAPerson = SessionManager.isAddAPerson(request);
            insForm.setAddAPerson(isAddAPerson);
            this.getInsuranceInfo(insForm, this.getSelectedPerson(request));
        }
        return mapping.findForward(FORWARD_RETURN_TO_SAME_PAGE);
    }

    public ActionForward addPrivateIns(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InsuranceInfoForm insForm;
        InsuranceInfoForm insuranceInfoForm = insForm = form instanceof InsuranceInfoForm ? (InsuranceInfoForm)form : null;
        if (insForm != null) {
            insForm.setMedicareInd(false);
            boolean isAddAPerson = false;
            isAddAPerson = SessionManager.isAddAPerson(request);
            insForm.setAddAPerson(isAddAPerson);
        }
        return mapping.findForward("addPrivateIns");
    }

    public ActionForward addMedicare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InsuranceInfoForm insForm;
        InsuranceInfoForm insuranceInfoForm = insForm = form instanceof InsuranceInfoForm ? (InsuranceInfoForm)form : null;
        if (insForm != null) {
            insForm.setMedicareInd(true);
            boolean isAddAPerson = false;
            isAddAPerson = SessionManager.isAddAPerson(request);
            insForm.setAddAPerson(isAddAPerson);
        }
        return mapping.findForward("addMedicare");
    }

    private void getInsuranceInfo(InsuranceInfoForm form, Person person) {
        ArrayList insurances = new ArrayList(person.getInsurances());
        Collections.sort(insurances);
        for (InsurancePolicy insPolicy : insurances) {
            if (insPolicy.isSiteRecord()) {
                form.addSiteInsurance(insPolicy);
                continue;
            }
            form.addHecInsurance(insPolicy);
        }
    }

    protected InsurancePolicy getInsuranceById(Person person, String insuranceId) {
        BigDecimal id = new BigDecimal(insuranceId);
        Set insurances = person.getInsurances();
        if (insurances != null && !insurances.isEmpty()) {
            for (InsurancePolicy insurancePolicy : insurances) {
                if (insurancePolicy == null || insurancePolicy.getEntityKey() == null || id == null || !id.equals(insurancePolicy.getEntityKey().getKeyValue())) continue;
                return insurancePolicy;
            }
        }
        return null;
    }

    public void afterPropertiesSet() {
    }
}

