/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.ui.demographic.action.InsuranceInfoAction;
import gov.va.med.esr.ui.demographic.action.InsuranceInfoForm;
import gov.va.med.esr.ui.demographic.action.InsuranceMedicareForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.validation.ValidationMessages;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class InsuranceEditAction
extends InsuranceInfoAction {
    @Override
    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InsuranceInfoForm insForm;
        InsuranceInfoForm insuranceInfoForm = insForm = form instanceof InsuranceInfoForm ? (InsuranceInfoForm)form : null;
        if (insForm != null) {
            Person person;
            InsurancePolicy insPolicy;
            boolean isAddAPerson = false;
            isAddAPerson = SessionManager.isAddAPerson(request);
            insForm.setAddAPerson(isAddAPerson);
            String insuranceId = insForm.getInsuranceId();
            if (StringUtils.isNotEmpty((String)insuranceId) && (insPolicy = this.getInsuranceById(person = this.getSelectedPerson(request), insuranceId)) != null) {
                this.prepopulateForm(insForm, insPolicy);
            }
        }
        return mapping.findForward("success");
    }

    public ActionForward editMedicare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InsuranceMedicareForm medicareForm = (InsuranceMedicareForm)form;
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        medicareForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        this.conversionService.convert((Object)person, (Object)medicareForm);
        return mapping.findForward("success");
    }

    public ActionForward copyPartAtoB(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InsuranceMedicareForm medicareForm = (InsuranceMedicareForm)form;
        medicareForm.copyPartAtoB();
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        medicareForm.setAddAPerson(isAddAPerson);
        return mapping.getInputForward();
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person clonePerson;
        InsurancePolicy insPolicy;
        String insuranceId;
        if (form instanceof InsuranceMedicareForm) {
            return this.updateMedicare(mapping, form, request, response);
        }
        InsuranceInfoForm insForm = form instanceof InsuranceInfoForm ? (InsuranceInfoForm)form : null;
        ActionForward samePageForward = mapping.findForward("success");
        if (insForm == null) {
            return samePageForward;
        }
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        insForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        ActionForward overviewSuccessForward = new ActionForward(mapping.findForward("overview"));
        if (Country.isUSAddress((String)insForm.getCountry())) {
            if (!this.stateValid(insForm, AddressForm.class, "state", overviewSuccessForward, request)) {
                return samePageForward;
            }
            if (!this.zipCodeMatchesCityAndState(insForm, AddressForm.class, "city", "state", "zipCode", request)) {
                return samePageForward;
            }
        }
        if (StringUtils.isNotEmpty((String)(insuranceId = insForm.getInsuranceId())) && (insPolicy = this.getInsuranceById(clonePerson = (Person)person.clone(), insuranceId)) != null) {
            this.conversionService.convert((Object)form, (Object)insPolicy);
            ValidationMessages messages = new ValidationMessages();
            if (!isAddAPerson) {
                messages = this.getInsuranceService().updateInsurance(clonePerson);
            }
            this.updateSelectedPerson(request, clonePerson);
            return this.getForwardPathFromValidationMessages(mapping, messages, "overview");
        }
        return overviewSuccessForward;
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AddressForm insForm;
        Person person = this.getSelectedPerson(request);
        Person clonePerson = (Person)person.clone();
        if (form instanceof InsuranceMedicareForm) {
            insForm = (InsuranceMedicareForm)form;
            boolean isAddAPerson = false;
            isAddAPerson = SessionManager.isAddAPerson(request);
            insForm.setAddAPerson(isAddAPerson);
            Medicare partA = null;
            Medicare partB = null;
            for (InsurancePolicy insPolicy : clonePerson.getInsurances()) {
                if (!(insPolicy instanceof Medicare) || insPolicy.getReportSite() != null && !VAFacility.CODE_HEC.getName().equals(insPolicy.getReportSite().getStationNumber())) continue;
                Medicare medicare = (Medicare)insPolicy;
                if (medicare.isEnrolledInPartB() != null && Boolean.TRUE.equals(medicare.isEnrolledInPartB())) {
                    partB = medicare;
                    continue;
                }
                if (medicare.isEnrolledInPartA() != null && Boolean.TRUE.equals(medicare.isEnrolledInPartA())) {
                    partA = medicare;
                    continue;
                }
                throw new ConversionServiceException("Medicare Insurance found without Part A or B indicators");
            }
            if (partA != null) {
                clonePerson.removeInsurance(partA);
            }
            if (partB != null) {
                clonePerson.removeInsurance(partB);
            }
        } else {
            AddressForm addressForm = insForm = form instanceof InsuranceInfoForm ? (InsuranceInfoForm)form : null;
            if (insForm != null) {
                InsurancePolicy insPolicy;
                boolean isAddAPerson = false;
                isAddAPerson = SessionManager.isAddAPerson(request);
                insForm.setAddAPerson(isAddAPerson);
                String insuranceId = ((InsuranceInfoForm)insForm).getInsuranceId();
                if (StringUtils.isNotEmpty((String)insuranceId) && (insPolicy = this.getInsuranceById(clonePerson, insuranceId)) != null) {
                    clonePerson.removeInsurance(insPolicy);
                }
            }
        }
        ValidationMessages messages = this.getInsuranceService().updateInsurance(clonePerson);
        this.updateSelectedPerson(request, clonePerson);
        return new ActionForward(mapping.findForward("overview"));
    }

    public ActionForward updateMedicare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InsuranceMedicareForm insForm = (InsuranceMedicareForm)form;
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        insForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        ActionForward overviewSuccessForward = new ActionForward(mapping.findForward("overview"));
        ActionForward samePageForward = mapping.findForward("success");
        if (Country.isUSAddress((String)insForm.getCountry())) {
            if (!this.stateValid(insForm, AddressForm.class, "state", overviewSuccessForward, request)) {
                return samePageForward;
            }
            if (!this.zipCodeMatchesCityAndState(insForm, AddressForm.class, "city", "state", "zipCode", request)) {
                return samePageForward;
            }
        }
        if (Country.isUSAddress((String)insForm.getCountry2())) {
            if (!this.stateValid(insForm, InsuranceMedicareForm.class, "state2", overviewSuccessForward, request)) {
                return samePageForward;
            }
            if (!this.zipCodeMatchesCityAndState(insForm, InsuranceMedicareForm.class, "city2", "state2", "zipCode2", request)) {
                return samePageForward;
            }
        }
        Person clonePerson = (Person)person.clone();
        this.conversionService.convert((Object)form, (Object)clonePerson);
        ValidationMessages messages = new ValidationMessages();
        if (!isAddAPerson) {
            messages = this.getInsuranceService().updateInsurance(clonePerson);
        }
        this.updateSelectedPerson(request, clonePerson);
        return this.getForwardPathFromValidationMessages(mapping, messages, "overview");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("cancel");
    }

    protected Map getKeyMethodMap() {
        if (this.keyMethodMap == null) {
            this.keyMethodMap = new HashMap();
            this.keyMethodMap.put("button.display", "display");
            this.keyMethodMap.put("button.update", "update");
            this.keyMethodMap.put("button.delete", "delete");
            this.keyMethodMap.put("button.cancel", "cancel");
            this.keyMethodMap.put("text.editMedicare", "editMedicare");
            this.keyMethodMap.put("button.addMedicare", "editMedicare");
            this.keyMethodMap.put("button.copyPartAData", "copyPartAtoB");
        }
        return this.keyMethodMap;
    }

    private void prepopulateForm(InsuranceInfoForm form, InsurancePolicy insurance) throws ConversionServiceException {
        if (this.conversionService != null) {
            this.conversionService.convert((Object)insurance, (Object)form);
        }
    }
}

