/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.insurance.InsurancePlan;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.InsuranceSubscriber;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.InsurancePlanType;
import gov.va.med.esr.common.model.lookup.InsuranceReportSource;
import gov.va.med.esr.common.model.lookup.InsuredRelationship;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.action.AddressConversionService;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.demographic.action.InsuranceInfoForm;
import gov.va.med.esr.ui.demographic.action.InsuranceMedicareForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;

public class InsuranceConversionService
extends AddressConversionService {
    @Override
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        if (source instanceof Person && target instanceof InsuranceMedicareForm) {
            this.convertPersonToForm((Person)source, (InsuranceMedicareForm)((Object)target));
        } else if (source instanceof InsuranceMedicareForm && target instanceof Person) {
            this.convertFormToPerson((InsuranceMedicareForm)((Object)source), (Person)target);
        } else if (source instanceof InsurancePolicy && target instanceof InsuranceInfoForm) {
            this.convertPolicyToForm((InsurancePolicy)source, (InsuranceInfoForm)((Object)target));
        } else if (source instanceof InsuranceInfoForm && target instanceof InsurancePolicy) {
            this.convertFormToPolicy((InsuranceInfoForm)((Object)source), (InsurancePolicy)target);
        } else {
            throw new ConversionServiceException("Conversion is not supported from " + source.getClass().getName() + " to " + target.getClass().getName());
        }
    }

    protected void convertPolicyToForm(InsurancePolicy policy, InsuranceInfoForm form) throws ConversionServiceException {
        try {
            Person person = policy.getPerson();
            form.setGroupName(policy.getGroupName());
            form.setGroupNumber(policy.getGroupNumber());
            if (person.getDeathRecord() != null && person.getDeathRecord().getDeathDate() != null) {
                String dod = DateUtils.format((ImpreciseDate)person.getDeathRecord().getDeathDate(), null);
                form.setDateOfDeath(dod);
            }
            if (person.getBirthRecord() != null && person.getBirthRecord().getBirthDate() != null) {
                String dob = DateUtils.format((ImpreciseDate)person.getBirthRecord().getBirthDate(), null);
                form.setDateOfBirth(dob);
            }
            if (policy instanceof PrivateInsurance) {
                InsuranceSubscriber subscriber;
                InsurancePlan plan;
                PrivateInsurance pIns = (PrivateInsurance)policy;
                form.setMedicareInd(false);
                form.setInsCompanyName(pIns.getCompanyName());
                form.setPolicyNumber(pIns.getPolicyNumber());
                if (pIns.getPolicyEffectiveDate() != null) {
                    form.setEffDate(DateUtils.format((ImpreciseDate)pIns.getPolicyEffectiveDate(), null));
                }
                if (pIns.getPolicyExpirationDate() != null) {
                    form.setExpDate(DateUtils.formatForEdit((ImpreciseDate)pIns.getPolicyExpirationDate(), null));
                }
                if ((plan = policy.getInsurancePlan()) != null) {
                    form.setTypeOfIns(plan.getPlanType().getCode());
                    if (plan.getPrecertificationRequired() != null) {
                        if (Boolean.TRUE.equals(plan.getPrecertificationRequired())) {
                            form.setPrecertReq("y");
                        } else {
                            form.setPrecertReq("n");
                        }
                    }
                }
                if ((subscriber = policy.getSubscriber()) != null) {
                    form.setNameOfInsured(subscriber.getName());
                    if (subscriber.getRelationship() != null) {
                        form.setRelationshipToVeteran(subscriber.getRelationship().getCode());
                    }
                }
            }
            if (policy instanceof Medicare) {
                Medicare mpolicy = (Medicare)policy;
                form.setMedicareInd(true);
                form.setInsCompanyName("Medicare");
                form.setNameOnMedicareCard(mpolicy.getNameOnMedicareCard());
                form.setMedicareClaimNbr(mpolicy.getMedicareClaimNumber());
                if (Boolean.TRUE.equals(mpolicy.getEnrolledInPartA()) && Boolean.TRUE.equals(mpolicy.getEnrolledInPartB())) {
                    form.setIsEnrolledInPartA("y");
                    form.setIsEnrolledInPartB("y");
                    form.setTypeOfMedicare("Part A and B");
                } else if (Boolean.TRUE.equals(mpolicy.getEnrolledInPartA())) {
                    form.setIsEnrolledInPartA("y");
                    form.setTypeOfMedicare("Part A");
                    form.setIsEnrolledInPartB("n");
                } else if (Boolean.TRUE.equals(mpolicy.getEnrolledInPartB())) {
                    form.setIsEnrolledInPartA("n");
                    form.setIsEnrolledInPartB("y");
                    form.setTypeOfMedicare("Part B");
                } else {
                    form.setIsEnrolledInPartA("n");
                    form.setIsEnrolledInPartB("n");
                    form.setTypeOfMedicare(null);
                }
                if (mpolicy != null && mpolicy.getPartAEffectiveDate() != null) {
                    form.setPartAEffectiveDate(DateUtils.format((ImpreciseDate)mpolicy.getPartAEffectiveDate(), null));
                }
                if (mpolicy != null && mpolicy.getPartBEffectiveDate() != null) {
                    form.setPartBEffectiveDate(DateUtils.format((ImpreciseDate)mpolicy.getPartBEffectiveDate(), null));
                }
            }
            Address address = policy.getAddress();
            this.convertAddressToForm(address, form);
            Phone preCertificationPhone = policy.getPreCertificationPhone();
            form.setPreCertificationPhone(preCertificationPhone == null ? null : preCertificationPhone.getFormattedPhone());
            Phone phoneNbr = policy.getBusinessPhone();
            form.setPhone(phoneNbr == null ? null : phoneNbr.getFormattedPhone());
            Phone faxNbr = policy.getFax();
            form.setFax(faxNbr == null ? null : faxNbr.getFormattedPhone());
            if (policy.getReportSource() != null) {
                form.setSourceOfUpdate(policy.getReportSource().getCode());
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert policy to InsuranceInfoForm.", ex);
        }
    }

    protected void convertFormToPolicy(InsuranceInfoForm form, InsurancePolicy policy) throws ConversionServiceException {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        try {
            policy.setGroupName(StringUtils.isEmpty((String)form.getGroupName()) ? null : form.getGroupName());
            policy.setGroupNumber(StringUtils.isEmpty((String)form.getGroupNumber()) ? null : form.getGroupNumber());
            policy.setReportSite((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, VAFacility.CODE_HEC.getName()));
            policy.setReportSource((InsuranceReportSource)lookupCacheService.getByCodeFromCache(InsuranceReportSource.class, form.getSourceOfUpdate()));
            if (policy instanceof PrivateInsurance) {
                PrivateInsurance pIns = (PrivateInsurance)policy;
                pIns.setCompanyName(form.getInsCompanyName());
                pIns.setPolicyNumber(form.getPolicyNumber());
                pIns.setPolicyEffectiveDate(DateUtils.getImpreciseDate((String)form.getEffDate(), (boolean)false, (boolean)true));
                String formExpDate = form.getExpDate();
                ImpreciseDate dateWithTime = DateUtils.getImpreciseDate((String)formExpDate, (boolean)true, (boolean)true);
                if (dateWithTime != null) {
                    String impreciseString = dateWithTime.toStandardFormat();
                    if (impreciseString.length() > 8) {
                        if (!dateWithTime.equals((Object)pIns.getPolicyExpirationDate())) {
                            impreciseString = impreciseString.substring(0, 8);
                            ImpreciseDate dateWithoutTime = new ImpreciseDate(impreciseString);
                            pIns.setPolicyExpirationDate(dateWithoutTime);
                        }
                    } else {
                        pIns.setPolicyExpirationDate(dateWithTime);
                    }
                } else {
                    pIns.setPolicyExpirationDate(dateWithTime);
                }
                if (StringUtils.isEmpty((String)form.getTypeOfIns())) {
                    policy.setInsurancePlan(null);
                } else {
                    InsurancePlan plan = policy.getInsurancePlan();
                    if (plan == null) {
                        plan = new InsurancePlan();
                        if (StringUtils.isNotEmpty((String)form.getPrecertReq())) {
                            if (StringUtils.equals((String)form.getPrecertReq(), (String)"y")) {
                                plan.setPrecertificationRequired(Boolean.TRUE);
                            } else {
                                plan.setPrecertificationRequired(Boolean.FALSE);
                            }
                        }
                        policy.setInsurancePlan(plan);
                    }
                    plan.setPlanType((InsurancePlanType)lookupCacheService.getByCodeFromCache(InsurancePlanType.class, form.getTypeOfIns()));
                }
                if (StringUtils.isEmpty((String)form.getNameOfInsured()) && StringUtils.isEmpty((String)form.getRelationshipToVeteran())) {
                    policy.setSubscriber(null);
                } else {
                    InsuranceSubscriber subscriber = this.getSubscriber(policy);
                    subscriber.setName(StringUtils.isEmpty((String)form.getNameOfInsured()) ? null : form.getNameOfInsured());
                    this.setRelationshipToVeteran(subscriber, form.getRelationshipToVeteran());
                }
            }
            if (policy instanceof Medicare) {
                Medicare mpolicy = (Medicare)policy;
                mpolicy.setNameOnMedicareCard(form.getNameOnMedicareCard());
                mpolicy.setMedicareClaimNumber(form.getMedicareClaimNbr());
                if (StringUtils.isNotEmpty((String)form.getTypeOfMedicare())) {
                    if (StringUtils.equals((String)form.getTypeOfMedicare(), (String)"Part A")) {
                        mpolicy.setEnrolledInPartA(Boolean.TRUE);
                        mpolicy.setEnrolledInPartB(Boolean.FALSE);
                    } else if (StringUtils.equals((String)form.getTypeOfMedicare(), (String)"Part B")) {
                        mpolicy.setEnrolledInPartB(Boolean.TRUE);
                        mpolicy.setEnrolledInPartA(Boolean.FALSE);
                    } else if (StringUtils.equals((String)form.getTypeOfMedicare(), (String)"Part A and B")) {
                        mpolicy.setEnrolledInPartA(Boolean.TRUE);
                        mpolicy.setEnrolledInPartB(Boolean.TRUE);
                    }
                } else {
                    mpolicy.setEnrolledInPartA(Boolean.FALSE);
                    mpolicy.setEnrolledInPartB(Boolean.FALSE);
                }
                if (mpolicy != null && mpolicy.getPartAEffectiveDate() != null) {
                    form.setPartAEffectiveDate(DateUtils.format((ImpreciseDate)mpolicy.getPartAEffectiveDate(), null));
                }
                if (mpolicy != null && mpolicy.getPartBEffectiveDate() != null) {
                    form.setPartBEffectiveDate(DateUtils.format((ImpreciseDate)mpolicy.getPartBEffectiveDate(), null));
                }
            }
            if (form.isAnyAddressFieldFilled()) {
                Address address = policy.getAddress();
                if (address == null) {
                    address = new Address();
                    AddressType type = (AddressType)lookupCacheService.getByCodeFromCache(AddressType.class, AddressType.CODE_BUSINESS_ADDRESS.getName());
                    address.setType(type);
                    policy.setAddress(address);
                }
                this.convertFormToAddress(form, address);
            } else {
                policy.setAddress(null);
            }
            if (StringUtils.isNotEmpty((String)form.getPreCertificationPhone())) {
                Phone preCertificationPhone = policy.getPreCertificationPhone();
                if (preCertificationPhone == null) {
                    preCertificationPhone = new Phone();
                    preCertificationPhone.setType((PhoneType)lookupCacheService.getByCodeFromCache(PhoneType.class, PhoneType.CODE_PRE_CERTIFICATION_PHONE.getName()));
                    policy.setPreCertificationPhone(preCertificationPhone);
                }
                preCertificationPhone.setPhoneNumber(Phone.getFormattedPhone((String)form.getPreCertificationPhone()));
            } else {
                policy.setPreCertificationPhone(null);
            }
            if (StringUtils.isNotEmpty((String)form.getPhone())) {
                Phone phoneNbr = policy.getBusinessPhone();
                if (phoneNbr == null) {
                    phoneNbr = new Phone();
                    phoneNbr.setType((PhoneType)lookupCacheService.getByCodeFromCache(PhoneType.class, PhoneType.CODE_BUSINESS.getName()));
                    policy.setBusinessPhone(phoneNbr);
                }
                phoneNbr.setPhoneNumber(Phone.getFormattedPhone((String)form.getPhone()));
            } else {
                policy.setBusinessPhone(null);
            }
            if (StringUtils.isNotEmpty((String)form.getFax())) {
                Phone faxNbr = policy.getFax();
                if (faxNbr == null) {
                    faxNbr = new Phone();
                    faxNbr.setType((PhoneType)lookupCacheService.getByCodeFromCache(PhoneType.class, PhoneType.CODE_FAX.getName()));
                    policy.setFax(faxNbr);
                }
                faxNbr.setPhoneNumber(Phone.getFormattedPhone((String)form.getFax()));
            } else {
                policy.setFax(null);
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert InsuranceInfoForm to Policy.", ex);
        }
    }

    protected void convertPersonToForm(Person person, InsuranceMedicareForm form) throws ConversionServiceException {
        Address address;
        InsuranceReportSource reportSource;
        Phone faxNbr;
        Phone phoneNbr;
        Medicare partA = null;
        Medicare partB = null;
        if (person != null && person.getBirthRecord() != null && person.getBirthRecord().getBirthDate() != null) {
            String dob = DateUtils.format((ImpreciseDate)person.getBirthRecord().getBirthDate(), null);
            form.setDateOfBirth(dob);
        }
        if (person != null && person.getDeathRecord() != null && person.getDeathRecord().getDeathDate() != null) {
            String dod = DateUtils.format((ImpreciseDate)person.getDeathRecord().getDeathDate(), null);
            form.setDateOfDeath(dod);
        }
        for (InsurancePolicy insPolicy : person.getInsurances()) {
            if (!(insPolicy instanceof Medicare) || insPolicy.getReportSite() != null && !VAFacility.CODE_HEC.getName().equals(insPolicy.getReportSite().getStationNumber())) continue;
            Medicare medicare = (Medicare)insPolicy;
            if (medicare.isEnrolledInPartB() != null && Boolean.TRUE.equals(medicare.isEnrolledInPartB())) {
                partB = medicare;
                continue;
            }
            if (medicare.isEnrolledInPartA() != null && Boolean.TRUE.equals(medicare.isEnrolledInPartA())) {
                partA = medicare;
                continue;
            }
            throw new ConversionServiceException("Medicare Insurance found without Part A or B indicators");
        }
        form.setTypeOfMedicare(partB == null ? "Part A" : "Part A and B");
        if (partA != null) {
            form.setInsuranceId(partA.getEntityKey() != null ? partA.getEntityKey().getKeyValueAsString() : "");
            form.setGroupName(partA.getGroupName());
            form.setGroupNumber(partA.getGroupNumber());
            form.setNameOnMedicareCard(partA.getNameOnMedicareCard());
            form.setMedicareClaimNbr(partA.getMedicareClaimNumber());
            form.setPartAEffectiveDate(DateUtils.format((ImpreciseDate)partA.getPartAEffectiveDate(), null));
            phoneNbr = partA.getBusinessPhone();
            form.setPhone(phoneNbr == null ? null : phoneNbr.getFormattedPhone());
            faxNbr = partA.getFax();
            form.setFax(faxNbr == null ? null : faxNbr.getFormattedPhone());
            reportSource = partA.getReportSource();
            form.setSourceOfUpdate(reportSource == null ? null : reportSource.getCode());
            address = partA.getAddress();
            this.convertAddressToForm(address, form);
        }
        if (partB != null) {
            form.setPartBInsuranceId(partB.getEntityKey() != null ? partB.getEntityKey().getKeyValueAsString() : "");
            form.setPartBGroupName(partB.getGroupName());
            form.setPartBGroupNumber(partB.getGroupNumber());
            form.setPartBNameOnMedicareCard(partB.getNameOnMedicareCard());
            form.setPartBMedicareClaimNbr(partB.getMedicareClaimNumber());
            form.setPartBEffectiveDate(DateUtils.format((ImpreciseDate)partB.getPartBEffectiveDate(), null));
            phoneNbr = partB.getBusinessPhone();
            form.setPartBPhone(phoneNbr == null ? null : phoneNbr.getFormattedPhone());
            faxNbr = partB.getFax();
            form.setPartBFax(faxNbr == null ? null : faxNbr.getFormattedPhone());
            reportSource = partB.getReportSource();
            form.setPartBSourceOfUpdate(reportSource == null ? null : reportSource.getCode());
            address = partB.getAddress();
            this.convertSecondAddressToForm(address, form);
        }
    }

    protected void convertFormToPerson(InsuranceMedicareForm form, Person person) throws ConversionServiceException {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        try {
            Medicare partA = null;
            Medicare partB = null;
            for (InsurancePolicy insPolicy : person.getInsurances()) {
                if (!(insPolicy instanceof Medicare) || insPolicy.getReportSite() != null && !VAFacility.CODE_HEC.getName().equals(insPolicy.getReportSite().getStationNumber())) continue;
                Medicare medicare = (Medicare)insPolicy;
                if (medicare.isEnrolledInPartB() != null && Boolean.TRUE.equals(medicare.isEnrolledInPartB())) {
                    partB = medicare;
                    continue;
                }
                if (medicare.isEnrolledInPartA() != null && Boolean.TRUE.equals(medicare.isEnrolledInPartA())) {
                    partA = medicare;
                    continue;
                }
                throw new ConversionServiceException("Medicare Insurance found with Part A or B indicators");
            }
            if (partA == null) {
                partA = new Medicare();
                person.addInsurance((InsurancePolicy)partA);
            } else if (partA.getEntityKey() != null && !StringUtils.equals((String)form.getInsuranceId(), (String)partA.getEntityKey().getKeyValueAsString())) {
                this.log.error((Object)"Medicare partA key in the database is different from the one being edited");
            }
            partA.setCompanyName(form.getInsCompanyName());
            partA.setGroupName(form.getGroupName());
            partA.setGroupNumber(form.getGroupNumber());
            partA.setReportSite((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, VAFacility.CODE_HEC.getName()));
            partA.setReportSource((InsuranceReportSource)lookupCacheService.getByCodeFromCache(InsuranceReportSource.class, form.getSourceOfUpdate()));
            partA.setNameOnMedicareCard(form.getNameOnMedicareCard());
            partA.setMedicareClaimNumber(form.getMedicareClaimNbr());
            partA.setEnrolledInPartA(Boolean.TRUE);
            partA.setEnrolledInPartB(Boolean.FALSE);
            partA.setPartAEffectiveDate(DateUtils.getImpreciseDate((String)form.getPartAEffectiveDate(), (boolean)false, (boolean)true));
            partA.setPartBEffectiveDate(null);
            Phone phoneNbr = partA.getBusinessPhone();
            if (StringUtils.isNotEmpty((String)form.getPhone())) {
                if (phoneNbr == null) {
                    phoneNbr = new Phone();
                    phoneNbr.setType((PhoneType)lookupCacheService.getByCodeFromCache(PhoneType.class, PhoneType.CODE_BUSINESS.getName()));
                    partA.setBusinessPhone(phoneNbr);
                }
                phoneNbr.setPhoneNumber(Phone.getFormattedPhone((String)form.getPhone()));
            } else {
                partA.setBusinessPhone(null);
            }
            Phone faxNbr = partA.getFax();
            if (StringUtils.isNotEmpty((String)form.getFax())) {
                if (faxNbr == null) {
                    faxNbr = new Phone();
                    faxNbr.setType((PhoneType)lookupCacheService.getByCodeFromCache(PhoneType.class, PhoneType.CODE_FAX.getName()));
                    partA.setFax(faxNbr);
                }
                faxNbr.setPhoneNumber(Phone.getFormattedPhone((String)form.getFax()));
            } else {
                partA.setFax(null);
            }
            if (form.isAnyAddressFieldFilled()) {
                Address address = partA.getAddress();
                if (address == null) {
                    address = new Address();
                    partA.setAddress(address);
                }
                this.convertFormToAddress(form, address);
            } else {
                partA.setAddress(null);
            }
            InsuranceSubscriber subscriber = this.getSubscriber((InsurancePolicy)partA);
            this.setRelationshipToVeteran(subscriber, null);
            if ("Part A and B".equals(form.getTypeOfMedicare())) {
                if (partB == null) {
                    partB = new Medicare();
                    person.addInsurance((InsurancePolicy)partB);
                } else if (partB.getEntityKey() != null && !StringUtils.equals((String)form.getPartBInsuranceId(), (String)partB.getEntityKey().getKeyValueAsString())) {
                    this.log.error((Object)"Medicare partB key in the database is different from the one being edited");
                }
                partB.setCompanyName(form.getInsCompanyName());
                partB.setGroupName(form.getPartBGroupName());
                partB.setGroupNumber(form.getPartBGroupNumber());
                partB.setReportSite((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, VAFacility.CODE_HEC.getName()));
                partB.setReportSource((InsuranceReportSource)lookupCacheService.getByCodeFromCache(InsuranceReportSource.class, form.getPartBSourceOfUpdate()));
                partB.setNameOnMedicareCard(form.getPartBNameOnMedicareCard());
                partB.setMedicareClaimNumber(form.getPartBMedicareClaimNbr());
                partB.setEnrolledInPartA(Boolean.TRUE);
                partB.setEnrolledInPartB(Boolean.TRUE);
                partB.setPartAEffectiveDate(null);
                partB.setPartBEffectiveDate(DateUtils.getImpreciseDate((String)form.getPartBEffectiveDate(), (boolean)false, (boolean)true));
                phoneNbr = partB.getBusinessPhone();
                if (StringUtils.isNotEmpty((String)form.getPartBPhone())) {
                    if (phoneNbr == null) {
                        phoneNbr = new Phone();
                        phoneNbr.setType((PhoneType)lookupCacheService.getByCodeFromCache(PhoneType.class, PhoneType.CODE_BUSINESS.getName()));
                        partB.setBusinessPhone(phoneNbr);
                    }
                    phoneNbr.setPhoneNumber(Phone.getFormattedPhone((String)form.getPartBPhone()));
                } else {
                    partB.setBusinessPhone(null);
                }
                faxNbr = partB.getFax();
                if (StringUtils.isNotEmpty((String)form.getPartBFax())) {
                    if (faxNbr == null) {
                        faxNbr = new Phone();
                        faxNbr.setType((PhoneType)lookupCacheService.getByCodeFromCache(PhoneType.class, PhoneType.CODE_FAX.getName()));
                        partB.setFax(faxNbr);
                    }
                    faxNbr.setPhoneNumber(Phone.getFormattedPhone((String)form.getPartBFax()));
                } else {
                    partB.setFax(null);
                }
                if (form.isAnyAddress2FieldFilled()) {
                    Address address = partB.getAddress();
                    if (address == null) {
                        address = new Address();
                        partB.setAddress(address);
                    }
                    this.convertFormToSecondAddress(form, address);
                } else {
                    partB.setAddress(null);
                }
                subscriber = this.getSubscriber((InsurancePolicy)partB);
                this.setRelationshipToVeteran(subscriber, null);
            } else if (partB != null) {
                person.removeInsurance((InsurancePolicy)partB);
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Conversion Failed");
        }
    }

    protected void convertSecondAddressToForm(Address address, InsuranceMedicareForm form) {
        if (address != null) {
            form.setAddressLine12(address.getLine1());
            form.setAddressLine22(address.getLine2());
            form.setAddressLine32(address.getLine3());
            if (address.getCountry() != null) {
                form.setCountry2(address.getCountry());
            }
            form.setCity2(address.getCity());
            form.setState2(address.getState());
            form.setCounty2(address.getCounty());
            form.setPrevZip2(address.getZipCode());
            form.setZipCode2(address.getZipCode());
            form.setZipPlus42(address.getZipPlus4());
        }
    }

    protected void setRelationshipToVeteran(InsuranceSubscriber subscriber, String relationshipCode) throws UnknownLookupTypeException, ClassNotFoundException {
        if (StringUtils.isBlank((String)relationshipCode)) {
            relationshipCode = InsuredRelationship.CODE_VETERAN.getName();
        }
        subscriber.setRelationship((InsuredRelationship)this.getLookupCacheService().getByCodeFromCache(InsuredRelationship.class, relationshipCode));
    }

    protected InsuranceSubscriber getSubscriber(InsurancePolicy policy) {
        InsuranceSubscriber subscriber = policy.getSubscriber();
        if (subscriber == null) {
            subscriber = new InsuranceSubscriber();
            policy.setSubscriber(subscriber);
        }
        return subscriber;
    }

    protected void convertFormToSecondAddress(InsuranceMedicareForm form, Address address) {
        address.setCountry(StringUtils.isBlank((String)form.getCountry2()) ? null : form.getCountry2());
        address.setLine1(StringUtils.isBlank((String)form.getAddressLine12()) ? null : form.getAddressLine12());
        address.setLine2(StringUtils.isBlank((String)form.getAddressLine22()) ? null : form.getAddressLine22());
        address.setLine3(StringUtils.isBlank((String)form.getAddressLine32()) ? null : form.getAddressLine32());
        address.setCity(StringUtils.isBlank((String)form.getCity2()) ? null : form.getCity2());
        if (form.isUSAddress()) {
            address.setCounty(StringUtils.isBlank((String)form.getCounty2()) ? null : form.getCounty2());
            address.setState(StringUtils.isBlank((String)form.getState2()) ? null : form.getState2());
            address.setZipCode(StringUtils.isBlank((String)form.getZipCode2()) ? null : form.getZipCode2());
            address.setZipPlus4(StringUtils.isBlank((String)form.getZipPlus42()) ? null : form.getZipPlus42());
            address.setProvince(null);
            address.setPostalCode(null);
        } else {
            address.setCounty(null);
            address.setState(null);
            address.setZipCode(null);
            address.setZipPlus4(null);
            address.setProvince(StringUtils.isBlank((String)form.getProvince2()) ? null : form.getProvince2());
            address.setPostalCode(StringUtils.isBlank((String)form.getPostalCode2()) ? null : form.getPostalCode2());
        }
    }
}

