/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.demographic.action.InsuranceInfoAction;
import gov.va.med.esr.ui.demographic.action.InsuranceInfoForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.validation.ValidationMessages;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class InsuranceAddAction
extends InsuranceInfoAction {
    @Override
    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("success");
    }

    public ActionForward add(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InsuranceInfoForm insForm = form instanceof InsuranceInfoForm ? (InsuranceInfoForm)form : null;
        ActionForward samePageForward = mapping.findForward("success");
        if (insForm == null) {
            return samePageForward;
        }
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        insForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        ActionForward overviewSuccessForward = new ActionForward(mapping.findForward("overview"));
        if (Country.isUSAddress((String)insForm.getCountry())) {
            if (!this.stateValid(insForm, AddressForm.class, "state", overviewSuccessForward, request)) {
                return samePageForward;
            }
            if (!this.zipCodeMatchesCityAndState(insForm, AddressForm.class, "city", "state", "zipCode", request)) {
                return samePageForward;
            }
        }
        PrivateInsurance policy = new PrivateInsurance();
        this.conversionService.convert((Object)insForm, (Object)policy);
        Person updatedPerson = (Person)person.clone();
        updatedPerson.addInsurance((InsurancePolicy)policy);
        ValidationMessages messages = new ValidationMessages();
        if (isAddAPerson) {
            this.updateSelectedPerson(request, updatedPerson);
        } else {
            messages = this.getInsuranceService().updateInsurance(updatedPerson);
            this.updateSelectedPerson(request, updatedPerson);
        }
        ActionForward successForward = this.getForwardPathFromValidationMessages(mapping, messages, "overview");
        return successForward;
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("cancel");
    }

    @Override
    public ActionForward addPrivateIns(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InsuranceInfoForm insForm;
        Person person = this.getSelectedPerson(request);
        InsuranceInfoForm insuranceInfoForm = insForm = form instanceof InsuranceInfoForm ? (InsuranceInfoForm)form : null;
        if (insForm != null) {
            insForm.setMedicareInd(false);
            boolean isAddAPerson = false;
            isAddAPerson = SessionManager.isAddAPerson(request);
            insForm.setAddAPerson(isAddAPerson);
            if (person.getDeathRecord() != null && person.getDeathRecord().getDeathDate() != null) {
                String dod = DateUtils.format((ImpreciseDate)person.getDeathRecord().getDeathDate(), null);
                insForm.setDateOfDeath(dod);
            }
            if (person.getBirthRecord() != null && person.getBirthRecord().getBirthDate() != null) {
                String dob = DateUtils.format((ImpreciseDate)person.getBirthRecord().getBirthDate(), null);
                insForm.setDateOfBirth(dob);
            }
        }
        return mapping.findForward("success");
    }

    @Override
    public ActionForward addMedicare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InsuranceInfoForm insForm;
        Person person = this.getSelectedPerson(request);
        InsuranceInfoForm insuranceInfoForm = insForm = form instanceof InsuranceInfoForm ? (InsuranceInfoForm)form : null;
        if (insForm != null) {
            insForm.setMedicareInd(true);
            insForm.setInsCompanyName("Medicare");
            boolean isAddAPerson = false;
            isAddAPerson = SessionManager.isAddAPerson(request);
            insForm.setAddAPerson(isAddAPerson);
            if (person.getBirthRecord() != null && person.getBirthRecord().getBirthDate() != null) {
                String dob = DateUtils.format((ImpreciseDate)person.getBirthRecord().getBirthDate(), null);
                insForm.setDateOfBirth(dob);
            }
            if (person.getDeathRecord() != null && person.getDeathRecord().getDeathDate() != null) {
                String dod = DateUtils.format((ImpreciseDate)person.getDeathRecord().getDeathDate(), null);
                insForm.setDateOfDeath(dod);
            }
        }
        return mapping.findForward("addMedicare");
    }

    protected Map getKeyMethodMap() {
        if (this.keyMethodMap == null) {
            this.keyMethodMap = new HashMap();
            this.keyMethodMap.put("button.add", "add");
            this.keyMethodMap.put("button.cancel", "cancel");
            this.keyMethodMap.put("button.addPrivateIns", "addPrivateIns");
            this.keyMethodMap.put("button.addMedicare", "addMedicare");
            this.keyMethodMap.put("button.display", "display");
        }
        return this.keyMethodMap;
    }
}

