/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.lookup.BenefitType;
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.lookup.EmergencyResponse;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.lookup.Language;
import gov.va.med.esr.common.model.lookup.MaritalStatus;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.Religion;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.SensitivityChangeSource;
import gov.va.med.esr.common.model.lookup.SourceDesignation;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.EmergencyResponseIndicator;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.PreferredLanguage;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.service.PreferredFacilityService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.action.AddressConversionService;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.demographic.action.DemographicPersonalForm;
import gov.va.med.esr.ui.util.ConvertUtils;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.Validate;

public class DemographicPersonalConversionService
extends AddressConversionService {
    public static final String NAME_BREAK = " ";
    public static final String VERIFIED = "(VERIFIED)";
    public static final String UNVERIFIED = "(UNVERIFIED)";
    private PreferredFacilityService preferredFacilityService;

    public PreferredFacilityService getPreferredFacilityService() {
        return this.preferredFacilityService;
    }

    public void setPreferredFacilityService(PreferredFacilityService preferredFacilityService) {
        this.preferredFacilityService = preferredFacilityService;
    }

    @Override
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        Validate.notNull((Object)source, (String)"DemographicPersonalConversionService source is null");
        Validate.notNull((Object)target, (String)"DemographicPersonalConversionService target is null");
        if (source instanceof Person && target instanceof DemographicPersonalForm) {
            this.convertPersontoForm((Person)source, (DemographicPersonalForm)((Object)target));
        } else if (target instanceof Person && source instanceof DemographicPersonalForm) {
            this.convertFormToPerson((DemographicPersonalForm)((Object)source), (Person)target);
        } else {
            throw new ConversionServiceException("Type mismatch: Can't convert from " + source.getClass().getName() + " to " + target.getClass().getName());
        }
    }

    private void convertPersontoForm(Person person, DemographicPersonalForm form) throws ConversionServiceException {
        try {
            boolean isAddAPerson = form.isAddAPerson();
            Boolean sensitiveRecord = person.getSensitiveRecord();
            form.setSensitivityFlag(sensitiveRecord != null && sensitiveRecord != false);
            if (person.getSensitivityChangeSource() != null) {
                form.setSensitivityFlagSourceOfUpdate(person.getSensitivityChangeSource().getCode());
            }
            if (person.getSensitivityChangeSite() != null) {
                form.setSensitivityFlagSiteOfUpdate(person.getSensitivityChangeSite().getCode());
            }
            form.setSensitivityFlagSourceOfUpdate(SensitivityChangeSource.CODE_HEC.getName());
            form.setSensitivityFlagSiteOfUpdate(VAFacility.CODE_HEC.getName());
            HashSet otherNames = new HashSet(person.getNames());
            Name name = person.getLegalName();
            if (name != null) {
                otherNames.remove(name);
            }
            form.setOtherNames(JspUtils.displayValues(otherNames, (String)"", null));
            SystemParameterService systemParameterService = (SystemParameterService)this.getComponent("systemParameterService");
            DeathRecord deathRecord = person.getDeathRecord();
            if (deathRecord != null) {
                if (deathRecord.getDeathDate() != null) {
                    form.setDateOfDeath(DateUtils.formatForEdit((ImpreciseDate)deathRecord.getDeathDate(), null));
                    form.setDeathNotificationSource(this.getLookupCode((Lookup)deathRecord.getDataSource()));
                    form.setDeathNotificationSite(this.getLookupCode((Lookup)deathRecord.getFacilityReceived()));
                    form.setDeathNotificationSourceDesc(deathRecord.getDataSource() != null ? deathRecord.getDataSource().getDescription() : null);
                    form.setDeathNotificationSiteName(deathRecord.getFacilityReceived() != null ? deathRecord.getFacilityReceived().getSiteNumberAndName() : null);
                    form.setDateOfDeathReport(DateUtils.formatWithTime((Date)deathRecord.getDeathReportDate(), null));
                    if (systemParameterService.getDODIndicator().booleanValue()) {
                        if (deathRecord.getDeathReportedBy() != null && deathRecord.getDeathReportedBy().equalsIgnoreCase("ES_USER")) {
                            form.setDodEditableFlag(true);
                        }
                    } else {
                        form.setDodEditableFlag(true);
                        form.setShowAllDeathSourcesFlag(true);
                    }
                } else {
                    form.setDodEditableFlag(true);
                }
            } else {
                if (!systemParameterService.getDODIndicator().booleanValue()) {
                    form.setShowAllDeathSourcesFlag(true);
                }
                form.setDodEditableFlag(true);
            }
            form.setDegree(person.getDegree());
            List preferredFacilities = this.getPreferredFacilityService().getDisplayPreferredFacilities(person);
            this.addPreferredFacilitiesToForm(preferredFacilities, form);
            if (person.getClaimFolderNumber() != null) {
                form.setClaimFolderNumber(person.getClaimFolderNumber());
            }
            form.setClaimFolderLocation(this.getLookupCode((Lookup)person.getClaimFolderLocation()));
            this.convertPersontoFormPreferredLanguage(person, form);
            this.populateEmergencyReponseToForm(person, form);
            if (person.getUserEnrolleeValidThrough() != null) {
                form.setUserEnrolleeValidthroughDate(person.getUserEnrolleeValidThrough().toString());
            }
            form.setUserEnrolleeSite(this.getLookupCode((Lookup)person.getUserEnrolleeSite()));
            form.setAppointmentRequestDate(DateUtils.format((Date)person.getAppointmentRequestDate(), null));
            Boolean response = person.getAppointmentRequestResponse();
            if (response == null) {
                form.setAppointmentRequestResponse(null);
            } else {
                form.setAppointmentRequestResponse(response != false ? "Yes" : "No");
            }
            form.setSsn(person.getOfficialSsn() == null || person.getOfficialSsn().getSsnText() == null ? null : person.getOfficialSsn().getSsnText().replaceAll("-", ""));
            HashSet otherSsns = new HashSet(person.getOtherSsns());
            form.setOtherSsns(JspUtils.displayValues(otherSsns, (String)"", null));
            if (form.getSensitivityFlagSourceOfUpdate() == null) {
                form.setSensitivityFlagSourceOfUpdate(SensitivityChangeSource.CODE_HEC.getName());
            }
            form.setMaritalStatus(this.getLookupCode((Lookup)person.getMaritalStatus()));
            form.setReligion(this.getReligion(person));
            form.setBenefitAppliedFor(this.getBenefitAppliedFor(person));
            if (isAddAPerson) {
                form.setNeedCareDueToAccident(ConvertUtils.convertYesNoNoData(person.getNeedCareDueToAccident()));
                form.setNeedCareDueToInjury(ConvertUtils.convertYesNoNoData(person.getNeedCareDueToInjury()));
                form.setOtherFirstNames(this.displayValues(this.getOtherFirstNames(person), "", null));
                form.setOtherLastNames(this.displayValues(this.getOtherLastNames(person), "", null));
                if (person.getFather() != null) {
                    form.setFathersFirstName(JspUtils.displayValue(person.getFather().getName() != null ? person.getFather().getName().getGivenName() : null, (String)""));
                    form.setFathersLastName(JspUtils.displayValue(person.getFather().getName() != null ? person.getFather().getName().getFamilyName() : null, (String)""));
                } else {
                    form.setFathersFirstName(JspUtils.displayValue(null, (String)""));
                    form.setFathersLastName(JspUtils.displayValue(null, (String)""));
                }
                if (person.getMother() != null) {
                    form.setMothersFirstName(JspUtils.displayValue(person.getMother().getName() != null ? person.getMother().getName().getGivenName() : null, (String)""));
                    form.setMothersLastName(JspUtils.displayValue(person.getMother().getName() != null ? person.getMother().getName().getFamilyName() : null, (String)""));
                } else {
                    form.setMothersFirstName(JspUtils.displayValue(null, (String)""));
                    form.setMothersLastName(JspUtils.displayValue(null, (String)""));
                }
            } else {
                form.setFathersName(JspUtils.displayValue((Object)(person.getFather() != null ? person.getFather().getName() : null), (String)""));
                form.setMothersName(JspUtils.displayValue((Object)(person.getMother() != null ? person.getMother().getName() : null), (String)""));
            }
            Employment employment = person.getEmployment();
            if (employment != null) {
                form.setEmploymentStatus(this.getLookupCode((Lookup)employment.getEmploymentStatus()));
                form.setOnFileEmploymentStatus(this.getLookupCode((Lookup)employment.getEmploymentStatus()));
                form.setEmployerName(employment.getEmployerName());
                form.setOccupation(employment.getOccupation());
                if (isAddAPerson) {
                    Address address = employment.getEmployerAddress();
                    this.convertAddressToForm(address, form);
                } else {
                    form.setEmployerAddress(JspUtils.displayAddress((Address)employment.getEmployerAddress()));
                }
                form.setEmployerPhone(employment.getEmployerPhone());
                if (employment.getRetirementDate() != null) {
                    form.setRetirementDate(DateUtils.formatForEdit((ImpreciseDate)employment.getRetirementDate(), null));
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Conversion Failed", ex);
        }
    }

    private void convertPersontoFormPreferredLanguage(Person person, DemographicPersonalForm form) {
        if (person != null && person.getPreferredLanguage() != null && person.getPreferredLanguage().getLanguageEntryDate() != null) {
            form.setLanguageEntryDate(DateUtils.format((Date)person.getPreferredLanguage().getLanguageEntryDate(), (String)"MM/dd/yyyy"));
        }
        if (person != null && person.getPreferredLanguage() != null && person.getPreferredLanguage().getLanguage() != null && person.getPreferredLanguage().getLanguage().getCode() != null) {
            form.setPreferredLanguageCode(person.getPreferredLanguage().getLanguage().getCode());
        }
        if (StringUtils.isEmpty((String)form.getPreferredLanguageCode())) {
            form.setPreferredLanguageCode("eng");
            this.log.info((Object)("Defaulted Preferred Language to " + form.getPreferredLanguageCode()));
        }
    }

    private void convertFormToPerson(DemographicPersonalForm form, Person person) throws ConversionServiceException {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        try {
            Employment employment;
            person.setSensitiveRecord(new Boolean(form.isSensitivityFlag()));
            if (StringUtils.isEmpty((String)form.getSensitivityFlagSourceOfUpdate())) {
                form.setSensitivityFlagSourceOfUpdate(SensitivityChangeSource.CODE_HEC.getName());
            }
            if (StringUtils.isEmpty((String)form.getSensitivityFlagSiteOfUpdate())) {
                form.setSensitivityFlagSiteOfUpdate(VAFacility.CODE_HEC.getName());
            }
            person.setSensitivityChangeSource((SensitivityChangeSource)lookupCacheService.getByCodeFromCache(SensitivityChangeSource.class, form.getSensitivityFlagSourceOfUpdate()));
            person.setSensitivityChangeSite((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, form.getSensitivityFlagSiteOfUpdate()));
            person.setDegree(StringUtils.isBlank((String)form.getDegree()) ? null : form.getDegree());
            DeathRecord deathRecord = person.getDeathRecord();
            if (StringUtils.isNotEmpty((String)form.getDateOfDeath())) {
                if (deathRecord == null) {
                    deathRecord = new DeathRecord();
                    person.setDeathRecord(deathRecord);
                }
                ImpreciseDate dateWithTime = DateUtils.getImpreciseDate((String)form.getDateOfDeath(), (boolean)true);
                if (deathRecord.getDeathDate() == null || !dateWithTime.equals((Object)deathRecord.getDeathDate())) {
                    String impreciseString = dateWithTime.toStandardFormat();
                    if (impreciseString.length() > 8) {
                        impreciseString = impreciseString.substring(0, 8);
                    }
                    ImpreciseDate dateWithoutTime = new ImpreciseDate(impreciseString);
                    deathRecord.setDeathDate(dateWithoutTime);
                }
                deathRecord.setDataSource((DeathDataSource)lookupCacheService.getByCodeFromCache(DeathDataSource.class, form.getDeathNotificationSource()));
                deathRecord.setFacilityReceived((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, form.getDeathNotificationSite()));
            } else if (deathRecord != null) {
                deathRecord.setDeathDate(null);
                deathRecord.setDataSource(null);
                deathRecord.setFacilityReceived(null);
            }
            this.addPreferredFacilitiesToPerson(form, person);
            person.setClaimFolderNumber(form.getClaimFolderNumber());
            if (StringUtils.isNotEmpty((String)form.getClaimFolderNumber())) {
                if (StringUtils.isNotEmpty((String)form.getClaimFolderLocation())) {
                    person.setClaimFolderLocation((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, form.getClaimFolderLocation()));
                } else {
                    person.setClaimFolderLocation((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, VAFacility.CODE_DEFAULT_CLAIM_FOLDER_LOCATION.getName()));
                }
            } else {
                person.setClaimFolderLocation(null);
            }
            this.populateFormToEmergencyReponse(form, person);
            person.setMaritalStatus((MaritalStatus)lookupCacheService.getByCodeFromCache(MaritalStatus.class, form.getMaritalStatus()));
            this.convertFormToPersonPreferredLanguage(form, person);
            EmploymentStatus employmentStatus = (EmploymentStatus)lookupCacheService.getByCodeFromCache(EmploymentStatus.class, form.getEmploymentStatus());
            EmploymentStatus onFileEmploymentStatus = (EmploymentStatus)lookupCacheService.getByCodeFromCache(EmploymentStatus.class, form.getOnFileEmploymentStatus());
            if (employmentStatus == null && onFileEmploymentStatus != null) {
                employmentStatus = onFileEmploymentStatus;
            }
            if ((employment = person.getEmployment()) == null) {
                employment = new Employment();
                person.setEmployment(employment);
            }
            employment.setEmploymentStatus(employmentStatus);
            employment.setRetirementDate(DateUtils.getImpreciseDate((String)form.getRetirementDate()));
            employment.setEmployerName(form.getEmployerName());
            employment.setEmployerPhone(form.getEmployerPhone());
            employment.setOccupation(form.getOccupation());
            boolean isAddAPerson = form.isAddAPerson();
            if (isAddAPerson) {
                person.setReligion((Religion)lookupCacheService.getByCodeFromCache(Religion.class, form.getReligion()));
                this.setApplication(person, form);
                this.setNeedCareDueToAccident(person, form.getNeedCareDueToAccident());
                this.setNeedCareDueToInjury(person, form.getNeedCareDueToInjury());
                if (StringUtils.isNotEmpty((String)form.getMothersFirstName()) && StringUtils.isNotEmpty((String)form.getMothersLastName())) {
                    this.setMothersName(person, form);
                }
                if (StringUtils.isNotEmpty((String)form.getFathersFirstName()) && StringUtils.isNotEmpty((String)form.getFathersLastName())) {
                    this.setFathersName(person, form);
                }
                if (StringUtils.isNotEmpty((String)form.getOtherSsns())) {
                    this.setOtherSsns(person, form);
                }
                if (StringUtils.isNotEmpty((String)form.getOtherFirstNames()) && StringUtils.isNotEmpty((String)form.getOtherLastNames())) {
                    this.setOtherNames(person, form);
                }
                if (form.isAnyAddressFieldFilled()) {
                    Address address = employment.getEmployerAddress();
                    if (address == null) {
                        address = new Address();
                        employment.setEmployerAddress(address);
                    }
                    this.convertFormToAddress(form, address);
                } else {
                    employment.setEmployerAddress(null);
                }
                if (form.getAppointmentRequestResponse().equals("1")) {
                    person.setAppointmentRequestDate(DateUtils.getDate((String)form.getAppointmentRequestDate()));
                    person.setAppointmentRequestResponse(Boolean.TRUE);
                } else {
                    person.setAppointmentRequestResponse(Boolean.FALSE);
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Conversion Failed", ex);
        }
    }

    private void convertFormToPersonPreferredLanguage(DemographicPersonalForm form, Person person) throws UnknownLookupTypeException, ClassNotFoundException {
        if (this.isPreferredLanguageCodeUnchanged(person, form)) {
            return;
        }
        if (person.getPreferredLanguage() == null) {
            person.setPreferredLanguage(new PreferredLanguage());
        }
        person.getPreferredLanguage().setLanguage((Language)this.getLookupCacheService().getByCodeFromCache(Language.class, form.getPreferredLanguageCode()));
        if (StringUtils.isEmpty((String)form.getLanguageEntryDate())) {
            person.getPreferredLanguage().setLanguageEntryDate(CommonDateUtils.getCurrentDate());
        } else {
            person.getPreferredLanguage().setLanguageEntryDate(CommonDateUtils.getDate((String)form.getLanguageEntryDate()));
        }
    }

    private boolean isPreferredLanguageCodeUnchanged(Person person, DemographicPersonalForm form) {
        if (person.getPreferredLanguage() != null && person.getPreferredLanguage().getLanguage() != null) {
            Date formEntryDate = CommonDateUtils.getDate((String)form.getLanguageEntryDate());
            if (formEntryDate == null) {
                formEntryDate = CommonDateUtils.getCurrentDate();
            }
            return StringUtils.compareTo((String)person.getPreferredLanguage().getLanguage().getCode(), (String)form.getPreferredLanguageCode()) == 0 && CommonDateUtils.isSameDay((Date)person.getPreferredLanguage().getLanguageEntryDate(), (Date)formEntryDate);
        }
        return false;
    }

    private void populateFormToEmergencyReponse(DemographicPersonalForm form, Person person) throws ConversionServiceException {
        try {
            Map existingEResponseIndicatorMap = this.getEmergencyResponseIndicatorMap(person.getEmergencyResponseIndicators());
            person.removeAllEmergencyResponseIndicators();
            String[] eResponseCodes = form.getEmergencyResponse();
            if (eResponseCodes != null && eResponseCodes.length > 0) {
                EmergencyResponseIndicator eResponseIndicator = null;
                String eResponseCode = null;
                EmergencyResponse emergencyResponse = null;
                for (int i = 0; i < eResponseCodes.length; ++i) {
                    eResponseCode = eResponseCodes[i];
                    if (!StringUtils.isNotEmpty((String)eResponseCode)) continue;
                    eResponseIndicator = (EmergencyResponseIndicator)existingEResponseIndicatorMap.get(eResponseCode);
                    if (eResponseIndicator == null && (emergencyResponse = (EmergencyResponse)this.getLookupCacheService().getByCodeFromCache(EmergencyResponse.class, eResponseCode)) != null) {
                        eResponseIndicator = new EmergencyResponseIndicator();
                        eResponseIndicator.setEmergencyResponse(emergencyResponse);
                    }
                    if (eResponseIndicator == null) continue;
                    person.addEmergencyResponseIndicator(eResponseIndicator);
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error while populating emergency response indicators", ex);
        }
    }

    private void populateEmergencyReponseToForm(Person person, DemographicPersonalForm form) throws ConversionServiceException {
        try {
            Set existingEResponseIndicator = person.getEmergencyResponseIndicators();
            if (existingEResponseIndicator != null && !existingEResponseIndicator.isEmpty()) {
                String[] eResponseCode = new String[existingEResponseIndicator.size()];
                EmergencyResponseIndicator eResponseIndicator2 = null;
                int i = 0;
                for (EmergencyResponseIndicator eResponseIndicator2 : existingEResponseIndicator) {
                    if (eResponseIndicator2 == null) continue;
                    eResponseCode[i] = eResponseIndicator2.getEmergencyResponse().getCode();
                    ++i;
                }
                form.setEmergencyResponse(eResponseCode);
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Error while populating emergency response indicators", ex);
        }
    }

    private Map getEmergencyResponseIndicatorMap(Set set) {
        HashMap<String, EmergencyResponseIndicator> map = new HashMap<String, EmergencyResponseIndicator>();
        if (set != null) {
            EmergencyResponseIndicator eResponseIndicator2 = null;
            for (EmergencyResponseIndicator eResponseIndicator2 : set) {
                map.put(eResponseIndicator2.getEmergencyResponse().getCode(), eResponseIndicator2);
            }
        }
        return map;
    }

    private String getReligion(Person person) {
        return person.getReligion() == null ? null : person.getReligion().getCode();
    }

    private String getBenefitAppliedFor(Person person) {
        Application app = person.getApplication();
        String benefitType = null;
        if (app != null) {
            benefitType = app.getBenefitType() == null ? null : app.getBenefitType().getCode();
        }
        return benefitType;
    }

    private List getOtherFirstNames(Person person) {
        HashSet otherNames = new HashSet(person.getOtherNames());
        ArrayList<String> otherFirstNames = new ArrayList<String>();
        if (otherNames != null && otherNames.size() > 0) {
            Object[] otherNamesArray = otherNames.toArray();
            for (int i = 0; i < otherNamesArray.length; ++i) {
                otherFirstNames.add(((Name)otherNamesArray[i]).getGivenName());
            }
        }
        return otherFirstNames;
    }

    private List getOtherLastNames(Person person) {
        HashSet otherNames = new HashSet(person.getOtherNames());
        ArrayList<String> otherLastNames = new ArrayList<String>();
        if (otherNames != null && otherNames.size() > 0) {
            Object[] otherNamesArray = otherNames.toArray();
            for (int i = 0; i < otherNamesArray.length; ++i) {
                otherLastNames.add(((Name)otherNamesArray[i]).getFamilyName());
            }
        }
        return otherLastNames;
    }

    private void setNeedCareDueToAccident(Person person, String setYes) {
        if (setYes == null || setYes.equalsIgnoreCase("nd")) {
            person.setNeedCareDueToAccident(null);
        } else {
            person.setNeedCareDueToAccident(ConvertUtils.convertBoolean(setYes));
        }
    }

    private void setNeedCareDueToInjury(Person person, String setYes) {
        if (setYes == null || setYes.equalsIgnoreCase("nd")) {
            person.setNeedCareDueToInjury(null);
        } else {
            person.setNeedCareDueToInjury(ConvertUtils.convertBoolean(setYes));
        }
    }

    private void setApplication(Person person, DemographicPersonalForm form) throws Exception {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        Application a = person.getApplication();
        if (a == null) {
            a = new Application();
            a.setPerson(person);
            person.setApplication(a);
        }
        a.setBenefitType((BenefitType)lookupCacheService.getByCodeFromCache(BenefitType.class, form.getBenefitAppliedFor()));
    }

    private void setMothersName(Person person, DemographicPersonalForm form) throws Exception {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        Relation mother = person.getMother();
        if (mother == null) {
            mother = new Relation();
            mother.setRelationship((Relationship)lookupCacheService.getByCodeFromCache(Relationship.class, Relationship.CODE_MOTHER.getCode()));
            mother.setPerson(person);
            person.setRelation(Relationship.CODE_MOTHER.getCode(), mother);
        }
        Name mothersName = new Name();
        mothersName.setGivenName(form.getMothersFirstName());
        mothersName.setFamilyName(form.getMothersLastName());
        mother.setName(mothersName);
        person.setMothersName(mothersName);
    }

    private void setFathersName(Person person, DemographicPersonalForm form) throws Exception {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        Relation father = person.getFather();
        if (father == null) {
            father = new Relation();
            father.setPerson(person);
            father.setRelationship((Relationship)lookupCacheService.getByCodeFromCache(Relationship.class, Relationship.CODE_FATHER.getCode()));
            person.setRelation(Relationship.CODE_FATHER.getCode(), father);
        }
        Name fathersName = new Name();
        fathersName.setGivenName(form.getFathersFirstName());
        fathersName.setFamilyName(form.getFathersLastName());
        father.setName(fathersName);
        person.setFathersName(fathersName);
    }

    private void setOtherNames(Person person, DemographicPersonalForm form) throws ConversionServiceException {
        try {
            LookupCacheService lookupCacheService = this.getLookupCacheService();
            Set otherNames = person.getOtherNames();
            if (otherNames != null) {
                Iterator i = otherNames.iterator();
                while (i.hasNext()) {
                    person.removeName((Name)i.next());
                }
            }
            String frmOtherFirstNames = form.getOtherFirstNames();
            String frmOtherLastNames = form.getOtherLastNames();
            StringTokenizer otherLastToken = new StringTokenizer(frmOtherLastNames);
            StringTokenizer otherFirstToken = new StringTokenizer(frmOtherFirstNames);
            while (otherLastToken.hasMoreTokens() && otherFirstToken.hasMoreTokens() && otherLastToken.countTokens() == otherFirstToken.countTokens()) {
                String oLastName = otherLastToken.nextToken();
                String oFirstName = otherFirstToken.nextToken();
                Name oName = new Name();
                oName.setGivenName(oFirstName);
                oName.setFamilyName(oLastName);
                oName.setType((NameType)lookupCacheService.getByCodeFromCache(NameType.class, NameType.ALIAS_NAME.getName()));
                person.addName(oName);
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Conversion Failed", ex);
        }
    }

    private void setOtherSsns(Person person, DemographicPersonalForm form) throws ConversionServiceException {
        try {
            LookupCacheService lookupCacheService = this.getLookupCacheService();
            Set otherSsns = person.getOtherSsns();
            if (otherSsns != null) {
                person.removeOtherSsns(otherSsns);
            }
            String fmOtherSsns = form.getOtherSsns();
            StringTokenizer otherSsnTokesn = new StringTokenizer(fmOtherSsns);
            while (otherSsnTokesn.hasMoreTokens()) {
                String oSsnStr = otherSsnTokesn.nextToken();
                SSN oSsn = new SSN();
                oSsn.setSsnText(oSsnStr);
                oSsn.setType((SSNType)lookupCacheService.getByCodeFromCache(SSNType.class, SSNType.CODE_ALIAS.getName()));
                person.addSsn(oSsn);
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Conversion Failed", ex);
        }
    }

    private String displayValues(List values, String defText, String format) {
        StringBuffer result = new StringBuffer();
        Iterator i = values.iterator();
        while (i.hasNext()) {
            result.append(JspUtils.displayValue(i.next(), (String)defText, (String)format));
            result.append(i.hasNext() ? NAME_BREAK : "");
        }
        return result.toString();
    }

    protected void addPreferredFacilitiesToForm(List preferredFacilities, DemographicPersonalForm form) {
        for (PreferredFacility pf : preferredFacilities) {
            String pfID = null;
            pfID = pf.getEntityKey() == null ? "" : pf.getEntityKey().getKeyValueAsString();
            form.addPreferredFacility(pfID, this.getLookupCode((Lookup)pf.getFacility()), this.getLookupCode((Lookup)pf.getSourceDesignation()));
        }
        if (form.getPreferredFacilitySize() == 0) {
            form.addNewPreferredFacility();
        }
    }

    protected void addPreferredFacilitiesToPerson(DemographicPersonalForm form, Person person) throws ConversionServiceException {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        try {
            ArrayList<PreferredFacility> remainingPfs = new ArrayList<PreferredFacility>();
            List pfIds = form.getPreferredFacilityIds();
            if (pfIds != null && !pfIds.isEmpty()) {
                for (int i = 0; i < pfIds.size(); ++i) {
                    String site = form.getPreferredFacilitySite(i);
                    if (!StringUtils.isNotBlank((String)site)) continue;
                    PreferredFacility preferredFacility = null;
                    String pfId = (String)pfIds.get(i);
                    if (StringUtils.isNotEmpty((String)pfId)) {
                        preferredFacility = person.getPreferredFacilityByEntityKey(CommonEntityKeyFactory.createPreferredFacilityEntityKey((String)pfId));
                    }
                    if (preferredFacility == null) {
                        preferredFacility = new PreferredFacility();
                    }
                    remainingPfs.add(preferredFacility);
                    if (StringUtils.isNotEmpty((String)form.getPreferredFacilitySite(i))) {
                        preferredFacility.setFacility((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, form.getPreferredFacilitySite(i)));
                    }
                    if (!StringUtils.isNotEmpty((String)form.getPreferredFacilitySD(i))) continue;
                    preferredFacility.setSourceDesignation((SourceDesignation)lookupCacheService.getByCodeFromCache(SourceDesignation.class, form.getPreferredFacilitySD(i)));
                }
                person.removeAllPreferredFacilities();
                for (PreferredFacility pf : remainingPfs) {
                    person.addPreferredFacility(pf);
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert DemographicPersonalForm to Person.", ex);
        }
    }
}

