/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.ui.common.action.AddressValidationAction;
import gov.va.med.esr.ui.demographic.action.DemographicPersonalForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

public class DemographicPersonalAction
extends AddressValidationAction {
    public static final String FORWARD_DEMOGRAPHIC_PERSONAL = "demographicPersonal";
    public static final String FORWARD_DEMOGRAPHIC_OVERVIEW = "demographicOverview";
    public static final String FORWARD_DEMOGRAPHIC_PERSONAL_HISTORY = "demographicPersonalHistory";
    public static final String FORWARD_CANCEL = "cancel";
    public static final String FORWARD_508_NOTES = "personal508Notes";
    public static final String FORWARD_RETURN_TO_SAME_PAGE = "success";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        DemographicPersonalForm personalForm = this.getPersonalForm(form);
        personalForm.setAddAPerson(isAddAPerson);
        this.conversionService.convert((Object)this.getSelectedPerson(request), (Object)personalForm);
        return mapping.findForward(FORWARD_DEMOGRAPHIC_PERSONAL);
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        DemographicPersonalForm personalForm = form instanceof DemographicPersonalForm ? (DemographicPersonalForm)form : null;
        ActionForward samePageForward = mapping.findForward(FORWARD_DEMOGRAPHIC_PERSONAL);
        if (personalForm == null) {
            return samePageForward;
        }
        personalForm.setAddAPerson(isAddAPerson);
        MessageResources messageResources = personalForm.getResources(request);
        ActionMessages errors = personalForm.getActionMessages(request);
        if (isAddAPerson) {
            ActionForward overviewSuccessForward = new ActionForward(mapping.findForward(FORWARD_DEMOGRAPHIC_OVERVIEW));
            if (Country.isUSAddress((String)personalForm.getCountry())) {
                if (!this.stateValid(personalForm, AddressForm.class, "state", overviewSuccessForward, request)) {
                    return samePageForward;
                }
                if (!this.zipCodeMatchesCityAndState(personalForm, AddressForm.class, "city", "state", "zipCode", request)) {
                    return samePageForward;
                }
            }
            boolean requiredFieldNotEntered = false;
            if (personalForm.getPreferredFacilitySites() == null || personalForm.getPreferredFacilitySites().isEmpty() || StringUtils.isEmpty((String)((String)personalForm.getPreferredFacilitySites().get(0)))) {
                requiredFieldNotEntered = true;
                errors.add("PreferredFacility", new ActionMessage("errors.required", (Object)"Preferred Facility"));
            }
            if (personalForm.getMaritalStatus() == null || StringUtils.isEmpty((String)personalForm.getMaritalStatus())) {
                requiredFieldNotEntered = true;
                errors.add("MaritalStatus", new ActionMessage("errors.required", (Object)"Marital Status"));
            }
            if (personalForm.getAppointmentRequestResponse() == null || StringUtils.isEmpty((String)personalForm.getAppointmentRequestResponse())) {
                requiredFieldNotEntered = true;
                errors.add("appointmentRequestResponse", new ActionMessage("errors.required", (Object)"Appointment Request Response"));
            }
            if (StringUtils.isEmpty((String)personalForm.getPreferredLanguageCode())) {
                requiredFieldNotEntered = true;
                errors.add("PreferredLanguage", new ActionMessage("errors.required", (Object)"Preferred Language"));
            }
            if (StringUtils.isEmpty((String)personalForm.getLanguageEntryDate())) {
                requiredFieldNotEntered = true;
                errors.add("LanguageEntryDate", new ActionMessage("errors.required", (Object)"Language Entry Date"));
            }
            if (requiredFieldNotEntered) {
                return samePageForward;
            }
            Person updatedPerson = (Person)this.getSelectedPerson(request).clone();
            this.conversionService.convert((Object)this.getPersonalForm(form), (Object)updatedPerson);
            this.updateSelectedPerson(request, updatedPerson);
            return mapping.findForward(FORWARD_DEMOGRAPHIC_OVERVIEW);
        }
        Person updatedPerson = (Person)this.getSelectedPerson(request).clone();
        this.conversionService.convert((Object)this.getPersonalForm(form), (Object)updatedPerson);
        updatedPerson = this.getDemographicService().updateDemographicInformation(updatedPerson);
        this.updateSelectedPerson(request, updatedPerson, true);
        return mapping.findForward(FORWARD_DEMOGRAPHIC_OVERVIEW);
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FORWARD_CANCEL);
    }

    public ActionForward gotoHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FORWARD_DEMOGRAPHIC_PERSONAL_HISTORY);
    }

    public ActionForward goto508Notes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FORWARD_508_NOTES);
    }

    protected DemographicPersonalForm getPersonalForm(ActionForm form) throws ServiceConfigurationException {
        DemographicPersonalForm personalForm;
        DemographicPersonalForm demographicPersonalForm = personalForm = form instanceof DemographicPersonalForm ? (DemographicPersonalForm)form : null;
        if (personalForm == null) {
            throw new ServiceConfigurationException("DemographicPersonalForm not properly configured.");
        }
        return personalForm;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.update", "update");
        map.put("button.cancel", FORWARD_CANCEL);
        map.put("button.continue", "update");
        map.put("button.viewHistoricalPersonalData", "gotoHistory");
        map.put("button.viewPersonal508Notes", "goto508Notes");
        map.put("text.subMenu.personal", "display");
        return map;
    }

    public void afterPropertiesSet() {
    }
}

