/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.EmergencyResponseIndicator;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredLanguage;
import gov.va.med.esr.common.util.MailingAddressHelper;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.demographic.action.DemographicOverviewForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class DemographicOverviewConversionService
extends UIConversionServiceImpl {
    private static final String CONST_LIVE = "Alive";
    private static final String CONST_DECEASED = "Deceased";

    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        Validate.notNull((Object)source, (String)"DemographicOverviewConversionService source is null");
        Validate.notNull((Object)source, (String)"DemographicOverviewConversionService target is null");
        if (source instanceof Person && target instanceof DemographicOverviewForm) {
            this.convertPersontoForm((Person)source, (DemographicOverviewForm)((Object)target));
        } else if (!(target instanceof Person) || !(source instanceof DemographicOverviewForm)) {
            throw new ConversionServiceException("Type mismatch: Can't convert from " + source.getClass().getName() + " to " + target.getClass().getName());
        }
    }

    private void convertPersontoForm(Person person, DemographicOverviewForm form) throws ConversionServiceException {
        try {
            this.copyMailingAddress(person, form);
            this.copyHomePhoneNumber(person, form);
            this.copyDODStatus(person, form);
            this.copyPreferredLanguage(person, form);
            this.copyEmploymentStatus(person, form);
            this.copyInsuranceInfo(person, form);
            this.copyAssociations(person, form);
            this.copyEmergencyReponse(person, form);
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Conversion Failed", ex);
        }
    }

    private void copyDODStatus(Person person, DemographicOverviewForm formBean) {
        DeathRecord deathRecord = person.getDeathRecord();
        if (deathRecord != null && deathRecord.getDeathDate() != null) {
            formBean.setCurrentStatus(CONST_DECEASED);
        } else {
            formBean.setCurrentStatus(CONST_LIVE);
        }
    }

    private void copyPreferredLanguage(Person person, DemographicOverviewForm formBean) {
        PreferredLanguage language = person.getPreferredLanguage();
        formBean.setPreferredLanguage(language == null || language.getLanguage() == null || language.getLanguage().getDescription() == null ? "" : language.getLanguage().getDescription());
    }

    private void copyEmploymentStatus(Person person, DemographicOverviewForm formBean) {
        if (person.getEmployment() != null) {
            formBean.setEmploymentStatus(person.getEmployment().getEmploymentStatus() == null ? "" : person.getEmployment().getEmploymentStatus().getDescription());
        }
    }

    private void copyMailingAddress(Person person, DemographicOverviewForm formBean) {
        Address currentAddress = MailingAddressHelper.selectAddressForMailing((Collection)person.getAddresses());
        formBean.setCurrentMailingAddress(JspUtils.displayAddress((Address)currentAddress));
        formBean.setBadAddressReason(currentAddress == null || currentAddress.getBadAddressReason() == null ? null : currentAddress.getBadAddressReason().getCode());
    }

    private void copyHomePhoneNumber(Person person, DemographicOverviewForm formBean) {
        Phone phone = person.getHomePhone();
        if (phone != null) {
            String phonenumber = phone.getPhoneNumber();
            if (phonenumber != null && phonenumber.length() > 0) {
                formBean.setPhoneNumber(phonenumber);
            } else {
                formBean.setPhoneNumber(null);
            }
        }
    }

    private void copyInsuranceInfo(Person person, DemographicOverviewForm form) {
        ArrayList insurances = new ArrayList(person.getInsurances());
        Collections.sort(insurances);
        Medicare medicareRecordToAdd = null;
        boolean medicareAdded = false;
        for (InsurancePolicy insPolicy : insurances) {
            if (insPolicy.isSiteRecord()) {
                form.addSiteInsurance(insPolicy);
                continue;
            }
            if (insPolicy instanceof Medicare) {
                Medicare medicareRecord = (Medicare)insPolicy;
                if (medicareRecordToAdd != null && !Boolean.TRUE.equals(medicareRecord.isEnrolledInPartB())) continue;
                medicareRecordToAdd = medicareRecord;
                continue;
            }
            if (medicareRecordToAdd != null && !medicareAdded) {
                form.addHecInsurance((InsurancePolicy)medicareRecordToAdd);
                medicareAdded = true;
            }
            form.addHecInsurance(insPolicy);
        }
        if (medicareRecordToAdd != null && !medicareAdded) {
            form.addHecInsurance((InsurancePolicy)medicareRecordToAdd);
            medicareAdded = true;
        }
    }

    private void copyAssociations(Person person, DemographicOverviewForm form) {
        ArrayList associations = new ArrayList(person.getAssociations());
        Collections.sort(associations);
        form.setAssociations(associations);
    }

    private void copyEmergencyReponse(Person person, DemographicOverviewForm form) {
        Set existingEResponseIndicator = person.getEmergencyResponseIndicators();
        HashSet<String> existingEResponseIndicatorDesc = new HashSet<String>();
        if (existingEResponseIndicator != null && !existingEResponseIndicator.isEmpty()) {
            EmergencyResponseIndicator eResponseIndicator2 = null;
            for (EmergencyResponseIndicator eResponseIndicator2 : existingEResponseIndicator) {
                if (eResponseIndicator2 == null) continue;
                existingEResponseIndicatorDesc.add(eResponseIndicator2.getEmergencyResponse().getDescription());
            }
            form.setEmergencyResponse(JspUtils.displayValues(existingEResponseIndicatorDesc, (String)"", null));
        }
    }
}

