/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class DemographicIdentityTraitsForm
extends AddressForm {
    private static final long serialVersionUID = 5305813411097040117L;
    public static final String FIELD_DOB = "dateOfBirth";
    public static final String FIELD_MotherMaidenName = "mothersMaidenName";
    public static final String FIELD_PlaceOfBirthState = "placeOfBirthState";
    public static final String FIELD_PlaceOfBirthCity = "placeOfBirthCity";
    public static final String ERROR_BEFORE_1870 = "errors.invalidDOB";
    public static final String LABEL_DOB = "label.personal.dateOfBirth";
    public static final String ERROR_FUTURE = "errors.future";
    private String prefix = null;
    private String firstName = null;
    private String middleName = null;
    private String lastName = null;
    private String suffix = null;
    private String ssn = null;
    private String pseudoSsnReason = null;
    private String otherSSN = null;
    private String ssnSourceOfChange = null;
    private String ssaVerificationStatus = null;
    private String ssaVerificationDate = null;
    private String ssaMessage = null;
    private String gender = null;
    private String dateOfBirth = null;
    private String vpidValue = null;
    private String birthCity = null;
    private String birthState = null;
    private String multipleBirth = null;
    private String mothersMaidenName = null;
    private String ethnicity = null;
    private String[] raceSelections = new String[0];
    private boolean disabledMultipleBirthIndicator = true;
    private boolean disableSelfIdentifiedGenderIdentity = true;
    private String selfIdentifiedGenderIdentity = null;

    public boolean isDisabledMultipleBirthIndicator() {
        return this.disabledMultipleBirthIndicator;
    }

    public void setDisabledMultipleBirthIndicator(boolean disabledMultipleBirthIndicator) {
        this.disabledMultipleBirthIndicator = disabledMultipleBirthIndicator;
    }

    public String getOtherSSN() {
        return this.otherSSN;
    }

    public String getPseudoSsnReason() {
        return this.pseudoSsnReason;
    }

    public String getSsaMessage() {
        return this.ssaMessage;
    }

    public String getSsaVerificationDate() {
        return this.ssaVerificationDate;
    }

    public String getSsaVerificationStatus() {
        return this.ssaVerificationStatus;
    }

    public String getSsn() {
        return this.ssn;
    }

    public String getSsnSourceOfChange() {
        return this.ssnSourceOfChange;
    }

    public void setOtherSSN(String otherSSN) {
        this.otherSSN = otherSSN;
    }

    public void setPseudoSsnReason(String pseudoSsnReason) {
        this.pseudoSsnReason = pseudoSsnReason;
    }

    public void setSsaMessage(String ssaMessage) {
        this.ssaMessage = ssaMessage;
    }

    public void setSsaVerificationDate(String ssaVerificationDate) {
        this.ssaVerificationDate = ssaVerificationDate;
    }

    public void setSsaVerificationStatus(String ssaVerificationStatus) {
        this.ssaVerificationStatus = ssaVerificationStatus;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public void setSsnSourceOfChange(String ssnSourceOfChange) {
        this.ssnSourceOfChange = ssnSourceOfChange;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getVpidValue() {
        return this.vpidValue;
    }

    public void setVpidValue(String vpidValue) {
        this.vpidValue = vpidValue;
    }

    public String getBirthCity() {
        return this.birthCity;
    }

    public void setBirthCity(String birthCity) {
        this.birthCity = birthCity;
    }

    public String getBirthState() {
        return this.birthState;
    }

    public void setBirthState(String birthState) {
        this.birthState = birthState;
    }

    public String getEthnicity() {
        return this.ethnicity;
    }

    public void setEthnicity(String ethnicity) {
        this.ethnicity = ethnicity;
    }

    public String getMothersMaidenName() {
        return this.mothersMaidenName;
    }

    public void setMothersMaidenName(String mothersMaidenName) {
        this.mothersMaidenName = mothersMaidenName;
    }

    public String getMultipleBirth() {
        return this.multipleBirth;
    }

    public void setMultipleBirth(String multipleBirth) {
        this.multipleBirth = multipleBirth;
    }

    public String[] getRaceSelections() {
        return this.raceSelections;
    }

    public void setRaceSelections(String[] raceSelections) {
        this.raceSelections = raceSelections;
    }

    public String getSelfIdentifiedGenderIdentity() {
        return this.selfIdentifiedGenderIdentity;
    }

    public void setSelfIdentifiedGenderIdentity(String selfIdentifiedGenderIdentity) {
        this.selfIdentifiedGenderIdentity = selfIdentifiedGenderIdentity;
    }

    public boolean isDisableSelfIdentifiedGenderIdentity() {
        return this.disableSelfIdentifiedGenderIdentity;
    }

    public void setDisableSelfIdentifiedGenderIdentity(boolean disableSelfIdentifiedGenderIdentity) {
        this.disableSelfIdentifiedGenderIdentity = disableSelfIdentifiedGenderIdentity;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors messages = super.validate(mapping, request);
        if (messages != null && !messages.isEmpty()) {
            return messages;
        }
        if (messages == null) {
            messages = new ActionErrors();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, 1870);
        calendar.set(2, 11);
        calendar.set(5, 31);
        Date minDate = calendar.getTime();
        ImpreciseDate dob = DateUtils.getImpreciseDate((String)this.getDateOfBirth());
        boolean dobCheckFlag = false;
        if (dob != null) {
            if (ImpreciseDateUtils.getDateWithDefault((ImpreciseDate)dob).before(minDate)) {
                messages.add(FIELD_DOB, new ActionMessage(ERROR_BEFORE_1870));
                dobCheckFlag = true;
            }
            if (new Date().before(ImpreciseDateUtils.getDateWithDefault((ImpreciseDate)dob))) {
                messages.add(FIELD_DOB, new ActionMessage(ERROR_FUTURE, (Object)"Date of Birth"));
                dobCheckFlag = true;
            }
        }
        if (this.isAddAPerson()) {
            if (StringUtils.containsNumbers((String)this.getMothersMaidenName())) {
                messages.add("FIELD_MotherMaidenName", new ActionMessage("errors.detail", (Object)"Mother's Maiden Name can not contain numbers."));
            }
            if (this.getBirthState() == null || this.getBirthState().length() == 0) {
                messages.add("FIELD_PlaceOfBirthState", new ActionMessage("errors.detail", (Object)"Place of Birth State is required."));
            }
            if (this.getBirthCity() == null || this.getBirthCity().length() == 0) {
                messages.add("FIELD_PlaceOfBirthCity", new ActionMessage("errors.detail", (Object)"Place of Birth City is required."));
            }
        }
        return messages;
    }
}

