/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.CollectionMethod;
import gov.va.med.esr.common.model.lookup.EthnicityType;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.PseudoSSNReason;
import gov.va.med.esr.common.model.lookup.RaceType;
import gov.va.med.esr.common.model.lookup.SSAMessage;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SSNChangeSource;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Ethnicity;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Race;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.esr.ui.demographic.action.DemographicIdentityTraitsForm;
import gov.va.med.esr.ui.demographic.action.SubmittedIdentityTraitsForm;
import gov.va.med.esr.ui.util.ConvertUtils;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.AuditInfo;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class DemographicIdentityTraitsConversionService
extends UIConversionServiceImpl {
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        Validate.notNull((Object)source, (String)"DemographicIdentityTraitsConversionService source is null");
        Validate.notNull((Object)source, (String)"DemographicIdentityTraitsConversionService target is null");
        if (source instanceof Person && target instanceof DemographicIdentityTraitsForm) {
            this.convertPersontoForm((Person)source, (DemographicIdentityTraitsForm)((Object)target));
        } else if (target instanceof Person && source instanceof DemographicIdentityTraitsForm) {
            this.convertFormtoPerson((DemographicIdentityTraitsForm)((Object)source), (Person)target);
        } else {
            throw new ConversionServiceException("Type mismatch: Can't convert from " + source.getClass().getName() + " to " + target.getClass().getName());
        }
    }

    private void doConvertPersontoNonEditableForm(Person person, SubmittedIdentityTraitsForm form) throws ConversionServiceException {
        AuditInfo auditInfo = person.getIdentityTraitsAuditInfo();
        form.setUpdateStatus(auditInfo.getStatus());
        form.setUpdateUser(auditInfo.getChangeUser());
        SSN officialSSN = person.getOfficialSsn();
        if (officialSSN != null) {
            SSNChangeSource changeSource = officialSSN.getSourceOfChange();
            form.setSsnSourceOfChange(changeSource == null ? null : changeSource.getDescription());
            SSAVerificationStatus verfStatus = officialSSN.getSsaVerificationStatus();
            form.setSsaVerificationStatus(verfStatus == null ? null : verfStatus.getDescription());
            SSAMessage ssaMsg = officialSSN.getSsaMessage();
            form.setSsaMessage(ssaMsg == null ? null : ssaMsg.getDescription());
            PseudoSSNReason reason = officialSSN.getPseudoSSNReason();
            form.setPseudoSsnReason(reason == null ? null : reason.getDescription());
        }
    }

    private void convertPersontoForm(Person person, DemographicIdentityTraitsForm form) throws ConversionServiceException {
        this.doConvertPersontoEditableForm(person, form);
        if (form instanceof SubmittedIdentityTraitsForm) {
            this.doConvertPersontoNonEditableForm(person, (SubmittedIdentityTraitsForm)form);
        }
    }

    private void doConvertPersontoEditableForm(Person person, DemographicIdentityTraitsForm form) throws ConversionServiceException {
        try {
            Name name = person.getLegalName();
            if (name != null) {
                form.setPrefix(name.getPrefix());
                form.setFirstName(name.getGivenName());
                form.setMiddleName(name.getMiddleName());
                form.setLastName(name.getFamilyName());
                form.setSuffix(name.getSuffix());
            }
            SSN officialSSN = person.getOfficialSsn();
            if (form.isAddAPerson()) {
                Iterator iter = person.getSsns().iterator();
                while (iter.hasNext() && (officialSSN = (SSN)iter.next()) == null && officialSSN.equals((Object)"")) {
                }
            }
            if (officialSSN != null) {
                form.setSsn(JspUtils.displaySSN((String)officialSSN.getSsnText()));
                SSNChangeSource changeSource = officialSSN.getSourceOfChange();
                form.setSsnSourceOfChange(changeSource == null ? null : changeSource.getCode());
                SSAVerificationStatus verfStatus = officialSSN.getSsaVerificationStatus();
                form.setSsaVerificationStatus(verfStatus == null ? null : verfStatus.getCode());
                form.setSsaVerificationDate(DateUtils.format((Date)officialSSN.getSsaVerificationDate(), null));
                SSAMessage ssaMsg = officialSSN.getSsaMessage();
                form.setSsaMessage(ssaMsg == null ? null : ssaMsg.getDescription());
                PseudoSSNReason reason = officialSSN.getPseudoSSNReason();
                form.setPseudoSsnReason(reason == null ? null : reason.getCode());
            }
            form.setOtherSSN(JspUtils.displayValues((Set)person.getOtherSsns(), (String)"", null));
            form.setGender(this.getLookupCode((Lookup)person.getGender()));
            form.setSelfIdentifiedGenderIdentity(this.getLookupCode((Lookup)person.getSelfIdentifiedGenderIdentity()));
            BirthRecord birthRecord = person.getBirthRecord();
            if (birthRecord != null) {
                form.setDateOfBirth(DateUtils.format((ImpreciseDate)birthRecord.getBirthDate(), null));
                form.setBirthCity(birthRecord.getCity());
                form.setBirthState(birthRecord.getState());
            }
            form.setMultipleBirth(ConvertUtils.convertYesNoNoData(this.getMultipleBirth(person)));
            form.setMothersMaidenName(person.getMothersMaidenName());
            VPIDEntityKey vpid = person.getVPIDEntityKey();
            if (vpid != null) {
                form.setVpidValue(vpid.getVPID());
            }
            form.setRaceSelections(this.getRaceTypes(person));
            boolean isAddAPerson = form.isAddAPerson();
            if (isAddAPerson) {
                form.setEthnicity(this.getEthnicity(person));
            } else {
                form.setEthnicity(this.getDisplayEthnicity(person));
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Conversion Failed", ex);
        }
    }

    private void convertFormtoPerson(DemographicIdentityTraitsForm form, Person person) throws ConversionServiceException {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        try {
            SSN officialSSN;
            Name name = person.getLegalName();
            if (name == null) {
                name = new Name();
                name.setType((NameType)lookupCacheService.getByCodeFromCache(NameType.class, NameType.LEGAL_NAME.getName()));
                person.setLegalName(name);
            }
            name.setPrefix(StringUtils.isBlank((String)form.getPrefix()) ? null : form.getPrefix());
            name.setGivenName(StringUtils.isBlank((String)form.getFirstName()) ? null : form.getFirstName());
            name.setMiddleName(StringUtils.isBlank((String)form.getMiddleName()) ? null : form.getMiddleName());
            name.setFamilyName(StringUtils.isBlank((String)form.getLastName()) ? null : form.getLastName());
            name.setSuffix(StringUtils.isBlank((String)form.getSuffix()) ? null : form.getSuffix());
            person.setGender((Gender)lookupCacheService.getByCodeFromCache(Gender.class, form.getGender()));
            if (this.isAnySsnInformationOnForm(form)) {
                officialSSN = person.getOfficialSsn();
                if (officialSSN == null) {
                    officialSSN = new SSN();
                    officialSSN.setType((SSNType)lookupCacheService.getByCodeFromCache(SSNType.class, SSNType.CODE_ACTIVE.getName()));
                    person.addSsn(officialSSN);
                }
                officialSSN.setSsnText(StringUtils.isBlank((String)SSN.formatSSN((String)form.getSsn())) ? null : SSN.formatSSN((String)form.getSsn()));
                if (StringUtils.isNotEmpty((String)form.getPseudoSsnReason())) {
                    officialSSN.setPseudoSSNReason((PseudoSSNReason)lookupCacheService.getByCodeFromCache(PseudoSSNReason.class, form.getPseudoSsnReason()));
                } else {
                    officialSSN.setPseudoSSNReason(null);
                }
                if (StringUtils.isNotEmpty((String)form.getSsnSourceOfChange())) {
                    officialSSN.setSourceOfChange((SSNChangeSource)lookupCacheService.getByCodeFromCache(SSNChangeSource.class, form.getSsnSourceOfChange()));
                } else {
                    officialSSN.setSourceOfChange(null);
                }
                if (StringUtils.isNotEmpty((String)form.getSsaVerificationStatus())) {
                    officialSSN.setSsaVerificationStatus((SSAVerificationStatus)lookupCacheService.getByCodeFromCache(SSAVerificationStatus.class, form.getSsaVerificationStatus()));
                } else {
                    officialSSN.setSsaVerificationStatus(null);
                }
            } else {
                officialSSN = person.getOfficialSsn();
                if (officialSSN != null) {
                    person.removeSsn(officialSSN);
                }
            }
            this.setBirthRecord(person, form);
            person.setMothersMaidenName(StringUtils.isBlank((String)form.getMothersMaidenName()) ? null : form.getMothersMaidenName());
            boolean isAddAPerson = form.isAddAPerson();
            if (isAddAPerson) {
                if (StringUtils.isNotEmpty((String)form.getEthnicity())) {
                    this.setEthnicity(person, form);
                }
                this.setRaces(person, form);
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Conversion Failed", ex);
        }
    }

    private void setEthnicity(Person person, DemographicIdentityTraitsForm form) throws Exception {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        Ethnicity e = person.getEthnicity();
        if (e == null) {
            e = new Ethnicity();
            e.setPerson(person);
            person.setEthnicity(e);
        }
        e.setEthnicityType((EthnicityType)lookupCacheService.getByCodeFromCache(EthnicityType.class, form.getEthnicity()));
    }

    private void setRaces(Person person, DemographicIdentityTraitsForm form) throws Exception {
        ArrayList<Race> remainingRaces = new ArrayList<Race>();
        RaceType type = null;
        Race formRace = null;
        if (form.getRaceSelections() != null) {
            for (int i = 0; i < form.getRaceSelections().length; ++i) {
                type = (RaceType)this.getLookupCacheService().getByCodeFromCache(RaceType.class, form.getRaceSelections()[i]);
                formRace = person.getRaceByType(type);
                if (formRace == null) {
                    formRace = new Race();
                    formRace.setPerson(person);
                    formRace.setRaceType(type);
                    formRace.setCollectionMethod((CollectionMethod)this.getLookupCacheService().getByCodeFromCache(CollectionMethod.class, CollectionMethod.CODE_SLF.getCode()));
                }
                remainingRaces.add(formRace);
            }
        }
        person.removeAllRaces();
        for (Race race : remainingRaces) {
            person.addRace(race);
        }
    }

    protected boolean isAnySsnInformationOnForm(DemographicIdentityTraitsForm form) {
        return StringUtils.isNotEmpty((String)SSN.formatSSN((String)form.getSsn())) || StringUtils.isNotEmpty((String)form.getPseudoSsnReason()) || StringUtils.isNotEmpty((String)form.getSsnSourceOfChange()) || StringUtils.isNotEmpty((String)form.getSsaVerificationStatus());
    }

    private Boolean getMultipleBirth(Person person) {
        BirthRecord birthRecord = person.getBirthRecord();
        if (birthRecord == null || birthRecord.isMultipleBirth() == null) {
            return null;
        }
        return birthRecord.isMultipleBirth();
    }

    private void setBirthRecord(Person person, DemographicIdentityTraitsForm form) {
        BirthRecord birthRecord = person.getBirthRecord();
        if (StringUtils.isNotEmpty((String)form.getDateOfBirth()) || StringUtils.isNotEmpty((String)form.getBirthCity()) || StringUtils.isNotEmpty((String)form.getBirthState())) {
            if (birthRecord == null) {
                birthRecord = new BirthRecord();
                person.setBirthRecord(birthRecord);
            }
            birthRecord.setBirthDate(DateUtils.getImpreciseDate((String)form.getDateOfBirth()));
            birthRecord.setCity(form.getBirthCity());
            birthRecord.setState(form.getBirthState());
            if (!form.isDisabledMultipleBirthIndicator()) {
                this.setMultipleBirth(person, form.getMultipleBirth());
            }
        } else if (birthRecord != null) {
            birthRecord.setBirthDate(null);
            birthRecord.setCity(null);
            birthRecord.setState(null);
            birthRecord.setMultipleBirth(null);
        }
    }

    private void setMultipleBirth(Person person, String setYes) {
        BirthRecord birthRecord = person.getBirthRecord();
        if (setYes == null || setYes.equalsIgnoreCase("nd")) {
            if (birthRecord != null) {
                birthRecord.setMultipleBirth(null);
            }
        } else {
            if (birthRecord == null) {
                birthRecord = new BirthRecord();
            }
            birthRecord.setMultipleBirth(ConvertUtils.convertBoolean(setYes));
            person.setBirthRecord(birthRecord);
        }
    }

    private String getDisplayEthnicity(Person person) {
        return person.getEthnicity() == null ? null : person.getEthnicity().getEthnicityType().getName();
    }

    private String[] getRaceTypes(Person person) {
        Set raceSource = person.getRaces();
        String[] raceTarget = new String[raceSource.size()];
        Race r2 = null;
        String type = null;
        int i = 0;
        for (Race r2 : raceSource) {
            type = r2.getRaceType().getCode();
            raceTarget[i++] = type;
        }
        return raceTarget;
    }

    private String getEthnicity(Person person) {
        return person.getEthnicity() == null ? null : person.getEthnicity().getEthnicityType().getCode();
    }
}

