/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.RelationFinancials;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.esr.ui.common.action.AddressValidationAction;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.demographic.action.DemographicIdentityTraitsForm;
import gov.va.med.esr.ui.demographic.action.SubmittedIdentityTraitsForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

public class DemographicIdentityTraitsAction
extends AddressValidationAction {
    public static final String FORWARD_DEMOGRAPHIC_IDENTITY_TRAITS = "demographicIdentityTraits";
    public static final String FORWARD_DEMOGRAPHIC_OVERVIEW = "demographicOverview";
    public static final String FORWARD_DEMOGRAPHIC_IDENTITY_TRAITS_SUBMITTED = "submitted";
    public static final String FORWARD_CANCEL = "cancel";
    public static final String INVALID_NAME = "errors.invalidMaidenName";
    public static final String FIELD_NAME_SSN = "ssn";
    public static final String LABEL_SSN = "label.ssn.ssn";
    public static final String MESSAGE_KEY_VETERAN_SSN_USED = "errors.veteranSsnUsed";
    public static final String SUBMITTED_IDENTITY_TRAITS_CHANGE_EVENTS = "Submitted_Change_Events";
    public static final String SUBMITTED_IDENTITY_TRAITS_CHANGE_EVENT_KEYS = "Submitted_Change_Event_Keys";
    public static final String BIRTH_CITY_FIELD = "birthCity";
    public static final String BIRTH_STATE_FIELD = "birthState";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        DemographicIdentityTraitsForm ssnForm = this.getIdentityTraitsForm(form);
        ssnForm.setAddAPerson(isAddAPerson);
        this.conversionService.convert((Object)this.getSelectedPerson(request), (Object)ssnForm);
        Boolean isSigiAvailable = super.getSystemParameterService().getEsSidIndicator();
        ssnForm.setDisableSelfIdentifiedGenderIdentity(isSigiAvailable);
        if (isAddAPerson && (StringUtils.isEmpty((String)ssnForm.getMultipleBirth()) || "nd".equalsIgnoreCase(ssnForm.getMultipleBirth()))) {
            ssnForm.setDisabledMultipleBirthIndicator(false);
        } else {
            ssnForm.setDisabledMultipleBirthIndicator(true);
        }
        return mapping.findForward(FORWARD_DEMOGRAPHIC_IDENTITY_TRAITS);
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DemographicIdentityTraitsForm ssnForm = this.getIdentityTraitsForm(form);
        Person selectedPerson = this.getSelectedPerson(request);
        MessageResources messageResources = ssnForm.getResources(request);
        ActionMessages errors = ssnForm.getActionMessages(request);
        if (this.isVeteranSSNUsed(ssnForm, selectedPerson)) {
            errors.add(FIELD_NAME_SSN, new ActionMessage(MESSAGE_KEY_VETERAN_SSN_USED, (Object)messageResources.getMessage(LABEL_SSN)));
            return mapping.findForward(FORWARD_DEMOGRAPHIC_IDENTITY_TRAITS);
        }
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        ssnForm.setAddAPerson(isAddAPerson);
        if (isAddAPerson) {
            ActionForward overviewSuccessForward = new ActionForward(mapping.findForward(FORWARD_DEMOGRAPHIC_IDENTITY_TRAITS));
            ActionForward samePageForward = mapping.findForward(FORWARD_DEMOGRAPHIC_IDENTITY_TRAITS);
            if (!this.stateValid(ssnForm, DemographicIdentityTraitsForm.class, BIRTH_STATE_FIELD, overviewSuccessForward, request)) {
                return samePageForward;
            }
            boolean requiredFieldNotEntered = false;
            if (ssnForm.getLastName() == null || StringUtils.isEmpty((String)ssnForm.getLastName())) {
                requiredFieldNotEntered = true;
                errors.add("LastName", new ActionMessage("errors.required", (Object)"Last Name"));
            }
            if (ssnForm.getSsn() == null || StringUtils.isEmpty((String)ssnForm.getSsn())) {
                requiredFieldNotEntered = true;
                errors.add("Ssn", new ActionMessage("errors.required", (Object)"SSN"));
            }
            if (ssnForm.getGender() == null || StringUtils.isEmpty((String)ssnForm.getGender())) {
                requiredFieldNotEntered = true;
                errors.add("Gender", new ActionMessage("errors.required", (Object)"Gender"));
            }
            if (ssnForm.getDateOfBirth() == null || StringUtils.isEmpty((String)ssnForm.getDateOfBirth())) {
                requiredFieldNotEntered = true;
                errors.add("DateOfBirth", new ActionMessage("errors.required", (Object)"Date Of Birth"));
            }
            if (ssnForm.getMothersMaidenName().trim().equalsIgnoreCase("UNK") || ssnForm.getMothersMaidenName().trim().equalsIgnoreCase("UNKNOWN")) {
                requiredFieldNotEntered = true;
                errors.add("MothersMaidenName", new ActionMessage(INVALID_NAME, (Object)"Value of Mother's Maiden Name"));
            }
            if (requiredFieldNotEntered) {
                return samePageForward;
            }
            Person updatedPerson = (Person)selectedPerson.clone();
            this.conversionService.convert((Object)this.getIdentityTraitsForm(form), (Object)updatedPerson);
            this.updateSelectedPerson(request, updatedPerson);
            return mapping.findForward(FORWARD_DEMOGRAPHIC_OVERVIEW);
        }
        Person updatedPerson = (Person)selectedPerson.clone();
        this.conversionService.convert((Object)this.getIdentityTraitsForm(form), (Object)updatedPerson);
        updatedPerson = this.getDemographicService().updateIdentityTraits(updatedPerson);
        this.updateSelectedPerson(request, updatedPerson);
        return mapping.findForward(FORWARD_DEMOGRAPHIC_OVERVIEW);
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FORWARD_CANCEL);
    }

    public ActionForward displaySubmittedTraits(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubmittedIdentityTraitsForm actionForm = (SubmittedIdentityTraitsForm)form;
        Set changeEventSet = null;
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        if (!isAddAPerson) {
            VPIDEntityKey vpid = this.getSelectedPerson(request).getVPIDEntityKey();
            changeEventSet = this.getDemographicService().getSubmittedIdentityTraitsChangeTimes((EntityKey)vpid);
        }
        if (changeEventSet != null && changeEventSet.size() != 0) {
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    ChangeEvent event1 = (ChangeEvent)pObject1;
                    ChangeEvent event2 = (ChangeEvent)pObject2;
                    if (event1 == null || event1.getTimeStamp() == null) {
                        return -1;
                    }
                    if (event2 == null || event2.getTimeStamp() == null) {
                        return 1;
                    }
                    return event2.getTimeStamp().compareTo(event1.getTimeStamp());
                }
            };
            ArrayList orderedChangeEvents = new ArrayList(changeEventSet);
            Collections.sort(orderedChangeEvents, comparator);
            request.getSession().setAttribute(SUBMITTED_IDENTITY_TRAITS_CHANGE_EVENTS, orderedChangeEvents);
            ArrayList<String> eventKeys = new ArrayList<String>();
            Iterator iter = orderedChangeEvents.iterator();
            while (iter.hasNext()) {
                Timestamp time = ((ChangeEvent)iter.next()).getTimeStamp();
                eventKeys.add(DateUtils.formatWithTime((Date)time, null));
            }
            request.getSession().setAttribute(SUBMITTED_IDENTITY_TRAITS_CHANGE_EVENT_KEYS, eventKeys);
            ChangeEvent changeEvent = (ChangeEvent)orderedChangeEvents.iterator().next();
            String key = DateUtils.formatWithTime((Date)changeEvent.getTimeStamp(), null);
            actionForm.setChangeEventKey(key);
            return this.displaySubmittedTraitsForChangeEvent(mapping, form, request, response);
        }
        request.getSession().setAttribute(SUBMITTED_IDENTITY_TRAITS_CHANGE_EVENTS, null);
        request.getSession().setAttribute(SUBMITTED_IDENTITY_TRAITS_CHANGE_EVENT_KEYS, null);
        return mapping.findForward(FORWARD_DEMOGRAPHIC_IDENTITY_TRAITS_SUBMITTED);
    }

    public ActionForward displaySubmittedTraitsForChangeEvent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List changeEvents = (List)request.getSession().getAttribute(SUBMITTED_IDENTITY_TRAITS_CHANGE_EVENTS);
        SubmittedIdentityTraitsForm actionForm = (SubmittedIdentityTraitsForm)form;
        String key = actionForm.getChangeEventKey();
        if (StringUtils.isNotBlank((String)key)) {
            for (ChangeEvent selectedEvent : changeEvents) {
                if (!key.equals(DateUtils.formatWithTime((Date)selectedEvent.getTimeStamp(), null))) continue;
                HistoricalInfo historicalInfo = this.getDemographicService().getSubmittedIdentityTraitsHistoryByChangeTime(selectedEvent);
                Person personWithTargetTraits = (Person)historicalInfo.getEntity();
                this.conversionService.convert((Object)personWithTargetTraits, (Object)actionForm);
                break;
            }
        }
        return mapping.findForward(FORWARD_DEMOGRAPHIC_IDENTITY_TRAITS_SUBMITTED);
    }

    protected DemographicIdentityTraitsForm getIdentityTraitsForm(ActionForm form) throws ServiceConfigurationException {
        DemographicIdentityTraitsForm identityTraitsForm;
        DemographicIdentityTraitsForm demographicIdentityTraitsForm = identityTraitsForm = form instanceof DemographicIdentityTraitsForm ? (DemographicIdentityTraitsForm)form : null;
        if (identityTraitsForm == null) {
            throw new ServiceConfigurationException("DemographicIdentityTraitsForm not properly configured.");
        }
        return identityTraitsForm;
    }

    private boolean isVeteranSSNUsed(DemographicIdentityTraitsForm form, Person person) {
        if (StringUtils.isNotEmpty((String)form.getSsn())) {
            String vetSsn = SSN.formatSSN((String)form.getSsn());
            Collection finStmts = person.getFinancialStatements().values();
            for (FinancialStatement finStmt : finStmts) {
                Set spouseFins = finStmt.getSpouseFinancials();
                Iterator iterator = spouseFins.iterator();
                while (iterator.hasNext()) {
                    String ssn = this.getRelationSSN((RelationFinancials)((SpouseFinancials)iterator.next()));
                    if (!StringUtils.equals((String)vetSsn, (String)ssn)) continue;
                    return true;
                }
                Set depFins = finStmt.getDependentFinancials();
                Iterator depIter = depFins.iterator();
                while (depIter.hasNext()) {
                    String ssn = this.getRelationSSN((RelationFinancials)((DependentFinancials)depIter.next()));
                    if (!StringUtils.equals((String)vetSsn, (String)ssn)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected String getRelationSSN(RelationFinancials relFinancial) {
        if (relFinancial instanceof SpouseFinancials) {
            SpouseFinancials spouseFin = (SpouseFinancials)relFinancial;
            SSN ssn = spouseFin != null && spouseFin.getReportedOn() != null ? spouseFin.getReportedOn().getOfficialSsn() : null;
            return ssn == null ? null : ssn.getFormattedSsnText();
        }
        if (relFinancial instanceof DependentFinancials) {
            DependentFinancials depFin = (DependentFinancials)relFinancial;
            SSN ssn = depFin != null && depFin.getReportedOn() != null ? depFin.getReportedOn().getOfficialSsn() : null;
            return ssn == null ? null : ssn.getFormattedSsnText();
        }
        return null;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.update", "update");
        map.put("button.continue", "update");
        map.put("button.cancel", FORWARD_CANCEL);
        map.put("text.subMenu.identityTraits", "display");
        map.put("button.identityTraits.viewSubmittedData", "displaySubmittedTraits");
        map.put("button.identityTraits.viewSubmittedDataForChangeEvent", "displaySubmittedTraitsForChangeEvent");
        return map;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

