/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.AddressChangeSource;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.lookup.ConfidentialAddressCategoryType;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.EmailSourceOfChange;
import gov.va.med.esr.common.model.lookup.EmailType;
import gov.va.med.esr.common.model.lookup.PhoneSourceOfChange;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.ConfidentialAddressCategory;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressConversionService;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.demographic.action.DemographicAddressesForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DemographicAddressesConversionService
extends AddressConversionService {
    private static final List PHONE_TYPE_ORDER = new ArrayList();
    private static final List EMAIL_TYPE_ORDER = new ArrayList();

    public DemographicAddressesConversionService() {
        PHONE_TYPE_ORDER.add(PhoneType.CODE_HOME);
        PHONE_TYPE_ORDER.add(PhoneType.CODE_BUSINESS);
        PHONE_TYPE_ORDER.add(PhoneType.CODE_MOBILE);
        PHONE_TYPE_ORDER.add(PhoneType.CODE_PAGER);
        PHONE_TYPE_ORDER.add(PhoneType.CODE_FAX);
        EMAIL_TYPE_ORDER.add(EmailType.CODE_PRIVATE);
        EMAIL_TYPE_ORDER.add(EmailType.CODE_BUSINESS);
    }

    @Override
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        Person person = null;
        DemographicAddressesForm form = null;
        if (source instanceof Person) {
            person = (Person)source;
            if (!(target instanceof DemographicAddressesForm)) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type DemographicAddressesForm.");
            }
            form = (DemographicAddressesForm)((Object)target);
            this.convertPersonToForm(person, form);
        } else if (source instanceof DemographicAddressesForm) {
            form = (DemographicAddressesForm)((Object)source);
            if (!(target instanceof Person)) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type Person.");
            }
            person = (Person)target;
            this.convertFormToPerson(form, person);
        } else {
            throw new ConversionServiceException("Source object is of type " + target.getClass().getName() + " and must be of type Person or DemographicAddressesForm.");
        }
    }

    protected void convertPersonToForm(Person person, DemographicAddressesForm form) throws ConversionServiceException {
        try {
            ArrayList phones = new ArrayList(person.getPhones());
            ArrayList emails = new ArrayList(person.getEmails());
            Address permAddress = person.getPermanentAddress();
            this.convertAddressToForm(permAddress, form);
            if (StringUtils.isBlank((String)form.getCountry())) {
                form.setCountry(Country.CODE_USA.getName());
            }
            if (permAddress != null) {
                boolean isAddAPerson = form.isAddAPerson();
                form.setPermAddrCurrent(DateUtils.isDateBetween((ImpreciseDate)new ImpreciseDate(new Date()), (ImpreciseDate)DateUtils.getBeginningOfDay((ImpreciseDate)permAddress.getStartDate()), (ImpreciseDate)DateUtils.getEndOfDay((ImpreciseDate)permAddress.getEndDate())));
                form.setPermAddrInFuture(DateUtils.isDateBefore((ImpreciseDate)new ImpreciseDate(new Date()), (ImpreciseDate)DateUtils.getBeginningOfDay((ImpreciseDate)permAddress.getStartDate())));
                form.setPermAddrInPast(DateUtils.isDateAfter((ImpreciseDate)new ImpreciseDate(new Date()), (ImpreciseDate)DateUtils.getEndOfDay((ImpreciseDate)permAddress.getEndDate())));
                if (permAddress.getBadAddressReason() != null) {
                    form.setPermBadAddressReason(permAddress.getBadAddressReason().getCode());
                }
                String strFormat = null;
                if (permAddress.getChangeDate() != null) {
                    form.setPermAddrLastUpdate(DateUtils.formatWithTime((Date)permAddress.getChangeDate(), strFormat));
                } else if (isAddAPerson) {
                    Date current = DateUtils.getCurrentDateTime();
                    form.setPermAddrLastUpdate(DateUtils.formatWithTime((Date)current, strFormat));
                }
                if (permAddress.getChangeSource() != null) {
                    form.setPermAddrSourceOfUpdate(permAddress.getChangeSource().getCode());
                }
                if (permAddress.getChangeSite() != null) {
                    form.setPermAddrSiteOfUpdate(permAddress.getChangeSite().getCode());
                }
            }
            form.setPermAddrSourceOfUpdate(AddressChangeSource.CODE_HEC.getName());
            form.setPermAddrSiteOfUpdate(VAFacility.CODE_HEC.getName());
            Address confAddress = person.getConfidentialAddress();
            if (confAddress != null) {
                form.setConfAddrPresent(true);
                form.setConfAddrCurrent(DateUtils.isDateBetween((ImpreciseDate)new ImpreciseDate(new Date()), (ImpreciseDate)DateUtils.getBeginningOfDay((ImpreciseDate)confAddress.getStartDate()), (ImpreciseDate)DateUtils.getEndOfDay((ImpreciseDate)confAddress.getEndDate())));
                form.setConfAddrInFuture(DateUtils.isDateBefore((ImpreciseDate)new ImpreciseDate(new Date()), (ImpreciseDate)DateUtils.getBeginningOfDay((ImpreciseDate)confAddress.getStartDate())));
                form.setConfAddrInPast(DateUtils.isDateAfter((ImpreciseDate)new ImpreciseDate(new Date()), (ImpreciseDate)DateUtils.getEndOfDay((ImpreciseDate)confAddress.getEndDate())));
                form.setConfAddrCategories(this.getConfAddrCategories(person));
            } else {
                form.setConfAddrPresent(false);
            }
            Address tempAddress = person.getTemporaryCorrespondenceAddress();
            if (tempAddress != null) {
                form.setTempAddrPresent(true);
                form.setTempAddrCurrent(DateUtils.isDateBetween((ImpreciseDate)new ImpreciseDate(new Date()), (ImpreciseDate)DateUtils.getBeginningOfDay((ImpreciseDate)tempAddress.getStartDate()), (ImpreciseDate)DateUtils.getEndOfDay((ImpreciseDate)tempAddress.getEndDate())));
                form.setTempAddrInFuture(DateUtils.isDateBefore((ImpreciseDate)new ImpreciseDate(new Date()), (ImpreciseDate)DateUtils.getBeginningOfDay((ImpreciseDate)tempAddress.getStartDate())));
                form.setTempAddrInPast(DateUtils.isDateAfter((ImpreciseDate)new ImpreciseDate(new Date()), (ImpreciseDate)DateUtils.getEndOfDay((ImpreciseDate)tempAddress.getEndDate())));
            } else {
                form.setTempAddrPresent(false);
            }
            for (PhoneType.Code code : PHONE_TYPE_ORDER) {
                this.addPhonesToForm(this.getPhones(phones, code), form);
            }
            this.addPhonesToForm(phones, form);
            for (PhoneType.Code code : EMAIL_TYPE_ORDER) {
                this.addEmailsToForm(this.getEmails(emails, (EmailType.Code)code), form);
            }
            this.addEmailsToForm(emails, form);
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert Person to DemographicAddressesForm.", ex);
        }
    }

    protected void convertFormToPerson(DemographicAddressesForm form, Person person) throws ConversionServiceException {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        try {
            Address permAddress = person.getPermanentAddress();
            if (permAddress == null) {
                permAddress = new Address();
                permAddress.setType((AddressType)lookupCacheService.getByCodeFromCache(AddressType.class, AddressType.CODE_PERMANENT_ADDRESS.getName()));
                person.addAddress(permAddress);
            }
            this.convertFormToAddress(form, permAddress);
            if (StringUtils.isNotEmpty((String)form.getPermBadAddressReason())) {
                permAddress.setBadAddressReason((BadAddressReason)lookupCacheService.getByCodeFromCache(BadAddressReason.class, form.getPermBadAddressReason()));
            } else {
                permAddress.setBadAddressReason(null);
            }
            if (StringUtils.isEmpty((String)form.getPermAddrSourceOfUpdate())) {
                form.setPermAddrSourceOfUpdate(AddressChangeSource.CODE_HEC.getName());
            }
            if (StringUtils.isEmpty((String)form.getPermAddrSiteOfUpdate())) {
                form.setPermAddrSiteOfUpdate(VAFacility.CODE_HEC.getName());
            }
            permAddress.setChangeSource((AddressChangeSource)lookupCacheService.getByCodeFromCache(AddressChangeSource.class, form.getPermAddrSourceOfUpdate()));
            permAddress.setChangeSite((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, form.getPermAddrSiteOfUpdate()));
            boolean isAddAPerson = form.isAddAPerson();
            if (isAddAPerson) {
                Date current = DateUtils.getCurrentDateTime();
                String pAddrLastUpdate = form.getPermAddrLastUpdate();
                if (pAddrLastUpdate == null || StringUtils.isEmpty((String)pAddrLastUpdate)) {
                    permAddress.setChangeDate(current);
                }
            }
            ArrayList<Phone> remainingPhones = new ArrayList<Phone>();
            List phoneIds = form.getPhoneIdList();
            if (phoneIds != null && !phoneIds.isEmpty()) {
                for (int i = 0; i < phoneIds.size(); ++i) {
                    String phoneNumber = form.getPhoneNumber(i);
                    if (!StringUtils.isNotBlank((String)phoneNumber)) continue;
                    Phone phone = null;
                    String phoneId = (String)phoneIds.get(i);
                    if (StringUtils.isNotEmpty((String)phoneId)) {
                        phone = person.getPhoneByEntityKey(CommonEntityKeyFactory.createPhoneEntityKey((String)phoneId));
                    }
                    if (phone == null) {
                        phone = new Phone();
                    }
                    remainingPhones.add(phone);
                    phone.setPhoneNumber(Phone.getFormattedPhone((String)phoneNumber));
                    if (StringUtils.isNotEmpty((String)form.getPhoneType(i))) {
                        phone.setType((PhoneType)lookupCacheService.getByCodeFromCache(PhoneType.class, form.getPhoneType(i)));
                    }
                    if (StringUtils.isEmpty((String)form.getPhoneSourceOfUpdate(i))) {
                        form.setPhoneSourceOfUpdate(i, PhoneSourceOfChange.CODE_HEC.getName());
                    }
                    phone.setSourceOfChange((PhoneSourceOfChange)lookupCacheService.getByCodeFromCache(PhoneSourceOfChange.class, form.getPhoneSourceOfUpdate(i)));
                    if (StringUtils.isEmpty((String)form.getPhoneSiteOfUpdate(i))) {
                        form.setPhoneSiteOfUpdate(i, VAFacility.CODE_HEC.getName());
                    }
                    phone.setSiteOfChange((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, form.getPhoneSiteOfUpdate(i)));
                }
                Phone confidentialPhone = person.getConfidentialPhone();
                person.removeAllPhones();
                for (Phone phone : remainingPhones) {
                    person.addPhone(phone);
                }
                if (confidentialPhone != null) {
                    person.addPhone(confidentialPhone);
                }
            }
            ArrayList<Email> remainingEmails = new ArrayList<Email>();
            List emailIds = form.getEmailIdList();
            if (emailIds != null && !emailIds.isEmpty()) {
                for (int i = 0; i < emailIds.size(); ++i) {
                    String emailAddress = form.getEmailAddress(i);
                    if (!StringUtils.isNotBlank((String)emailAddress)) continue;
                    Email email = null;
                    String emailId = (String)emailIds.get(i);
                    if (StringUtils.isNotEmpty((String)emailId)) {
                        email = person.getEmailByEntityKey(CommonEntityKeyFactory.createEmailEntityKey((String)emailId));
                    }
                    if (email == null) {
                        email = new Email();
                    }
                    remainingEmails.add(email);
                    email.setAddress(emailAddress);
                    if (StringUtils.isNotEmpty((String)form.getEmailType(i))) {
                        email.setType((EmailType)lookupCacheService.getByCodeFromCache(EmailType.class, form.getEmailType(i)));
                    }
                    if (StringUtils.isEmpty((String)form.getEmailSourceOfUpdate(i))) {
                        form.setEmailSourceOfUpdate(i, EmailSourceOfChange.CODE_HEC.getName());
                    }
                    email.setSourceOfChange((EmailSourceOfChange)lookupCacheService.getByCodeFromCache(EmailSourceOfChange.class, form.getEmailSourceOfUpdate(i)));
                    if (StringUtils.isEmpty((String)form.getEmailSiteOfUpdate(i))) {
                        form.setEmailSiteOfUpdate(i, VAFacility.CODE_HEC.getName());
                    }
                    email.setSiteOfChange((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class, form.getEmailSiteOfUpdate(i)));
                }
                person.removeAllEmails();
                for (Email email : remainingEmails) {
                    person.addEmail(email);
                }
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert DemographicAddressesForm to Person.", ex);
        }
    }

    protected List getPhones(List phones, PhoneType.Code phoneType) {
        ArrayList<Phone> phoneList = new ArrayList<Phone>();
        if (phones != null) {
            Iterator iter = phones.iterator();
            while (iter.hasNext()) {
                Phone phone = (Phone)iter.next();
                if (phone.getType() == null || !phone.getType().getCode().equals(phoneType.getName())) continue;
                phoneList.add(phone);
                iter.remove();
            }
        }
        return phoneList;
    }

    protected List getEmails(List emails, EmailType.Code emailType) {
        ArrayList<Email> emailList = new ArrayList<Email>();
        if (emails != null) {
            Iterator iter = emails.iterator();
            while (iter.hasNext()) {
                Email emailAddress = (Email)iter.next();
                if (emailAddress.getType() == null || !emailAddress.getType().getCode().equals(emailType.getName())) continue;
                emailList.add(emailAddress);
                iter.remove();
            }
        }
        return emailList;
    }

    protected void addPhonesToForm(List phones, DemographicAddressesForm form) {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        for (Phone phone : phones) {
            PhoneType code = phone.getType();
            if (code == null) {
                try {
                    phone.setType((PhoneType)lookupCacheService.getByCodeFromCache(PhoneType.class, "1"));
                }
                catch (Exception ex) {
                    new ConversionServiceException("Unable to convert Person to DemographicAddressesForm.", ex);
                }
            }
            if (PhoneType.CODE_CONFIDENTIAL.getCode().equals(phone.getType().getCode())) continue;
            String phoneID = null;
            phoneID = phone.getEntityKey() == null ? "" : phone.getEntityKey().getKeyValueAsString();
            form.addPhone(phoneID, phone.getType().getCode(), phone.getFormattedPhone(), PhoneSourceOfChange.CODE_HEC.getName(), VAFacility.CODE_HEC.getName(), phone.getChangeDate() == null ? "" : DateUtils.formatWithTime((Date)phone.getChangeDate(), null));
        }
    }

    protected void addEmailsToForm(List emailAddresses, DemographicAddressesForm form) {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        for (Email email : emailAddresses) {
            String emailID = null;
            emailID = email.getEntityKey() == null ? "" : email.getEntityKey().getKeyValueAsString();
            EmailType code = email.getType();
            if (code == null) {
                try {
                    email.setType((EmailType)lookupCacheService.getByCodeFromCache(EmailType.class, "1"));
                }
                catch (Exception ex) {
                    new ConversionServiceException("Unable to convert Person to DemographicAddressesForm.", ex);
                }
            }
            form.addEmail(emailID, email.getType().getCode(), email.getAddress(), EmailSourceOfChange.CODE_HEC.getName(), VAFacility.CODE_HEC.getName(), email.getChangeDate() == null ? "" : DateUtils.formatWithTime((Date)email.getChangeDate(), null));
        }
    }

    private List getConfAddrCategories(Person person) {
        Set categoriesSource = person.getConfidentialAddressCategories();
        ArrayList<ConfidentialAddressCategoryType> categoriesTarget = new ArrayList<ConfidentialAddressCategoryType>();
        if (categoriesSource != null && categoriesSource.size() > 0) {
            Object[] catArray = categoriesSource.toArray();
            for (int i = 0; i < catArray.length; ++i) {
                categoriesTarget.add(((ConfidentialAddressCategory)catArray[i]).getType());
            }
        }
        return categoriesTarget;
    }
}

