/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.ui.common.action.AddressValidationAction;
import gov.va.med.esr.ui.demographic.action.DemographicAddressesForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.service.ServiceConfigurationException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class DemographicAddressesAction
extends AddressValidationAction {
    public static final String FORWARD_DEMOGRAPHIC_ADDRESSES = "demographicAddresses";
    public static final String FORWARD_DEMOGRAPHIC_OVERVIEW_SUCCESS = "demographicOverview";
    public static final String FORWARD_DEMOGRAPHIC_OVERVIEW_CANCEL = "cancel";
    public static final String FORWARD_DEMOGRAPHIC_ADDRESSES_HISTORY = "demographicAddressesHistory";
    public static final String FORWARD_508_NOTES = "address508Notes";

    public void afterPropertiesSet() {
    }

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DemographicAddressesForm addressesForm = this.getAddressesForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        addressesForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        this.conversionService.convert((Object)person, (Object)addressesForm);
        this.validateCountryNull(person.getPermanentAddress(), request);
        return mapping.findForward(FORWARD_DEMOGRAPHIC_ADDRESSES);
    }

    @Override
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        form.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DemographicAddressesForm addressesForm = this.getAddressesForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        addressesForm.setAddAPerson(isAddAPerson);
        Person person = this.getSelectedPerson(request);
        Person updatedPerson = (Person)person.clone();
        ActionForward overviewSuccessForward = new ActionForward(mapping.findForward(FORWARD_DEMOGRAPHIC_OVERVIEW_SUCCESS));
        ActionForward demographicAddressesForward = mapping.findForward(FORWARD_DEMOGRAPHIC_ADDRESSES);
        if (Country.isUSAddress((String)addressesForm.getCountry())) {
            if (!this.stateValid(addressesForm, AddressForm.class, "state", overviewSuccessForward, request)) {
                return demographicAddressesForward;
            }
            if (!this.zipCodeMatchesCityAndState(addressesForm, AddressForm.class, "city", "state", "zipCode", request)) {
                return demographicAddressesForward;
            }
        }
        this.conversionService.convert((Object)addressesForm, (Object)updatedPerson);
        if (!isAddAPerson) {
            updatedPerson = this.getDemographicService().updateContactInformation(updatedPerson);
        }
        this.updateSelectedPerson(request, updatedPerson);
        return overviewSuccessForward;
    }

    public ActionForward reset(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DemographicAddressesForm addressesForm = this.getAddressesForm(form);
        addressesForm.reset(mapping, request);
        return this.display(mapping, form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FORWARD_DEMOGRAPHIC_OVERVIEW_CANCEL);
    }

    public ActionForward addPhoneNumber(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DemographicAddressesForm addressesForm = this.getAddressesForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        addressesForm.setAddAPerson(isAddAPerson);
        addressesForm.addNewPhone();
        addressesForm.setAddPhoneType(addressesForm.getPhoneIdList().size() - 1);
        return mapping.findForward(FORWARD_DEMOGRAPHIC_ADDRESSES);
    }

    public ActionForward addEmailAddress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DemographicAddressesForm addressesForm = this.getAddressesForm(form);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        addressesForm.setAddAPerson(isAddAPerson);
        addressesForm.addNewEmail();
        addressesForm.setAddEmailType(addressesForm.getEmailIdList().size() - 1);
        return mapping.findForward(FORWARD_DEMOGRAPHIC_ADDRESSES);
    }

    protected DemographicAddressesForm getAddressesForm(ActionForm form) throws ServiceConfigurationException {
        DemographicAddressesForm addressesForm;
        DemographicAddressesForm demographicAddressesForm = addressesForm = form instanceof DemographicAddressesForm ? (DemographicAddressesForm)form : null;
        if (addressesForm == null) {
            throw new ServiceConfigurationException("DemographicAddressesForm not properly configured.");
        }
        return addressesForm;
    }

    public ActionForward goto508Notes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FORWARD_508_NOTES);
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.cancel", FORWARD_DEMOGRAPHIC_OVERVIEW_CANCEL);
        map.put("button.update", "update");
        map.put("button.reset", "reset");
        map.put("button.addPhoneNumber", "addPhoneNumber");
        map.put("button.addEmailAddress", "addEmailAddress");
        map.put("button.viewAddress508Notes", "goto508Notes");
        map.put("text.subMenu.addresses", "display");
        return map;
    }
}

