/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.conversion;

import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.ui.conversion.CommonConversionServiceImpl;
import gov.va.med.esr.service.HBPDefinitionService;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.UserAdminService;
import gov.va.med.esr.service.VHICCardInfoService;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.conversion.UIConversionService;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.util.StringUtils;

public class UIConversionServiceImpl
extends CommonConversionServiceImpl
implements UIConversionService {
    private LookupCacheService lookupCacheService;
    private PersonHelperService personHelperService;
    private UserAdminService userAdminService;
    private HandBookService handBookService;
    private VHICCardInfoService vhicCardInfoService;
    private HBPDefinitionService hbpDefinitionService;

    @Override
    public LookupCacheService getLookupCacheService() {
        return this.lookupCacheService;
    }

    @Override
    public void setLookupCacheService(LookupCacheService lookupCacheService) {
        this.lookupCacheService = lookupCacheService;
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    public Lookup getLookup(Class clazz, String code) throws ConversionServiceException {
        Lookup lookup = null;
        try {
            if (StringUtils.isNotEmpty((String)code)) {
                lookup = this.getLookupCacheService().getByCodeFromCache(clazz, code);
            }
        }
        catch (Exception ex) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Error while getting lookup object for ");
            buffer.append(" type = " + clazz.getName());
            buffer.append(" code = " + code);
            throw new ConversionServiceException(buffer.toString(), ex);
        }
        return lookup;
    }

    public Boolean getBoolean(String flag) {
        if (StringUtils.isEmpty((String)flag) || StringUtils.equals((String)flag, (String)"nd")) {
            return null;
        }
        return StringUtils.equals((String)flag, (String)"y") ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getBooleanIndicatorCode(String flag) {
        if (StringUtils.isEmpty((String)flag) || StringUtils.equals((String)flag, (String)Indicator.UNKNOWN.getCode())) {
            return null;
        }
        return StringUtils.equals((String)flag, (String)Indicator.YES.getCode()) ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getYesNoNoData(Indicator indicator) {
        if (indicator == null || StringUtils.equals((String)indicator.getCode(), (String)Indicator.UNKNOWN.getCode())) {
            return "nd";
        }
        return StringUtils.equals((String)indicator.getCode(), (String)Indicator.YES.getCode()) ? "y" : "n";
    }

    public Indicator getIndicatorFromYesNoNoData(String flag) throws ConversionServiceException {
        String indFlag = null;
        indFlag = StringUtils.isEmpty((String)flag) || StringUtils.equals((String)flag, (String)"nd") ? Indicator.UNKNOWN.getCode() : (StringUtils.equals((String)flag, (String)"y") ? Indicator.YES.getCode() : Indicator.NO.getCode());
        return StringUtils.isNotEmpty((String)indFlag) ? (Indicator)this.getLookup(Indicator.class, indFlag) : null;
    }

    public String getIndicatorCode(Boolean flag) {
        if (flag == null) {
            return Indicator.UNKNOWN.getCode();
        }
        return flag.equals(Boolean.TRUE) ? Indicator.YES.getCode() : Indicator.NO.getCode();
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.getPersonHelperService() == null) {
            throw new ServiceConfigurationException("Missing required PersonHelperService");
        }
    }

    protected UserPrincipal getLoggedInUser() {
        SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
        return securityContext != null ? securityContext.getUserPrincipal() : null;
    }

    @Override
    public UserAdminService getUserAdminService() {
        return this.userAdminService;
    }

    public void setUserAdminService(UserAdminService userAdminService) {
        this.userAdminService = userAdminService;
    }

    public HandBookService getHandBookService() {
        return this.handBookService;
    }

    public void setHandBookService(HandBookService handBookService) {
        this.handBookService = handBookService;
    }

    public VHICCardInfoService getVhicCardInfoService() {
        return this.vhicCardInfoService;
    }

    public void setVhicCardInfoService(VHICCardInfoService vhicCardInfoService) {
        this.vhicCardInfoService = vhicCardInfoService;
    }

    public HBPDefinitionService getHbpDefinitionService() {
        return this.hbpDefinitionService;
    }

    public void setHbpDefinitionService(HBPDefinitionService hbpDefinitionService) {
        this.hbpDefinitionService = hbpDefinitionService;
    }
}

