/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.comms.action;

import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.action.AddressConversionService;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.comms.action.UndeliverableMailEditPermAddressForm;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;

public class UndeliverableMailEditPermAddressConversionService
extends AddressConversionService {
    @Override
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        Person person = null;
        UndeliverableMailEditPermAddressForm form = null;
        if (source instanceof Person) {
            person = (Person)source;
            if (!(target instanceof UndeliverableMailEditPermAddressForm)) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type UndeliverableMailEditPermAddressForm.");
            }
            form = (UndeliverableMailEditPermAddressForm)((Object)target);
            this.convertPersonToForm(person, form);
        } else if (source instanceof UndeliverableMailEditPermAddressForm) {
            form = (UndeliverableMailEditPermAddressForm)((Object)source);
            if (!(target instanceof Person)) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type Person.");
            }
            person = (Person)target;
            this.convertFormToPerson(form, person);
        } else {
            throw new ConversionServiceException("Source object is of type " + target.getClass().getName() + " and must be of type Person or UndeliverableMailEditPermAddressForm.");
        }
    }

    protected void convertPersonToForm(Person person, UndeliverableMailEditPermAddressForm form) throws ConversionServiceException {
        try {
            Address permAddress = person.getPermanentAddress();
            this.convertAddressToForm(permAddress, form);
            if (StringUtils.isBlank((String)form.getCountry())) {
                form.setCountry(Country.CODE_USA.getName());
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert Person to DemographicAddressesForm.", ex);
        }
    }

    protected void convertFormToPerson(UndeliverableMailEditPermAddressForm form, Person person) throws ConversionServiceException {
        LookupCacheService lookupCacheService = this.getLookupCacheService();
        try {
            Address permAddress = person.getPermanentAddress();
            if (permAddress == null) {
                permAddress = new Address();
                permAddress.setType((AddressType)lookupCacheService.getByCodeFromCache(AddressType.class, AddressType.CODE_PERMANENT_ADDRESS.getName()));
                person.addAddress(permAddress);
            }
            this.convertFormToAddress(form, permAddress);
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Unable to convert DemographicAddressesForm to Person.", ex);
        }
    }
}

