/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.comms.action;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.ui.comms.action.UndeliverableMailAction;
import gov.va.med.esr.ui.comms.action.UndeliverableMailEditPermAddressForm;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UndeliverableMailEditPermAddressAction
extends UndeliverableMailAction {
    public static final String UNDELIVERABLE_MAIL_PERM_ADDR_PERSON_SESSION_KEY = "undeliverableMailPermAddrPerson";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UndeliverableMailEditPermAddressForm addressForm = this.getUndeliverableMailEditPermAddressForm(form);
        Person person = this.retrievePerson(addressForm.getSelectedPersonId(), request);
        this.conversionService.convert((Object)person, (Object)addressForm);
        this.validateCountryNull(person.getPermanentAddress(), request);
        return mapping.findForward("display");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.removePersonFromSession(request);
        return mapping.findForward("returnToPrevScreen");
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UndeliverableMailEditPermAddressForm addressForm = this.getUndeliverableMailEditPermAddressForm(form);
        ActionForward successForward = new ActionForward(mapping.findForward("returnToPrevScreenSuccessfulUpdate"));
        ActionForward errorForward = mapping.findForward("display");
        if (Country.isUSAddress((String)addressForm.getCountry())) {
            if (!this.stateValid(addressForm, AddressForm.class, "state", successForward, request)) {
                return errorForward;
            }
            if (!this.zipCodeMatchesCityAndState(addressForm, AddressForm.class, "city", "state", "zipCode", request)) {
                return errorForward;
            }
        }
        Person person = this.getPersonFromSession(request);
        Person updatedPerson = (Person)person.clone();
        this.conversionService.convert((Object)addressForm, (Object)updatedPerson);
        updatedPerson = this.getDemographicService().updateContactInformation(updatedPerson);
        this.removePersonFromSession(request);
        return successForward;
    }

    protected Person retrievePerson(String personIdString, HttpServletRequest request) throws Exception {
        PersonIdEntityKey entityKey = CommonEntityKeyFactory.createPersonIdEntityKey((String)personIdString);
        Person person = this.getPersonService().getPerson((PersonEntityKey)entityKey);
        request.getSession().setAttribute(UNDELIVERABLE_MAIL_PERM_ADDR_PERSON_SESSION_KEY, (Object)person);
        return person;
    }

    protected Person getPersonFromSession(HttpServletRequest request) {
        return (Person)request.getSession().getAttribute(UNDELIVERABLE_MAIL_PERM_ADDR_PERSON_SESSION_KEY);
    }

    protected void removePersonFromSession(HttpServletRequest request) {
        request.getSession().setAttribute(UNDELIVERABLE_MAIL_PERM_ADDR_PERSON_SESSION_KEY, null);
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.display", "display");
        map.put("button.update", "update");
        map.put("button.cancel", "cancel");
        return map;
    }
}

