/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.comms.action;

import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.UndeliverableMailInfo;
import gov.va.med.esr.service.CommsLogService;
import gov.va.med.esr.ui.comms.action.UndeliverableMailAction;
import gov.va.med.esr.ui.comms.action.UndeliverableMailBarcodeScanningForm;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.ui.valuelist.DefaultSelectableResult;
import gov.va.med.fw.ui.valuelist.SelectableResult;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class UndeliverableMailBarcodeScanningAction
extends UndeliverableMailAction {
    public static final String SCANNED_RESULTS_SESSION_KEY = "undeliverableMailScannedResultsSessionKey";
    public static final String SELECTED_REQUEST_ATTRIBUTE_KEY = "selected";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<String> selectedItems = new ArrayList<String>();
        List results = this.getResultsFromSession(request.getSession());
        for (int i = 0; i < results.size(); ++i) {
            SelectableResult selectableResult = (SelectableResult)results.get(i);
            selectedItems.add(selectableResult.isSelected() ? "checked" : "");
        }
        request.setAttribute(SELECTED_REQUEST_ATTRIBUTE_KEY, selectedItems);
        return mapping.findForward("display");
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.updateSelectedItems(request);
        UndeliverableMailBarcodeScanningForm scanForm = this.getUndeliverableMailBarcodeScanningForm(form);
        String barCode = scanForm.getBarcode();
        if (StringUtils.isEmpty((String)barCode)) {
            this.addActionMessage(request, new ActionMessage("message.comms.barcodeRequired"));
            return this.display(mapping, form, request, response);
        }
        barCode = barCode.trim();
        CommsLogService commsLogService = this.getCommsLogService();
        UndeliverableMailInfo mailInfo = commsLogService.findUndeliverableMailByBarcode(barCode);
        if (mailInfo == null) {
            this.addActionMessage(request, new ActionMessage("message.comms.barcodeNotFound"));
            return this.display(mapping, form, request, response);
        }
        List results = this.getResultsFromSession(request.getSession());
        for (SelectableResult selectableResult : results) {
            if (!barCode.equals(((UndeliverableMailInfo)selectableResult.getResult()).getCommsLogEntry().getBarcode())) continue;
            this.addActionMessage(request, new ActionMessage("message.comms.duplicateBarcode"));
            return this.display(mapping, form, request, response);
        }
        DefaultSelectableResult selectableResult = new DefaultSelectableResult();
        selectableResult.setResult((Object)mailInfo);
        selectableResult.setSelected(true);
        results.add(selectableResult);
        scanForm.setBarcode(null);
        return this.display(mapping, form, request, response);
    }

    public ActionForward reset(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setResultsInSession(request.getSession(), new ArrayList());
        return this.display(mapping, form, request, response);
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.updateSelectedItems(request);
        List selectedResults = ValueListActionUtils.getSelectableResults((List)this.getResultsFromSession(request.getSession()), (Boolean)new Boolean(true));
        if (selectedResults == null || selectedResults.size() == 0) {
            this.addActionMessage(request, new ActionMessage("message.comms.noResultsSelected"));
            return this.display(mapping, form, request, response);
        }
        ArrayList<CommsLogEntry> commsLogEntryList = new ArrayList<CommsLogEntry>();
        for (SelectableResult selectableResult : selectedResults) {
            UndeliverableMailInfo undeliverableMailInfo = (UndeliverableMailInfo)selectableResult.getResult();
            commsLogEntryList.add(undeliverableMailInfo.getCommsLogEntry());
        }
        this.getCommsLogService().processUndeliverableMail(commsLogEntryList);
        this.addInformationMessage(request, "message.comms.successfulStatusUpdate");
        return this.reset(mapping, form, request, response);
    }

    protected void updateSelectedItems(HttpServletRequest request) {
        int i;
        List results = this.getResultsFromSession(request.getSession());
        String[] selectedItems = request.getParameterValues(SELECTED_REQUEST_ATTRIBUTE_KEY);
        HashMap<Integer, String> selectedItemMap = new HashMap<Integer, String>();
        if (selectedItems != null) {
            for (i = 0; i < selectedItems.length; ++i) {
                String selectedItemIndex = selectedItems[i];
                selectedItemMap.put(new Integer(selectedItemIndex), "true");
            }
        }
        for (i = 0; i < results.size(); ++i) {
            SelectableResult selectableResult = (SelectableResult)results.get(i);
            selectableResult.setSelected(selectedItemMap.get(new Integer(i)) != null);
        }
    }

    protected void setResultsInSession(HttpSession session, List results) {
        session.setAttribute(SCANNED_RESULTS_SESSION_KEY, (Object)results);
    }

    protected List getResultsFromSession(HttpSession session) {
        ArrayList results = (ArrayList)session.getAttribute(SCANNED_RESULTS_SESSION_KEY);
        if (results == null) {
            results = new ArrayList();
            this.setResultsInSession(session, results);
        }
        return results;
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.display", "display");
        map.put("button.search", "search");
        map.put("button.update", "update");
        map.put("button.clear", "reset");
        return map;
    }
}

