/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.comms.action;

import gov.va.med.esr.common.model.comms.Document;
import gov.va.med.esr.common.model.comms.DocumentReceipt;
import gov.va.med.esr.common.model.comms.FileInfo;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.external.HandBookInfo;
import gov.va.med.esr.ui.common.action.DownloadAction;
import gov.va.med.esr.ui.comms.action.CommsLogForm;
import gov.va.med.esr.ui.comms.action.HandbookNotAvailableException;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.service.ServiceException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class HandbookDisplayAction
extends DownloadAction {
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    @Override
    protected DownloadAction.StreamInfo getStreamInfo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        File file = mapping.getParameter().equalsIgnoreCase("handbook") ? new File(this.displayHandbook(request)) : new File(this.displayBenefitGlance(request));
        if (!file.exists()) {
            this.logger.error((Object)(file.getAbsoluteFile() + " file does not exist"));
            throw new HandbookNotAvailableException();
        }
        String contentType = "application/pdf";
        if (file.getName() != null && file.getName().endsWith("xml")) {
            try {
                ByteArrayInputStream bais = this.getHandBookService().convertXmlHandBookToPDF(file);
                return new DownloadAction.ByteStreamInfo(contentType, bais);
            }
            catch (ServiceException se) {
                this.logger.error((Object)"ERROR in converting XML handbook into PDF handbook: ", (Throwable)se);
                throw new HandbookNotAvailableException();
            }
        }
        return new DownloadAction.FileStreamInfo(contentType, file);
    }

    public String displayBenefitGlance(HttpServletRequest request) throws Exception {
        String fileId = request.getParameter("fileId");
        if (fileId != null && fileId.length() > 0) {
            BigDecimal id = new BigDecimal(fileId);
            FileInfo fileInfo = this.getHandBookService().getFileInfoById(id);
            this.getHandBookService().recordDocumentAccess(id);
            return this.getHandBookService().getVBRFileLocation(fileInfo.getDirectory()) + fileInfo.getName();
        }
        ArrayList handBookList = new ArrayList();
        Person person = this.getSelectedPerson(request);
        List hbResult = this.getHandBookService().getHandbookInformation(person.getIdentityTraits().getVpid().getVPID());
        String versionStr = request.getParameter("ver");
        int version = 0;
        if (versionStr != null && !versionStr.equals("")) {
            try {
                version = Integer.valueOf(versionStr);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.buildHBVersion(hbResult, "Benefits Profile", handBookList, version);
        HandBookInfo benefitsProfile = (HandBookInfo)handBookList.get(0);
        String fileName = benefitsProfile.getPhysicalLocation() + benefitsProfile.getName();
        return fileName;
    }

    public String displayHandbook(HttpServletRequest request) throws Exception {
        String fileId = request.getParameter("fileId");
        if (fileId != null && fileId.length() > 0) {
            BigDecimal id = new BigDecimal(fileId);
            FileInfo fileInfo = this.getHandBookService().getFileInfoById(id);
            this.getHandBookService().recordDocumentAccess(id);
            return this.getHandBookService().getVBRFileLocation(fileInfo.getDirectory()) + fileInfo.getName();
        }
        ArrayList handBookList = new ArrayList();
        Person person = this.getSelectedPerson(request);
        List hbResult = this.getHandBookService().getHandbookInformation(person.getIdentityTraits().getVpid().getVPID());
        String versionStr = request.getParameter("ver");
        int version = 0;
        if (versionStr != null && !versionStr.equals("")) {
            try {
                version = Integer.valueOf(versionStr);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.buildHBVersion(hbResult, "Handbook", handBookList, version);
        HandBookInfo handBook = (HandBookInfo)handBookList.get(0);
        String fileName = handBook.getPhysicalLocation() + handBook.getName();
        return fileName;
    }

    private List buildHBVersion(List results, String request, List handBookList, int version) throws Exception {
        DocumentReceipt docReceipt = null;
        if (version == 0) {
            docReceipt = (DocumentReceipt)results.get(0);
        } else {
            boolean found = false;
            Iterator iter = results.iterator();
            while (iter.hasNext() && !found) {
                docReceipt = (DocumentReceipt)iter.next();
                int receiptStr = 0;
                try {
                    receiptStr = Integer.valueOf(docReceipt.getReceiptString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (receiptStr != version) continue;
                found = true;
            }
        }
        this.buildDocument(docReceipt, request, handBookList);
        return handBookList;
    }

    private List buildDocument(DocumentReceipt docReceipt, String request, List handBookList) throws Exception {
        Set Documents = docReceipt.getDocuments();
        for (Document doc : Documents) {
            if (doc.getDocumentType().getName() == null || !doc.getDocumentType().getName().contains(request)) continue;
            HandBookInfo hbi = new HandBookInfo();
            hbi.setDocType(doc.getDocumentType().getName());
            hbi.setGeneratedDate(doc.getCreationDate());
            hbi.setName(doc.getFileInfo().getName());
            this.getHandBookService().recordDocumentAccess((BigDecimal)doc.getFileInfo().getEntityKey().getKeyValue());
            hbi.setPhysicalLocation(this.getHandBookService().getVBRFileLocation(doc.getFileInfo().getDirectory()));
            hbi.setReleaseControlNumber(docReceipt.getReleaseControlNumber());
            hbi.setVersion(docReceipt.getVersionNumber());
            handBookList.add(hbi);
        }
        return handBookList;
    }

    public void afterPropertiesSet() {
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title.benefitGlance", "displayBenefitGlance");
        map.put("title.handbook", "displayHandbook");
        return map;
    }

    protected CommsLogForm getCommsLogForm(ActionForm form) throws ServiceConfigurationException {
        CommsLogForm specificForm;
        CommsLogForm commsLogForm = specificForm = form instanceof CommsLogForm ? (CommsLogForm)form : null;
        if (specificForm == null) {
            throw new ServiceConfigurationException("CommsLogForm not properly configured.");
        }
        return specificForm;
    }
}

