/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.comms.action;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.lookup.HandBookMailStatusType;
import gov.va.med.esr.ui.comms.action.CommsLogAction;
import gov.va.med.esr.ui.comms.action.CommsLogForm;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

public class HandbookDetailAction
extends CommsLogAction {
    public static final int MAX_ADD_COMMENTS_LENGTH = 255;

    @Override
    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("detail");
    }

    @Override
    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("commsLog");
    }

    public ActionForward updateComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        HandBookMailQueue log = this.getHandBookService().getHandbookMailQueueEntry(CommonEntityKeyFactory.createHandBookMailQueueEntityKey((String)commsLogForm.getSelectedCommsLogId()));
        if (StringUtils.isNotBlank((String)commsLogForm.getNewComment())) {
            log.setActionComment(commsLogForm.getNewComment());
        }
        if (commsLogForm.isCancelMailing()) {
            this.getHandBookService().changeHandbookMailingStatus(log, (HandBookMailStatusType)this.getLookupCacheService().getByCodeFromCache(HandBookMailStatusType.class, HandBookMailStatusType.CANCEL_BY_HEC.getName()));
        }
        this.getHandBookService().updateRemarks(log);
        return mapping.findForward("commsLog");
    }

    @Override
    public void afterPropertiesSet() {
    }

    @Override
    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title.commsDetail", "display");
        map.put("button.update", "updateComment");
        map.put("button.cancel", "cancel");
        return map;
    }

    public ActionMessages validateAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        if (StringUtils.trimToEmpty((String)commsLogForm.getNewComment()).length() > 255) {
            MessageResources messageResources = commsLogForm.getResources(request);
            this.populateActionForm((ActionForm)commsLogForm, request, HANDBOOK);
            ActionMessages messages = commsLogForm.getActionMessages(request);
            String label = messageResources.getMessage("commsLog.comments");
            messages.add("newComment", new ActionMessage("errors.maxlength", (Object)label, (Object)new Integer(255).toString()));
            return messages;
        }
        return super.validateAction(mapping, form, request, response);
    }
}

