/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.comms.action;

import gov.va.med.esr.common.model.comms.DeliveryPreference;
import gov.va.med.esr.common.model.comms.DeliveryPreferenceEmail;
import gov.va.med.esr.common.model.lookup.DeliveryPreferenceSourceOfChange;
import gov.va.med.esr.common.model.lookup.DeliveryPreferenceType;
import gov.va.med.esr.common.model.lookup.EmailType;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.comms.action.DeliveryPreferencesForm;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;

public class DeliveryPreferencesConversionService
extends UIConversionServiceImpl {
    private static DeliveryPreferenceSourceOfChange SOURCE_CHANGE = null;

    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        DeliveryPreference dp = null;
        DeliveryPreferencesForm form = null;
        if (source instanceof DeliveryPreference) {
            dp = (DeliveryPreference)source;
            if (!(target instanceof DeliveryPreferencesForm)) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type DeliveryPreferencesForm.");
            }
            form = (DeliveryPreferencesForm)((Object)target);
            this.convertDeliveryPreferenceToForm(dp, form);
        } else if (source instanceof DeliveryPreferencesForm) {
            form = (DeliveryPreferencesForm)((Object)source);
            if (!(target instanceof DeliveryPreference)) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type Person.");
            }
            dp = (DeliveryPreference)target;
            this.convertFormToDeliveryPreference(form, dp);
        } else {
            throw new ConversionServiceException("Source object is of type " + target.getClass().getName() + " and must be of type Person or DeliveryPreferencesForm.");
        }
    }

    protected void convertDeliveryPreferenceToForm(DeliveryPreference dp, DeliveryPreferencesForm form) {
        if (dp != null) {
            form.setChangeDate(DateUtils.format((Date)dp.getChangeDate(), null));
            form.setDeliveryPreference(dp.getDeliveryPreferenceType().getCode());
            DeliveryPreferenceEmail dpEmail = dp.getEmail();
            if (dpEmail != null) {
                form.setEmailAddress(dpEmail.getAddress());
                form.setEmailType(dpEmail.getType().getCode());
            }
            form.setSourceOfChange(dp.getSourceOfChange().getCode());
            form.setUserName(dp.getModifiedBy().getName());
        }
    }

    protected void convertFormToDeliveryPreference(DeliveryPreferencesForm form, DeliveryPreference dp) throws ConversionServiceException {
        try {
            if (SOURCE_CHANGE == null) {
                SOURCE_CHANGE = (DeliveryPreferenceSourceOfChange)this.getLookupCacheService().getByCodeFromCache(DeliveryPreferenceSourceOfChange.class, DeliveryPreferenceSourceOfChange.CODE_HEC.getCode());
            }
            dp.setSourceOfChange(SOURCE_CHANGE);
            dp.setChangeDate(new Date());
            dp.setDeliveryPreferenceType(StringUtils.isBlank((String)form.getDeliveryPreference()) ? null : (DeliveryPreferenceType)this.getLookupCacheService().getByCodeFromCache(DeliveryPreferenceType.class, form.getDeliveryPreference()));
            if (StringUtils.isBlank((String)form.getEmailAddress())) {
                dp.setEmail(null);
            } else {
                DeliveryPreferenceEmail email = dp.getEmail();
                if (email == null) {
                    email = new DeliveryPreferenceEmail();
                    email.setDeliveryPreference(dp);
                }
                email.setAddress(form.getEmailAddress());
                email.setType((EmailType)this.getLookupCacheService().getByCodeFromCache(EmailType.class, form.getEmailType()));
                dp.setEmail(email);
            }
        }
        catch (Exception ex) {
            throw new ConversionServiceException("Conversion Failed", ex);
        }
    }
}

