/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.comms.action;

import gov.va.med.esr.common.model.comms.DeliveryPreference;
import gov.va.med.esr.common.model.lookup.DeliveryPreferenceType;
import gov.va.med.esr.common.model.lookup.HandBookMailStatusType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.esr.ui.comms.action.CommsLogAction;
import gov.va.med.esr.ui.comms.action.DeliveryPreferencesForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.service.ServiceException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class DeliveryPreferencesAction
extends CommsLogAction {
    public static final String FORWARD_DELIVERY_PREFERENCES = "deliveryPreferences";
    public static final String FORWARD_CANCEL = "cancel";
    private static final String MESSAGE_DELIVERY_PREFERENCES_UPDATED = "message.deliveryPreferences.updated";
    private static final String MESSAGE_NEED_EMAIL_ADDRESS = "error.deliveryPreferences.needEmail";
    private static final String MESSAGE_NEED_HANDBOOK_SENT = "error.deliveryPreferences.needHandbookSent";
    private static final String HANDBOOK_SEND_TO_CMS_CODE = HandBookMailStatusType.SEND_TO_CMS.getCode();
    public static final int MAX_ADD_COMMENTS_LENGTH = 255;

    @Override
    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DeliveryPreferencesForm dpForm = this.getDeliveryPreferencesForm(form);
        dpForm.setAddAPerson(SessionManager.isAddAPerson(request));
        Person person = this.getSelectedPerson(request);
        DeliveryPreference dp = this.getHandBookService().findDeliveryPreferenceByPersonId(person.getPersonEntityKey().getKeyValueAsString());
        if (dp != null) {
            this.conversionService.convert((Object)dp, (Object)dpForm);
        }
        return mapping.findForward(FORWARD_DELIVERY_PREFERENCES);
    }

    @Override
    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(FORWARD_CANCEL);
    }

    private boolean isHandbookSent(Person person) {
        if (person == null) {
            return false;
        }
        List hbQueues = null;
        try {
            hbQueues = this.getHandBookService().findDeliveryPreferenceEditableStatusByPersonId(person.getEntityKey().getKeyValueAsString());
        }
        catch (ServiceException ex) {
            this.logger.error((Object)"Delivery Preference: Unable to retrieve handbook mailing queue", (Throwable)ex);
            return false;
        }
        return hbQueues != null && hbQueues.size() != 0;
    }

    @Override
    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DeliveryPreferencesForm dpForm = this.getDeliveryPreferencesForm(form);
        Person selectedPerson = this.getSelectedPerson(request);
        if (DeliveryPreferenceType.CODE_ONLINE.getCode().equals(dpForm.getDeliveryPreference())) {
            if (!this.isHandbookSent(selectedPerson)) {
                this.addActionMessage(request, new ActionMessage(MESSAGE_NEED_HANDBOOK_SENT));
                return mapping.findForward(FORWARD_DELIVERY_PREFERENCES);
            }
            if (StringUtils.isBlank((String)dpForm.getEmailAddress()) || StringUtils.isBlank((String)dpForm.getEmailType())) {
                this.addActionMessage(request, new ActionMessage(MESSAGE_NEED_EMAIL_ADDRESS));
                return mapping.findForward(FORWARD_DELIVERY_PREFERENCES);
            }
        }
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        dpForm.setAddAPerson(isAddAPerson);
        DeliveryPreference dp = this.getHandBookService().findDeliveryPreferenceByPersonId(selectedPerson.getPersonEntityKey().getKeyValueAsString());
        if (dp == null) {
            dp = new DeliveryPreference();
            selectedPerson.addDeliveryPreference(dp);
            dp.setDeliveryPreferenceType((DeliveryPreferenceType)this.getLookupCacheService().getByCodeFromCache(DeliveryPreferenceType.class, DeliveryPreferenceType.CODE_MAIL.getCode()));
        }
        DeliveryPreference oldDp = (DeliveryPreference)dp.clone();
        this.conversionService.convert((Object)dpForm, (Object)dp);
        this.getHandBookService().saveDeliveryPreference(dp);
        this.sendEmail(oldDp, dp);
        this.addInformationMessage(request, MESSAGE_DELIVERY_PREFERENCES_UPDATED);
        this.updateSelectedPerson(request, selectedPerson);
        return this.display(mapping, form, request, response);
    }

    private void sendEmail(DeliveryPreference oldDp, DeliveryPreference newDp) throws ServiceException {
        if (oldDp.getDeliveryPreferenceType().getCode().equals(DeliveryPreferenceType.CODE_MAIL.getCode()) && newDp.getDeliveryPreferenceType().getCode().equals(DeliveryPreferenceType.CODE_ONLINE.getCode()) && newDp.getEmail() != null && !StringUtils.isBlank((String)newDp.getEmail().getAddress())) {
            ((CommsEmailBulletinService)this.getBean("commsEmailBulletinService")).sendEmailBulletin(BulletinTrigger.DataType.DELIVERY_PREFERENCE_CHANGE_MAIL_TO_ONLINE, newDp.getEmail().getAddress());
        } else if (oldDp.getDeliveryPreferenceType().getCode().equals(DeliveryPreferenceType.CODE_ONLINE.getCode()) && newDp.getDeliveryPreferenceType().getCode().equals(DeliveryPreferenceType.CODE_MAIL.getCode()) && oldDp.getEmail() != null && !StringUtils.isBlank((String)oldDp.getEmail().getAddress())) {
            ((CommsEmailBulletinService)this.getBean("commsEmailBulletinService")).sendEmailBulletin(BulletinTrigger.DataType.DELIVERY_PREFERENCE_CHANGE_ONLINE_TO_MAIL, oldDp.getEmail().getAddress());
        }
    }

    @Override
    public void afterPropertiesSet() {
    }

    @Override
    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title.deliveryPreferences", "display");
        map.put("button.update", "update");
        map.put("button.cancel", FORWARD_CANCEL);
        return map;
    }

    protected DeliveryPreferencesForm getDeliveryPreferencesForm(ActionForm form) throws ServiceConfigurationException {
        DeliveryPreferencesForm dpForm;
        DeliveryPreferencesForm deliveryPreferencesForm = dpForm = form instanceof DeliveryPreferencesForm ? (DeliveryPreferencesForm)form : null;
        if (dpForm == null) {
            throw new ServiceConfigurationException("DeliveryPreferencesForm not properly configured.");
        }
        return dpForm;
    }
}

