/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.comms.action;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.lookup.ComMailingStatusType;
import gov.va.med.esr.ui.comms.action.CommsLogAction;
import gov.va.med.esr.ui.comms.action.CommsLogForm;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

public class CommsLogDetailAction
extends CommsLogAction {
    public static final int MAX_COMMENTS_LENGTH = 4000;
    public static final int MAX_ADD_COMMENTS_LENGTH = 255;

    @Override
    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("detail");
    }

    @Override
    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("commsLog");
    }

    public ActionForward updateComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ComMailingStatusType status;
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        CommsLogEntry log = this.getCommsLogService().getCommsLogEntry(CommonEntityKeyFactory.createCommsLogEntryEntityKey((String)commsLogForm.getSelectedCommsLogId()));
        if (StringUtils.isNotBlank((String)commsLogForm.getNewComment())) {
            String comment = log.getActionComment();
            int currentLength = comment != null ? comment.length() : 0;
            log.addActionComment(this.formatComment(commsLogForm.getNewComment(), request));
            String updatedComment = log.getActionComment();
            int updatedLength = updatedComment.length();
            int newLength = commsLogForm.getNewComment().length();
            if (updatedLength > 4000) {
                int maxCommentsLength = 4000 - currentLength - (updatedLength - currentLength - newLength);
                maxCommentsLength = maxCommentsLength < 0 ? 0 : maxCommentsLength;
                MessageResources messageResources = commsLogForm.getResources(request);
                ActionMessages messages = commsLogForm.getActionMessages(request);
                String label = messageResources.getMessage("commsLog.comments");
                messages.add("newComment", new ActionMessage("errors.maxlength", (Object)label, (Object)new Integer(maxCommentsLength).toString()));
                return mapping.findForward("detail");
            }
        }
        if (commsLogForm.isCancelMailing()) {
            status = (ComMailingStatusType)this.getLookupCacheService().getByCodeFromCache(ComMailingStatusType.class, ComMailingStatusType.CANCEL_BY_HEC.getName());
            log.addMailingStatus(status);
        } else if (commsLogForm.isReturnedByPostOffice()) {
            status = (ComMailingStatusType)this.getLookupCacheService().getByCodeFromCache(ComMailingStatusType.class, ComMailingStatusType.RETURN_BY_POST_OFFICE.getName());
            log.addMailingStatus(status);
        }
        CommsLogEntry newLog = this.getCommsLogService().updateCommunicationLog(log);
        commsLogForm.setSelectedCommsLog(newLog);
        return mapping.findForward("commsLog");
    }

    @Override
    public void afterPropertiesSet() {
    }

    @Override
    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title.commsDetail", "display");
        map.put("button.update", "updateComment");
        map.put("button.cancel", "cancel");
        return map;
    }

    public ActionMessages validateAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        if (StringUtils.trimToEmpty((String)commsLogForm.getNewComment()).length() > 259) {
            MessageResources messageResources = commsLogForm.getResources(request);
            this.populateActionForm((ActionForm)commsLogForm, request, NON_HANDBOOK);
            ActionMessages messages = commsLogForm.getActionMessages(request);
            String label = messageResources.getMessage("commsLog.comments");
            messages.add("newComment", new ActionMessage("errors.maxlength", (Object)label, (Object)new Integer(255).toString()));
            return messages;
        }
        return super.validateAction(mapping, form, request, response);
    }
}

