/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.comms.action;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.Correspondence;
import gov.va.med.esr.common.model.comms.DeliveryPreference;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.comms.HealthBenefitPlan;
import gov.va.med.esr.common.model.comms.HecRejectReason;
import gov.va.med.esr.common.model.ee.IRS1095B;
import gov.va.med.esr.common.model.ee.MECPeriod;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.ComMailingStatusType;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogDetailEntry;
import gov.va.med.esr.common.model.party.SimpleAddress;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.service.DuplicatePrintRequestServiceException;
import gov.va.med.esr.service.external.VHICCardInfo;
import gov.va.med.esr.service.trigger.LetterTrigger;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.esr.service.trigger.LetterTriggerIdentity;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.comms.action.CommsLogForm;
import gov.va.med.esr.ui.comms.action.DeliveryPreferencesForm;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.mlw.vlh.ValueList;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class CommsLogAction
extends PersonAbstractAction {
    protected static String HANDBOOK = "Handbook";
    protected static String NON_HANDBOOK = "Non Handbook";
    protected static String IRS_SUBMIT = "IRS";
    private String BATCH_TYPE = "V";
    private String CORRECTION_IND = "C";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        Person person = this.getSelectedPerson(request);
        if (SessionManager.isAddAPerson(request)) {
            return mapping.findForward("commsLog");
        }
        List ls = this.getCommsLogService().findLogEntriesByPersonId(person.getPersonEntityKey().getKeyValueAsString());
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"commsLogTableId", (String)"commsLogAdapter", (List)ls);
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        return mapping.findForward("commsLog");
    }

    public ActionForward viewRawData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        Person person = this.getSelectedPerson(request);
        String handbook_mail_queue_id = request.getParameter("ver");
        int receipt_id = Integer.valueOf(handbook_mail_queue_id);
        List ls = this.getHandBookService().getRawProfileData(person.getVPIDValue(), receipt_id);
        String rawData = "";
        for (HealthBenefitPlan hbr : ls) {
            rawData = rawData + hbr.getHealthBenefitCategory() + "^" + hbr.getHealthBenefitCode() + "^" + hbr.getCoveragePlanCode() + "<br/>";
        }
        commsLogForm.setRawData(rawData);
        return mapping.findForward("viewRawData");
    }

    public ActionForward displayHandbookStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        Person person = this.getSelectedPerson(request);
        if (SessionManager.isAddAPerson(request)) {
            return mapping.findForward("handbookStatus");
        }
        List ls = this.getHandBookService().findHandbookEntriesByPersonId(person.getPersonEntityKey().getKeyValueAsString());
        commsLogForm.setHandbookMailValidationErrors(this.getHandBookService().checkHandbookMailValidation(person));
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"commsLogTableId", (String)"commsLogAdapter", (List)ls);
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        List lsHandbookTemplate = this.getHandBookService().findHandbookTemplate();
        ValueList handbookValueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"handbookTemplateTableId", (String)"commsLogAdapter", (List)lsHandbookTemplate);
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)handbookValueList, (String)"vlhlistHandbook");
        return mapping.findForward("handbookStatus");
    }

    public ActionForward displayAvailMailing(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List ls = this.getCommsLetterRequestService().getAvailableLettersForMailing();
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"commsAvailMailTableId", (String)"commsAvailMailAdapter", (List)ls);
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        return mapping.findForward("availMailing");
    }

    public ActionForward displayRejectReason(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("reject");
    }

    public ActionForward displayDetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.populateActionForm(form, request, NON_HANDBOOK);
        return mapping.findForward("detail");
    }

    public ActionForward displayHandbookDetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.populateActionForm(form, request, HANDBOOK);
        return mapping.findForward("handbookDetail");
    }

    public ActionForward displayDeliveryPreferences(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DeliveryPreferencesForm dpForm;
        DeliveryPreferencesForm deliveryPreferencesForm = dpForm = form instanceof DeliveryPreferencesForm ? (DeliveryPreferencesForm)form : null;
        if (dpForm == null) {
            throw new ServiceConfigurationException("DeliveryPreferencesForm not properly configured.");
        }
        dpForm.setAddAPerson(SessionManager.isAddAPerson(request));
        Person person = this.getSelectedPerson(request);
        DeliveryPreference dp = this.getHandBookService().findDeliveryPreferenceByPersonId(person.getPersonEntityKey().getKeyValueAsString());
        if (dp != null) {
            this.conversionService.convert((Object)dp, (Object)dpForm);
        }
        return mapping.findForward("deliveryPreferences");
    }

    protected void populateActionForm(ActionForm form, HttpServletRequest request, String commType) throws Exception {
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        if (commType.equals(HANDBOOK)) {
            HandBookMailQueue entry = this.getHandBookService().getHandbookMailQueueEntry(CommonEntityKeyFactory.createHandBookMailQueueEntityKey((String)commsLogForm.getSelectedCommsLogId()));
            commsLogForm.setSelectedHandbookLog(entry);
            List commentList = this.getHandBookService().getHandbookMailQueueCommentHistory(new BigDecimal(commsLogForm.getSelectedCommsLogId()));
            ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"handbookCommentsTableId", (String)"commsLogAdapter", (List)commentList);
            ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhCommentList");
            List statusList = this.getHandBookService().getHandBookMailStatusHistory(new BigDecimal(commsLogForm.getSelectedCommsLogId()));
            ValueList valueList2 = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"handbookStatusTableId", (String)"commsLogAdapter", (List)statusList);
            ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList2, (String)"vlhStatusList");
            HandBookMailQueue handbook = commsLogForm.getSelectedHandbookLog();
            handbook.setAddress(this.getHandBookService().getHandBookMailingAddress(handbook));
            commsLogForm.setSelectedHandbookLog(handbook);
        } else {
            CommsLogEntry entry = this.getCommsLogService().getCommsLogEntry(CommonEntityKeyFactory.createCommsLogEntryEntityKey((String)commsLogForm.getSelectedCommsLogId()));
            commsLogForm.setSelectedCommsLog(entry);
            ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"mailStatusTableId", (String)"commsLogAdapter", (List)entry.getMailingStatusLinks());
            ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
            if (entry.getLatestMailingStatus().getMailingStatus().getCode().equals(ComMailingStatusType.REJECT_AT_HEC.getName())) {
                Iterator i = entry.getHecRejectionReasons().iterator();
                while (i.hasNext()) {
                    this.addActionMessage(request, ((HecRejectReason)i.next()).getHecRejectReasonDescription());
                }
            }
        }
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Person person = this.getSelectedPerson(request);
            CommsLogForm commsLogForm = this.getCommsLogForm(form);
            ComLetterTemplateType formNumber = (ComLetterTemplateType)this.getLookupCacheService().getByCodeFromCache(ComLetterTemplateType.class, commsLogForm.getSelectedFormNumber());
            String caseId = commsLogForm.getSelectedCaseId();
            String comment = this.formatComment(commsLogForm.getNewComment(), request);
            if (commsLogForm.isOverride()) {
                List conditions = commsLogForm.isRemailInd() ? this.getCommsLetterRequestService().requestAacLetter(person, new LetterTriggerIdentity(formNumber, LetterTrigger.CategoryType.VETERAN_LETTER), caseId, LetterTriggerEvent.REMAIL_MAIL, Boolean.TRUE, comment) : this.getCommsLetterRequestService().requestAacLetter(person, new LetterTriggerIdentity(formNumber, LetterTrigger.CategoryType.VETERAN_LETTER), caseId, LetterTriggerEvent.MANUAL_MAIL, Boolean.TRUE, comment);
                commsLogForm.setFailedConditions(conditions);
            }
        }
        catch (DuplicatePrintRequestServiceException e) {
            this.addActionMessage(request, "message.comms.duplicateLetter");
        }
        return this.display(mapping, form, request, response);
    }

    public ActionForward remail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String caseId = null;
        ComLetterTemplateType formNumber = null;
        List conditions = null;
        Person person = this.getSelectedPerson(request);
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        String id = commsLogForm.getSelectedCommsLogId();
        CommsLogEntry entry = this.getCommsLogService().getCommsLogEntry(CommonEntityKeyFactory.createCommsLogEntryEntityKey((String)commsLogForm.getSelectedCommsLogId()));
        LetterTrigger.CategoryType categoryType = LetterTrigger.CategoryType.VETERAN_LETTER;
        if (entry != null) {
            if ("Spouse".equals(entry.getRecipient())) {
                categoryType = LetterTrigger.CategoryType.SPOUSE_LETTER;
            } else if ("Dependent".equals(entry.getRecipient())) {
                categoryType = LetterTrigger.CategoryType.DEPENDENT_LETTER;
            }
            commsLogForm.setSelectedCommsLog(entry);
            String formNbr = entry.getFormNumber();
            commsLogForm.setSelectedFormNumber(formNbr);
            formNumber = (ComLetterTemplateType)this.getLookupCacheService().getByCodeFromCache(ComLetterTemplateType.class, formNbr);
            if (entry.getWorkflowCaseId() != null) {
                caseId = entry.getWorkflowCaseId().toString();
            }
            commsLogForm.setSelectedCaseId(caseId);
            commsLogForm.setRemailInd(true);
        }
        try {
            conditions = this.getCommsLetterRequestService().requestAacLetter(person, new LetterTriggerIdentity(formNumber, categoryType), caseId, LetterTriggerEvent.REMAIL_MAIL, Boolean.FALSE);
            commsLogForm.setFailedConditions(conditions);
        }
        catch (DuplicatePrintRequestServiceException e) {
            this.addActionMessage(request, "message.comms.duplicateLetter");
        }
        if (this.processValidationMsgs(conditions, request, commsLogForm)) {
            return mapping.findForward("reject");
        }
        return this.display(mapping, form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        commsLogForm.setSelectedCaseId(null);
        commsLogForm.setSelectedFormNumber(null);
        commsLogForm.setSelectedCommsLogId(null);
        return this.display(mapping, form, request, response);
    }

    public ActionForward mail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List conditions = null;
        Person person = this.getSelectedPerson(request);
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        String formNbr = commsLogForm.getSelectedFormNumber();
        commsLogForm.setSelectedFormNumber(formNbr);
        ComLetterTemplateType formNumber = (ComLetterTemplateType)this.getLookupCacheService().getByCodeFromCache(ComLetterTemplateType.class, formNbr);
        commsLogForm.setSelectedFormName(formNumber.getName());
        commsLogForm.setRemailInd(false);
        String caseId = null;
        commsLogForm.setSelectedCaseId(caseId);
        String isHandbook = request.getParameter("handbook");
        if (isHandbook != null && isHandbook.equals("Y")) {
            try {
                conditions = this.getHandBookService().requestHandBook(person.getEntityKey().getKeyValueAsString(), new LetterTriggerIdentity(formNumber, LetterTrigger.CategoryType.VETERAN_LETTER));
                commsLogForm.setFailedConditions(conditions);
            }
            catch (DuplicatePrintRequestServiceException e) {
                this.addActionMessage(request, "message.comms.duplicateLetter");
            }
            if (this.processValidationMsgs(conditions, request, commsLogForm)) {
                return mapping.findForward("reject");
            }
            return this.displayHandbookStatus(mapping, form, request, response);
        }
        try {
            conditions = this.getCommsLetterRequestService().requestAacLetter(person, new LetterTriggerIdentity(formNumber, LetterTrigger.CategoryType.VETERAN_LETTER), caseId, LetterTriggerEvent.MANUAL_MAIL, Boolean.FALSE);
            commsLogForm.setFailedConditions(conditions);
        }
        catch (DuplicatePrintRequestServiceException e) {
            this.addActionMessage(request, "message.comms.duplicateLetter");
        }
        if (this.processValidationMsgs(conditions, request, commsLogForm)) {
            return mapping.findForward("reject");
        }
        return this.display(mapping, form, request, response);
    }

    public ActionForward displayVHICCardStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        VHICCardInfo vhicCardInfo = this.getVhicCardInfoService().getVhicCardInfo();
        commsLogForm.setVhicCardInfo(vhicCardInfo);
        List ls = this.getVhicCardInfoService().getVhicCardInfo().getVhicCardDetailInfoList();
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"vhicCardStatusTableId", (String)"commsLogAdapter", (List)ls);
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        return mapping.findForward("vhicCardStatus");
    }

    public ActionForward displayIRSCorrectionForYear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.displayIRSCorrection(mapping, form, request, response);
    }

    public ActionForward displayACADetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Correspondence entry = this.getCorrespondenceService().getCorrespondenceWithHistory(new BigDecimal(request.getParameter("submissionId")));
        if (entry == null) {
            this.addActionMessage(request, "errorCorrNotFound");
            List ls = ValueListActionUtils.getCachedResults((HttpSession)request.getSession(), (String)"irsCommTableId");
            if (ls != null) {
                ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"irsCommTableId", (String)"commsLogAdapter", (List)ls);
                ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
                return mapping.findForward("irsSubmission");
            }
            return this.displayIRSSubmission(mapping, form, request, response);
        }
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        commsLogForm.setSelectedFormNumber(entry.getLetterTemplate().getCommsTemplateFormNumber());
        commsLogForm.setSelectedFormName(entry.getLetterTemplate().getCommsTemplateName());
        commsLogForm.setSelectedCommsLogId(entry.getEntityKey().getKeyValueAsString());
        commsLogForm.setSelectedCorrespondence(entry);
        ArrayList statusList = entry.getStatusHistory();
        ValueList valueList2 = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"corrStatusTableId", (String)"commsLogAdapter", (List)statusList);
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList2, (String)"vlhStatusList");
        return mapping.findForward("acaDetail");
    }

    public ActionForward displayACADoc(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("acaDetail");
    }

    public ActionForward displayIRSCorrection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommsLogForm commsLogForm = this.getCommsLogForm(form);
        List taxYearList = this.getIrsTransmissionService().getAllowedCorrectionYears(this.getSelectedPerson(request).getPersonEntityKey());
        if (taxYearList == null || taxYearList.isEmpty()) {
            this.addActionMessage(request, "errorNoCorrect");
            List ls = ValueListActionUtils.getCachedResults((HttpSession)request.getSession(), (String)"irsCommTableId");
            if (ls != null) {
                ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"irsCommTableId", (String)"commsLogAdapter", (List)ls);
                ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
                return mapping.findForward("irsSubmission");
            }
            return this.displayIRSSubmission(mapping, form, request, response);
        }
        Collections.sort(taxYearList);
        Collections.reverse(taxYearList);
        commsLogForm.setTaxYearSel(taxYearList.get(0).toString());
        IrsTransmissionLogDetailEntry recent = this.getIrsTransmissionService().getMostRecentTransmissionForYear(this.getSelectedPerson(request).getPersonEntityKey(), commsLogForm.getTaxYearSel(), true);
        this.populateCorrectionForm(commsLogForm, recent, taxYearList, request);
        return mapping.findForward("irsCorrection");
    }

    public IRS1095B convert1095(ActionForm form, HttpServletRequest request) throws Exception {
        IRS1095B entry = new IRS1095B(this.getSelectedPerson(request));
        MECPeriod p = new MECPeriod();
        CommsLogForm dataRecord = this.getCommsLogForm(form);
        p.setCoverageMonths(this.buildCoverageMap(dataRecord));
        p.setCoveredAll12Months(this.isCoveredAll12Months(dataRecord));
        entry.setMecPeriod(p);
        entry.setAddress((SimpleAddress)this.getSelectedPerson(request).getPermanentAddress());
        return entry;
    }

    private boolean isCoveredAll12Months(CommsLogForm dataRecord) {
        return dataRecord.isCoveredJan() && dataRecord.isCoveredFeb() && dataRecord.isCoveredMar() && dataRecord.isCoveredApr() && dataRecord.isCoveredMay() && dataRecord.isCoveredJun() && dataRecord.isCoveredJul() && dataRecord.isCoveredAug() && dataRecord.isCoveredSep() && dataRecord.isCoveredOct() && dataRecord.isCoveredNov() && dataRecord.isCoveredDec();
    }

    private HashMap buildCoverageMap(CommsLogForm dataRecord) {
        HashMap<String, Boolean> coverageMap = new HashMap<String, Boolean>();
        coverageMap.put("1", dataRecord.isCoveredJan());
        coverageMap.put("2", dataRecord.isCoveredFeb());
        coverageMap.put("3", dataRecord.isCoveredMar());
        coverageMap.put("4", dataRecord.isCoveredApr());
        coverageMap.put("5", dataRecord.isCoveredMay());
        coverageMap.put("6", dataRecord.isCoveredJun());
        coverageMap.put("7", dataRecord.isCoveredJul());
        coverageMap.put("8", dataRecord.isCoveredAug());
        coverageMap.put("9", dataRecord.isCoveredSep());
        coverageMap.put("10", dataRecord.isCoveredOct());
        coverageMap.put("11", dataRecord.isCoveredNov());
        coverageMap.put("12", dataRecord.isCoveredDec());
        return coverageMap;
    }

    public ActionForward submitIRS(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<IRS1095B> submission = new ArrayList<IRS1095B>();
        IRS1095B correction = this.convert1095(form, request);
        submission.add(correction);
        this.getIrsTransmissionService().sendSubmit(submission, this.BATCH_TYPE, this.CORRECTION_IND, this.getCommsLogForm(form).getTaxYearSel());
        Correspondence corr = new Correspondence(this.getSelectedPerson(request));
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.valueOf(this.getCommsLogForm(form).getTaxYearSel()));
        corr.setEffectiveDate(cal.getTime());
        this.getCorrespondenceService().triggerNewCMSCorrespondence(corr, ComLetterTemplateType.FORM_NUMBER_800);
        this.addInformationMessage(request, "sendCorrect");
        return this.displayIRSSubmission(mapping, form, request, response);
    }

    public ActionForward remailACA(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getCorrespondenceService().remailCorrespondence(new BigDecimal(request.getParameter("submissionId")));
        this.addInformationMessage(request, "sendRemail");
        return this.displayIRSSubmission(mapping, form, request, response);
    }

    public ActionForward sendReplacement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String submissionId = request.getParameter("submissionId");
        String taxYear = request.getParameter("taxYear");
        String err = this.getIrsTransmissionService().getMostRecentTransmissionForYear(this.getSelectedPerson(request).getPersonEntityKey(), taxYear, false).getErrorDescription();
        if (err != null && err.length() > 0) {
            this.getIrsTransmissionService().retransmitFailedPersonSubmission(new BigDecimal(submissionId));
            this.addInformationMessage(request, "sendReplace");
        } else {
            this.addActionMessage(request, "errorReplace");
        }
        return this.displayIRSSubmission(mapping, form, request, response);
    }

    public ActionForward cancelIRS(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.displayIRSSubmission(mapping, form, request, response);
    }

    public ActionForward cancelACADetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.displayIRSSubmission(mapping, form, request, response);
    }

    public ActionForward cancelACAMail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getCorrespondenceService().cancelCorrespondence(new BigDecimal(request.getParameter("submissionId")));
        this.addInformationMessage(request, "cancelMail");
        return this.displayIRSSubmission(mapping, form, request, response);
    }

    public ActionForward displayIRSSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List ls = this.getIrsTransmissionService().getTransmissionsByPersonId(this.getSelectedPerson(request).getPersonEntityKey());
        ArrayList<ComLetterTemplateType.Code> acaForm = new ArrayList<ComLetterTemplateType.Code>();
        acaForm.add(ComLetterTemplateType.FORM_NUMBER_800);
        acaForm.add(ComLetterTemplateType.FORM_NUMBER_800A);
        acaForm.add(ComLetterTemplateType.FORM_NUMBER_800D);
        ArrayList lsmail = this.getCorrespondenceService().getPersonCorrespondence((BigDecimal)this.getSelectedPerson(request).getPersonEntityKey().getKeyValue(), acaForm);
        Collections.sort(ls, new BeanComparator("batchTransmissionEntry.transmissionDate", (Comparator)new NullComparator()));
        Collections.sort(lsmail, new BeanComparator("statusDate", (Comparator)new NullComparator()));
        Collections.reverse(ls);
        Collections.reverse(lsmail);
        ValueList valueList = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"irsCommTableId", (String)"commsLogAdapter", (List)ls);
        ValueList valueListMail = ValueListActionUtils.getValueList((ActionForm)form, (HttpServletRequest)request, (String)"irsMailCommTableId", (String)"commsLogAdapter", (List)lsmail);
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueList, (String)"vlhlist");
        ValueListActionUtils.setValueList((HttpServletRequest)request, (ValueList)valueListMail, (String)"vlhlistmail");
        return mapping.findForward("irsSubmission");
    }

    public ActionForward displayVHICCardStatusFromVHIC(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addActionMessage(request, new ActionMessage("errors.vhicService.connection"));
        return this.displayVHICCardStatus(mapping, form, request, response);
    }

    public void afterPropertiesSet() {
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title.commsLog", "display");
        map.put("title.availForMailing", "displayAvailMailing");
        map.put("title.rejectReason", "displayRejectReason");
        map.put("title.commsDetail", "displayDetail");
        map.put("title.handbookDetail", "displayHandbookDetail");
        map.put("title.deliveryPreferences", "displayDeliveryPreferences");
        map.put("title.handbookStatus", "displayHandbookStatus");
        map.put("link.viewRawData", "viewRawData");
        map.put("button.mail", "mail");
        map.put("button.remail", "remail");
        map.put("title.remailACA", "remailACA");
        map.put("title.cancelACA", "cancelACAMail");
        map.put("button.update", "update");
        map.put("button.cancel", "cancel");
        map.put("title.vhicCardStatus", "displayVHICCardStatus");
        map.put("title.irsSubmission", "displayIRSSubmission");
        map.put("title.irsCorrection", "displayIRSCorrection");
        map.put("button.queryVHIC", "displayVHICCardStatusFromVHIC");
        map.put("button.submitIRS", "submitIRS");
        map.put("button.cancelIRS", "cancelIRS");
        map.put("button.viewDataTaxYear", "displayIRSCorrectionForYear");
        map.put("title.acaDetail", "displayACADetail");
        map.put("title.acaDoc", "displayACADoc");
        map.put("text.returnACA", "cancelACADetail");
        map.put("text.cancelACAMail", "cancelACAMail");
        return map;
    }

    protected boolean processValidationMsgs(List conditions, HttpServletRequest request, CommsLogForm form) {
        boolean hasRejects = false;
        if (conditions != null) {
            List processList = (List)conditions.get(0);
            form.setRequiredFieldMissingInd(true);
            if (processList.isEmpty()) {
                processList = (List)conditions.get(1);
                form.setRequiredFieldMissingInd(false);
            }
            Iterator i = processList.iterator();
            while (i.hasNext()) {
                this.addActionMessage(request, i.next().toString());
                hasRejects = true;
            }
        }
        return hasRejects;
    }

    protected String formatComment(String comment, HttpServletRequest request) {
        String user = "weblogic";
        SecurityContext securityContext = this.getSecurityContext(request);
        if (securityContext != null) {
            ESRUserPrincipal userPrincipal = (ESRUserPrincipal)securityContext.getUserPrincipal();
            user = userPrincipal.getName();
        }
        StringBuffer format = new StringBuffer();
        Date dt = new Date();
        format.append(DateUtils.format((Date)dt, null));
        format.append("   ");
        format.append(user);
        format.append("   ");
        format.append(comment);
        return format.toString();
    }

    protected CommsLogForm getCommsLogForm(ActionForm form) throws ServiceConfigurationException {
        CommsLogForm specificForm;
        CommsLogForm commsLogForm = specificForm = form instanceof CommsLogForm ? (CommsLogForm)form : null;
        if (specificForm == null) {
            throw new ServiceConfigurationException("CommsLogForm not properly configured.");
        }
        return specificForm;
    }

    public void populateCorrectionForm(CommsLogForm form, IrsTransmissionLogDetailEntry recent, List taxYearList, HttpServletRequest request) {
        form.setTaxYearList(taxYearList);
        form.setAddress(this.getSelectedPerson(request).getPermanentAddress());
        Calendar now = Calendar.getInstance();
        if (recent.getSubmittedData() != null && recent.getSubmittedData().getMecPeriod() != null) {
            form.setCoveredJan(recent.getSubmittedData().getMecPeriod().getCoverageMonths().containsKey("1") ? (Boolean)recent.getSubmittedData().getMecPeriod().getCoverageMonths().get("1") : false);
            form.setCoveredFeb(recent.getSubmittedData().getMecPeriod().getCoverageMonths().containsKey("2") ? (Boolean)recent.getSubmittedData().getMecPeriod().getCoverageMonths().get("2") : false);
            form.setCoveredMar(recent.getSubmittedData().getMecPeriod().getCoverageMonths().containsKey("3") ? (Boolean)recent.getSubmittedData().getMecPeriod().getCoverageMonths().get("3") : false);
            form.setCoveredApr(recent.getSubmittedData().getMecPeriod().getCoverageMonths().containsKey("4") ? (Boolean)recent.getSubmittedData().getMecPeriod().getCoverageMonths().get("4") : false);
            form.setCoveredMay(recent.getSubmittedData().getMecPeriod().getCoverageMonths().containsKey("5") ? (Boolean)recent.getSubmittedData().getMecPeriod().getCoverageMonths().get("5") : false);
            form.setCoveredJun(recent.getSubmittedData().getMecPeriod().getCoverageMonths().containsKey("6") ? (Boolean)recent.getSubmittedData().getMecPeriod().getCoverageMonths().get("6") : false);
            form.setCoveredJul(recent.getSubmittedData().getMecPeriod().getCoverageMonths().containsKey("7") ? (Boolean)recent.getSubmittedData().getMecPeriod().getCoverageMonths().get("7") : false);
            form.setCoveredAug(recent.getSubmittedData().getMecPeriod().getCoverageMonths().containsKey("8") ? (Boolean)recent.getSubmittedData().getMecPeriod().getCoverageMonths().get("8") : false);
            form.setCoveredSep(recent.getSubmittedData().getMecPeriod().getCoverageMonths().containsKey("9") ? (Boolean)recent.getSubmittedData().getMecPeriod().getCoverageMonths().get("9") : false);
            form.setCoveredOct(recent.getSubmittedData().getMecPeriod().getCoverageMonths().containsKey("10") ? (Boolean)recent.getSubmittedData().getMecPeriod().getCoverageMonths().get("10") : false);
            form.setCoveredNov(recent.getSubmittedData().getMecPeriod().getCoverageMonths().containsKey("11") ? (Boolean)recent.getSubmittedData().getMecPeriod().getCoverageMonths().get("11") : false);
            form.setCoveredDec(recent.getSubmittedData().getMecPeriod().getCoverageMonths().containsKey("12") ? (Boolean)recent.getSubmittedData().getMecPeriod().getCoverageMonths().get("12") : false);
        } else {
            MECPeriod m = this.getIrsTransmissionService().combineAllPeriods(recent.getPersonId(), now.get(1));
            form.setCoveredJan(m.getCoverageMonths().containsKey("1") ? (Boolean)m.getCoverageMonths().get("1") : false);
            form.setCoveredFeb(m.getCoverageMonths().containsKey("2") ? (Boolean)m.getCoverageMonths().get("2") : false);
            form.setCoveredMar(m.getCoverageMonths().containsKey("3") ? (Boolean)m.getCoverageMonths().get("3") : false);
            form.setCoveredApr(m.getCoverageMonths().containsKey("4") ? (Boolean)m.getCoverageMonths().get("4") : false);
            form.setCoveredMay(m.getCoverageMonths().containsKey("5") ? (Boolean)m.getCoverageMonths().get("5") : false);
            form.setCoveredJun(m.getCoverageMonths().containsKey("6") ? (Boolean)m.getCoverageMonths().get("6") : false);
            form.setCoveredJul(m.getCoverageMonths().containsKey("7") ? (Boolean)m.getCoverageMonths().get("7") : false);
            form.setCoveredAug(m.getCoverageMonths().containsKey("8") ? (Boolean)m.getCoverageMonths().get("8") : false);
            form.setCoveredSep(m.getCoverageMonths().containsKey("9") ? (Boolean)m.getCoverageMonths().get("9") : false);
            form.setCoveredOct(m.getCoverageMonths().containsKey("10") ? (Boolean)m.getCoverageMonths().get("10") : false);
            form.setCoveredNov(m.getCoverageMonths().containsKey("11") ? (Boolean)m.getCoverageMonths().get("11") : false);
            form.setCoveredDec(m.getCoverageMonths().containsKey("12") ? (Boolean)m.getCoverageMonths().get("12") : false);
        }
    }
}

