/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.util;

import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.text.DateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.EmailValidator;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.FieldChecks;
import org.apache.struts.validator.Resources;

public class EdbStrutsValidator
extends FieldChecks {
    private static final long serialVersionUID = -5044031726509231080L;
    public static final String DEFAULT_CURRENT_YEAR_VAR = "defaultCurrentYear";
    public static final String PASSWORD_REG_EXP = "^(?=.*\\d)(?=.*[a-z])(?=.*[!@#$%^&*()_+=-])(?=.*[A-Z]).{8,32}$";
    public static final String PASSWORD_REG_EXP_LCNS = "^(?=.*\\d)(?=.*[a-z])(?=.*[!@#$%^&*()_+=-]).{8,32}$";
    public static final String PASSWORD_REG_EXP_LCUCS = "^(?=.*[a-z])(?=.*[!@#$%^&*()_+=-])(?=.*[A-Z]).{8,32}$";
    public static final String PASSWORD_REG_EXP_LCUCN = "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,32}$";
    public static final String PASSWORD_REG_EXP_UCNS = "^(?=.*\\d)(?=.*[!@#$%^&*()_+=-])(?=.*[A-Z]).{8,32}$";
    public static final String PATTERN_SSN = "([0-9]{9})";
    public static final String PATTERN_FORMATTED_SSN = "([0-9]{3})-([0-9]{2})-([0-9]{4})";
    public static final String PATTERN_NAME = "^[a-zA-Z-\\s]{1,25}$";
    public static final String PATTERN_REGEX = "[\\s\\w.]*";
    public static final String PATTERN_ALPHANUMERIC = "[a-zA-Z0-9]*";
    public static final String PATTERN_REPORT_PARA = "[a-zA-Z0-9////:\\s,]*";
    public static final String PATTERN_CITY = "[a-zA-Z'\\s]*";
    public static final String PATTERN_Alpha = "[a-zA-Z]*";
    public static final String PATTERN_INVOCATIONARGS = "[a-zA-Z0-9\\s|,=-]*";
    public static final String PATTERN_EMAILDIST = "[a-zA-Z0-9,@.\\-\\_]*";
    public static final String PATTERN_EMAIL = "^[_a-zA-Z0-9-]@.]*";
    public static final String PATTERN_PHONE = "\\([\\d][\\d][\\d]\\)[\\d][\\d][\\d]-[\\d][\\d][\\d][\\d]";

    public static boolean validateSSN(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String ssn = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)ssn)) {
            return true;
        }
        if (ssn.matches(PATTERN_SSN) || ssn.matches(PATTERN_FORMATTED_SSN)) {
            String ssnStr = ssn.replaceAll("-", "");
            String[] startWiths = new String[]{"000", "00000"};
            if (ssnStr.length() != 9 || !StringUtils.isNumeric((String)ssnStr) || StringUtils.isSameCharString((String)ssnStr) || StringUtils.startsWith((String)ssnStr, (String[])startWiths) || ssnStr.startsWith("00", 3) || ssnStr.endsWith("0000") || "123456789".equals(ssnStr)) {
                errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        return false;
    }

    public static boolean validateComments(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String commentStr = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)commentStr)) {
            return true;
        }
        if (commentStr.length() > 200) {
            errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        return true;
    }

    public static boolean validateCommentsOther(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String clVerifiedMethod = field.getVarValue("chosenVerification");
        String isVerifiedOther = ValidatorUtils.getValueAsString((Object)bean, (String)clVerifiedMethod);
        String commentStr = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (isVerifiedOther == "true" && StringUtils.isEmpty((String)commentStr)) {
            errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        return true;
    }

    public static boolean validateVPID(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String vpid = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)vpid)) {
            return true;
        }
        try {
            VPIDEntityKeyImpl.getLongVPID((String)vpid);
            return true;
        }
        catch (Exception e) {
            errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
    }

    public static boolean validateDateAfter(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        String sProperty2 = field.getVarValue("secondDate");
        String value2 = ValidatorUtils.getValueAsString((Object)bean, (String)sProperty2);
        Date date1 = null;
        Date date2 = null;
        DateFormat df = DateFormat.getDateInstance(3);
        try {
            date1 = df.parse(value);
            date2 = df.parse(value2);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (date1 != null && date2 != null) {
            try {
                if (date1.compareTo(date2) <= 0) {
                    errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateDateAfterEqual(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        String sProperty2 = field.getVarValue("secondDate");
        String value2 = ValidatorUtils.getValueAsString((Object)bean, (String)sProperty2);
        Date date1 = null;
        Date date2 = null;
        DateFormat df = DateFormat.getDateInstance(3);
        try {
            date1 = df.parse(value);
            date2 = df.parse(value2);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (date1 != null && date2 != null) {
            try {
                if (date1.compareTo(date2) < 0) {
                    errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateDateBefore(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        String sProperty2 = field.getVarValue("secondDate");
        String value2 = ValidatorUtils.getValueAsString((Object)bean, (String)sProperty2);
        Date date1 = null;
        Date date2 = null;
        DateFormat df = DateFormat.getDateInstance(3);
        try {
            date1 = df.parse(value);
            date2 = df.parse(value2);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (date1 != null && date2 != null) {
            try {
                if (date2.compareTo(date1) <= 0) {
                    errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
        }
        return true;
    }

    public static boolean validatePastDate(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String dateStr = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)dateStr)) {
            return true;
        }
        try {
            Date date = DateUtils.getDate((String)dateStr, (boolean)true);
            Date current = DateUtils.getCurrentDateTime();
            if (date.compareTo(current) <= 0) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        return false;
    }

    public static boolean validatePassword(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String password = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (EdbStrutsValidator.validatePassword(password)) {
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        return false;
    }

    public static Object validateImpreciseDate(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        return EdbStrutsValidator.validateImpreciseDateImpl(bean, va, field, errors, request, false);
    }

    public static Object validateImpreciseDateWithTime(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        return EdbStrutsValidator.validateImpreciseDateImpl(bean, va, field, errors, request, true);
    }

    private static Object validateImpreciseDateImpl(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request, boolean timeSupported) {
        String dateStr = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)dateStr)) {
            return Boolean.TRUE;
        }
        boolean fieldValid = true;
        try {
            boolean useDefaultYear = Boolean.valueOf(field.getVarValue(DEFAULT_CURRENT_YEAR_VAR));
            DateUtils.getImpreciseDate((String)dateStr, (boolean)timeSupported, (boolean)useDefaultYear);
        }
        catch (Exception e) {
            fieldValid = false;
        }
        if (!fieldValid) {
            errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        }
        return fieldValid;
    }

    public static Object validatePreciseDate(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        return EdbStrutsValidator.validatePreciseDateImpl(bean, va, field, errors, request, false);
    }

    public static Object validatePreciseDateWithTime(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        return EdbStrutsValidator.validatePreciseDateImpl(bean, va, field, errors, request, true);
    }

    public static boolean validatePassword(String clearTextPassword) {
        if (StringUtils.isEmpty((String)clearTextPassword)) {
            return true;
        }
        return clearTextPassword.matches(PASSWORD_REG_EXP) || clearTextPassword.matches(PASSWORD_REG_EXP_LCNS) || clearTextPassword.matches(PASSWORD_REG_EXP_LCUCS) || clearTextPassword.matches(PASSWORD_REG_EXP_LCUCN) || clearTextPassword.matches(PASSWORD_REG_EXP_UCNS);
    }

    private static Object validatePreciseDateImpl(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request, boolean timeSupported) {
        String dateStr = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)dateStr)) {
            return Boolean.TRUE;
        }
        boolean fieldValid = true;
        try {
            DateUtils.getDate((String)dateStr, (boolean)timeSupported);
        }
        catch (Exception e) {
            fieldValid = false;
        }
        if (!fieldValid) {
            errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        }
        return fieldValid;
    }

    public static boolean validateSearchSSN(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String ssn = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)ssn)) {
            return true;
        }
        if (ssn.matches(PATTERN_SSN) || ssn.matches(PATTERN_FORMATTED_SSN)) {
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        return false;
    }

    public static boolean validateName(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String name = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)name)) {
            return true;
        }
        if (StringUtils.validateEntry((String)name, (String)PATTERN_NAME)) {
            if (StringUtils.contains((String)name, (String)"--")) {
                errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        return false;
    }

    public static boolean validateFilter(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String filterEntry = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)filterEntry)) {
            return true;
        }
        if (StringUtils.validateEntry((String)filterEntry, (String)PATTERN_REGEX)) {
            if (StringUtils.contains((String)filterEntry, (String)"--")) {
                errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
                return false;
            }
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        return false;
    }

    public static boolean validateAlphaNumeric(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String filterEntry = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)filterEntry)) {
            return true;
        }
        if (StringUtils.validateEntry((String)filterEntry, (String)PATTERN_ALPHANUMERIC)) {
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        return false;
    }

    public static boolean validateReportPara(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String filterEntry = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)filterEntry)) {
            return true;
        }
        if (StringUtils.validateEntry((String)filterEntry, (String)PATTERN_REPORT_PARA)) {
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        return false;
    }

    public static boolean validateCity(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String filterEntry = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)filterEntry)) {
            return true;
        }
        if (StringUtils.validateEntry((String)filterEntry, (String)PATTERN_CITY)) {
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        return false;
    }

    public static boolean validateAlpha(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String filterEntry = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)filterEntry)) {
            return true;
        }
        if (StringUtils.validateEntry((String)filterEntry, (String)PATTERN_Alpha)) {
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        return false;
    }

    public static boolean validateInvoArgs(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String filterEntry = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)filterEntry)) {
            return true;
        }
        if (StringUtils.validateEntry((String)filterEntry, (String)PATTERN_INVOCATIONARGS)) {
            return true;
        }
        return true;
    }

    public static boolean validateDistEmail(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String filterEntry = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)filterEntry)) {
            return true;
        }
        String[] oneEmail = filterEntry.split(",");
        for (int i = 0; i < oneEmail.length; ++i) {
            if (EmailValidator.getInstance().isValid(oneEmail[i])) continue;
            errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
            return false;
        }
        return true;
    }

    public static boolean validatePhone(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String filterEntry = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)filterEntry)) {
            return true;
        }
        if (StringUtils.validateEntry((String)filterEntry, (String)PATTERN_PHONE)) {
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        return false;
    }

    public static boolean validateEmail(Object bean, ValidatorAction va, Field field, ActionMessages errors, HttpServletRequest request) {
        String filterEntry = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isEmpty((String)filterEntry)) {
            return true;
        }
        if (EmailValidator.getInstance().isValid(filterEntry)) {
            return true;
        }
        errors.add(field.getKey(), Resources.getActionMessage((HttpServletRequest)request, (ValidatorAction)va, (Field)field));
        return false;
    }
}

