/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.service;

import gov.va.med.esr.common.model.lookup.City;
import gov.va.med.esr.common.model.lookup.County;
import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.ZipCode;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.action.ZipCodeLookupBean;
import gov.va.med.esr.ui.common.beans.VAMC;
import gov.va.med.esr.ui.common.dao.UIAbstractLookupDAO;
import gov.va.med.esr.ui.common.dao.VAMCDAO;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.springframework.web.context.ServletContextAware;

public final class LookupCacheServiceImpl
extends AbstractComponent
implements LookupCacheService,
ServletContextAware {
    private ServletContext servletContext;
    private static final String LOOKUP_MAP_KEY = "lookupMapKey";
    private static final long ONE_HOUR = 3600000L;
    private static final long DEFAULT_REFRESH_INTERVAL = 8L;
    private long loadTime;
    private long refreshInterval = 28800000L;
    private LookupService lookupService = null;
    private Map daoMap;
    private List nonCachedTypes;

    public void afterPropertiesSet() throws Exception {
        if (this.lookupService == null) {
            throw new ServiceException("LookupService not set");
        }
        if (this.nonCachedTypes == null) {
            this.nonCachedTypes = new ArrayList();
        }
    }

    @Override
    public Collection getFromCache(String className) throws UnknownLookupTypeException, ClassNotFoundException {
        Map map = this.getLookupAsMap(className);
        Collection list = null;
        if (map != null) {
            list = map.values();
        }
        return list;
    }

    @Override
    public Lookup getByCodeFromCache(String className, String code) throws UnknownLookupTypeException, ClassNotFoundException {
        if (StringUtils.isEmpty((String)className) || StringUtils.isEmpty((String)code)) {
            return null;
        }
        Object lookup = null;
        if (this.nonCachedTypes.contains(className)) {
            UIAbstractLookupDAO dao = this.getDAO(className);
            if (dao != null) {
                try {
                    lookup = dao.getByCode(className, code);
                }
                catch (UnknownLookupCodeException e) {
                    lookup = null;
                }
            }
        } else {
            Map map = this.getLookupAsMap(className);
            if (map != null) {
                lookup = (Lookup)map.get(code);
            }
            if (lookup == null) {
                try {
                    Class<?> clazz = Class.forName(className);
                    UIAbstractLookupDAO dao = this.getDAO(clazz);
                    lookup = dao != null ? dao.getByCode(className, code) : this.lookupService.getByCode(Class.forName(className), code);
                }
                catch (UnknownLookupCodeException e) {
                    lookup = null;
                }
            }
        }
        return lookup;
    }

    @Override
    public Lookup getByCodeFromCache(Class clazz, String code) throws UnknownLookupTypeException, ClassNotFoundException {
        if (clazz != null && StringUtils.isNotEmpty((String)code)) {
            return this.getByCodeFromCache(clazz.getName(), code);
        }
        return null;
    }

    private Map getLookupAsMap(String className) throws UnknownLookupTypeException, ClassNotFoundException {
        LinkedHashMap<String, Object> map;
        long currentTime = System.currentTimeMillis();
        HashMap lookupMap = (HashMap)this.servletContext.getAttribute(LOOKUP_MAP_KEY);
        if (lookupMap != null && currentTime > this.loadTime + this.refreshInterval) {
            lookupMap.clear();
            this.loadTime = currentTime;
        }
        if (lookupMap == null) {
            lookupMap = new HashMap();
            this.servletContext.setAttribute(LOOKUP_MAP_KEY, lookupMap);
            this.loadTime = currentTime;
        }
        if ((map = (LinkedHashMap<String, Object>)lookupMap.get(className)) == null) {
            List lookupList = null;
            Class<?> clazz = Class.forName(className);
            UIAbstractLookupDAO dao = this.getDAO(clazz);
            lookupList = dao != null ? dao.findAll() : this.lookupService.findAll(clazz);
            if (lookupList != null) {
                map = new LinkedHashMap<String, Object>();
                Object object2 = null;
                for (Object object2 : lookupList) {
                    if (!(object2 instanceof Lookup)) continue;
                    map.put(((Lookup)object2).getCode(), object2);
                }
                if (!this.nonCachedTypes.contains(className)) {
                    lookupMap.put(className, map);
                }
            }
        }
        return map;
    }

    @Override
    public Map getVISNSiteMap() throws UnknownLookupTypeException, ClassNotFoundException {
        return this.lookupService.getVISNSiteMap();
    }

    @Override
    public Map getParentSiteMap() throws UnknownLookupTypeException, ClassNotFoundException {
        VAMCDAO vamcDAO = (VAMCDAO)this.getDAO(VAMC.class);
        return vamcDAO.getParentSiteMap(this.getLookupService().findAll(VAFacility.class));
    }

    @Override
    public Map getVISNVAMCMap() throws UnknownLookupTypeException, ClassNotFoundException {
        VAMCDAO vamcDAO = (VAMCDAO)this.getDAO(VAMC.class);
        return vamcDAO.getVISNVAMCMap(new ArrayList(this.getFromCache(VAMC.class.getName())));
    }

    protected UIAbstractLookupDAO getDAO(Class lookupType) {
        UIAbstractLookupDAO dao = null;
        if (this.daoMap != null && lookupType != null) {
            dao = (UIAbstractLookupDAO)this.daoMap.get(lookupType.getName());
        }
        return dao;
    }

    protected UIAbstractLookupDAO getDAO(String className) {
        UIAbstractLookupDAO dao = null;
        if (this.daoMap != null && className != null) {
            dao = (UIAbstractLookupDAO)this.daoMap.get(className);
        }
        return dao;
    }

    @Override
    public List getZipCode(String className, String zipCode) throws UnknownLookupTypeException {
        Set cities;
        ArrayList<ZipCodeLookupBean> results = new ArrayList<ZipCodeLookupBean>();
        ZipCode zipCodeObject = this.lookupService.getPartialZipCodeByCode(zipCode);
        if (zipCodeObject == null) {
            return results;
        }
        String state = "";
        State stateObject = zipCodeObject.getState();
        if (stateObject != null) {
            state = stateObject.getName();
        }
        String county = "";
        County countyObject = zipCodeObject.getCounty();
        if (countyObject != null) {
            county = countyObject.getName();
        }
        if ((cities = zipCodeObject.getCities()) == null || cities.isEmpty()) {
            if (StringUtils.isNotEmpty((String)county) && StringUtils.isNotEmpty((String)state)) {
                return results;
            }
            results.add(new ZipCodeLookupBean(zipCode, "", county, state));
        } else {
            for (City city : cities) {
                results.add(new ZipCodeLookupBean(zipCode, city.getName(), county, state));
            }
        }
        return results;
    }

    @Override
    public List getZipCode(Class clazz, String zipCode) throws UnknownLookupTypeException {
        if (clazz != null && StringUtils.isNotEmpty((String)zipCode)) {
            return this.getZipCode(clazz.getName(), zipCode);
        }
        return null;
    }

    public void setRefreshInterval(long refreshTime) {
        if (refreshTime <= 0L) {
            refreshTime = 8L;
        }
        this.refreshInterval = refreshTime * 3600000L;
    }

    @Override
    public LookupService getLookupService() {
        return this.lookupService;
    }

    @Override
    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Map getDaoMap() {
        return this.daoMap;
    }

    public void setDaoMap(Map daoMap) {
        this.daoMap = daoMap;
    }

    public List getNonCachedTypes() {
        return this.nonCachedTypes;
    }

    public void setNonCachedTypes(List nonCachedTypes) {
        this.nonCachedTypes = nonCachedTypes;
    }
}

