/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.dao;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VISN;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.beans.VAMC;
import gov.va.med.esr.ui.common.beans.VAMCSite;
import gov.va.med.esr.ui.common.beans.VISNVAMCSite;
import gov.va.med.esr.ui.common.dao.VAMCDAO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VISNVAMCSiteDAO
extends VAMCDAO {
    @Override
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException {
        ArrayList<Object> filteredVisnVamcSites = new ArrayList<Object>();
        List facilities = this.getLookupService().findAll(this.getBaseLookupClass());
        if (facilities == null) {
            return null;
        }
        List vamcs = this.getVAMCs(facilities);
        Map vamcByVisn = this.getVISNVAMCMap(vamcs);
        Map siteByParent = this.getParentSiteMap(facilities);
        if (vamcByVisn != null) {
            for (VISN visn : vamcByVisn.keySet()) {
                List visnVamcs = visn != null ? (List)vamcByVisn.get(visn) : null;
                if (visnVamcs == null) continue;
                filteredVisnVamcSites.add(visn);
                for (VAFacility vamc : visnVamcs) {
                    if (vamc == null || this.isInList(vamcs, vamc.getParentId())) continue;
                    filteredVisnVamcSites.add((Object)new VAMC(vamc));
                    this.addFacilities(siteByParent, vamc, filteredVisnVamcSites, vamcs, false);
                }
            }
        }
        return filteredVisnVamcSites;
    }

    private void addFacilities(Map siteByParent, VAFacility site, List filteredVamcSites, List vamcs, boolean isChild) {
        List vamcSites;
        if (siteByParent != null && site != null && (vamcSites = (List)siteByParent.get(site.getIdentifier())) != null) {
            for (VAFacility fac : vamcSites) {
                if (fac != null && this.isInList(vamcs, fac.getIdentifier())) {
                    filteredVamcSites.add(new VAMCSite(fac));
                    this.addFacilities(siteByParent, fac, filteredVamcSites, vamcs, true);
                    continue;
                }
                if (fac == null) continue;
                if (isChild) {
                    filteredVamcSites.add(new VISNVAMCSite(fac));
                    continue;
                }
                filteredVamcSites.add(new VAMCSite(fac));
            }
        }
    }
}

