/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.dao;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.beans.VAMC;
import gov.va.med.esr.ui.common.beans.VAMCSite;
import gov.va.med.esr.ui.common.dao.VAMCDAO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VAMCSiteDAO
extends VAMCDAO {
    @Override
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException {
        ArrayList<VAFacility> filteredVamcSites = new ArrayList<VAFacility>();
        List facilities = this.getLookupService().findAll(this.getBaseLookupClass());
        if (facilities == null) {
            return null;
        }
        List vamcs = this.getVAMCs(facilities);
        Map siteByParent = this.getParentSiteMap(facilities);
        if (vamcs != null) {
            for (VAFacility vamc : vamcs) {
                if (vamc == null || this.isInList(vamcs, vamc.getParentId())) continue;
                filteredVamcSites.add(vamc);
                this.addFacilities(siteByParent, vamc, filteredVamcSites, vamcs, false);
            }
        }
        return filteredVamcSites;
    }

    private void addFacilities(Map siteByParent, VAFacility site, List filteredVamcSites, List vamcs, boolean isChild) {
        List vamcSites;
        if (siteByParent != null && site != null && (vamcSites = (List)siteByParent.get(site.getIdentifier())) != null) {
            for (VAFacility fac : vamcSites) {
                if (fac != null && this.isInList(vamcs, fac.getIdentifier())) {
                    filteredVamcSites.add(new VAMC(fac));
                    this.addFacilities(siteByParent, fac, filteredVamcSites, vamcs, true);
                    continue;
                }
                if (fac == null) continue;
                if (isChild) {
                    filteredVamcSites.add(new VAMCSite(fac));
                    continue;
                }
                filteredVamcSites.add(new VAMC(fac));
            }
        }
    }
}

