/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.dao;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VAFacilityType;
import gov.va.med.esr.common.model.lookup.VISN;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.ui.common.dao.VAFacilityAbstractLookupDAO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VAMCDAO
extends VAFacilityAbstractLookupDAO {
    @Override
    public List findAll() throws UnknownLookupTypeException, ClassNotFoundException {
        ArrayList<VAFacility> filteredVamc = new ArrayList<VAFacility>();
        List facilities = this.getLookupService().findAll(this.getBaseLookupClass());
        if (facilities == null) {
            return null;
        }
        List vamcs = this.getVAMCs(facilities);
        for (VAFacility site : vamcs) {
            if (site == null) continue;
            filteredVamc.add(site);
        }
        return filteredVamc;
    }

    public List getVAMCs(List facilities) {
        ArrayList<VAFacility> vamcs = new ArrayList<VAFacility>();
        if (facilities != null) {
            for (VAFacility facility : facilities) {
                if (!facility.getType().getCode().equals(VAFacilityType.CODE_VAMC.getCode())) continue;
                vamcs.add(facility);
            }
        }
        return vamcs;
    }

    protected boolean isInList(List vamcs, BigDecimal Id) {
        if (vamcs != null && Id != null) {
            VAFacility site2 = null;
            for (VAFacility site2 : vamcs) {
                if (!site2.getIdentifier().equals(Id)) continue;
                return true;
            }
        }
        return false;
    }

    public Map getParentSiteMap(List facilities) throws UnknownLookupTypeException, ClassNotFoundException {
        LinkedHashMap facilityByParent = new LinkedHashMap();
        if (facilities != null) {
            for (VAFacility facility : facilities) {
                ArrayList<VAFacility> vamcFacility;
                BigDecimal parentId = facility.getParentId();
                ArrayList<VAFacility> arrayList = vamcFacility = parentId != null ? (ArrayList<VAFacility>)facilityByParent.get(parentId) : null;
                if (vamcFacility == null) {
                    vamcFacility = new ArrayList<VAFacility>();
                    facilityByParent.put(parentId, vamcFacility);
                }
                vamcFacility.add(facility);
            }
        }
        return facilityByParent;
    }

    public Map getVISNVAMCMap(Collection vamcs) throws UnknownLookupTypeException, ClassNotFoundException {
        LinkedHashMap vamcByVisn = new LinkedHashMap();
        LinkedHashMap<VISN, List> facilitySiteMap = new LinkedHashMap<VISN, List>();
        if (vamcs != null) {
            for (VAFacility facility : vamcs) {
                ArrayList<VAFacility> visnVamc;
                BigDecimal visnId = facility.getVisnId();
                ArrayList<VAFacility> arrayList = visnVamc = visnId != null ? (ArrayList<VAFacility>)vamcByVisn.get(visnId) : null;
                if (visnVamc == null) {
                    visnVamc = new ArrayList<VAFacility>();
                    vamcByVisn.put(visnId, visnVamc);
                }
                if (visnVamc == null) continue;
                visnVamc.add(facility);
            }
        }
        List visns = this.getLookupService().findAll(VISN.class);
        for (VISN visn : visns) {
            List visnFacilities = (List)vamcByVisn.get(visn.getIdentifier());
            facilitySiteMap.put(visn, visnFacilities);
        }
        return facilitySiteMap;
    }
}

