/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.common.model.lookup.ZipCode;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.common.action.ZipCodeLookupBean;
import gov.va.med.fw.util.StringUtils;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ZipCodeLookupAction
extends AbstractAction {
    public static final String ZIP_CODE = "zipCode";
    public static final String ROOT_ELEMENT_START = "<message>";
    public static final String ROOT_ELEMENT_END = "</message>";
    public static final String ZIP_CODE_LOOKUP_START = "<zipCodeLookup>";
    public static final String ZIP_CODE_LOOKUP_END = "</zipCodeLookup>";
    public static final String KEY_START = "<key>";
    public static final String KEY_END = "</key>";
    public static final String VALUE_START = "<value>";
    public static final String VALUE_END = "</value>";

    public ActionForward lookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String zipCode = request.getParameter(ZIP_CODE);
        String xml = "";
        if (StringUtils.isNotEmpty((String)zipCode)) {
            List list = this.getLookupCacheService().getZipCode(ZipCode.class, zipCode);
            xml = this.buildLookupXml(list);
        }
        response.setContentType("text/xml");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        out.println(xml);
        out.flush();
        return null;
    }

    private String buildLookupXml(List list) {
        StringBuffer xml = new StringBuffer();
        xml.append(ROOT_ELEMENT_START);
        if (list != null && !list.isEmpty()) {
            for (ZipCodeLookupBean ZipCodeLookupBean2 : list) {
                xml.append(ZIP_CODE_LOOKUP_START);
                xml.append(KEY_START);
                xml.append(ZipCodeLookupBean2.getKeyString());
                xml.append(KEY_END);
                xml.append(VALUE_START);
                xml.append(ZipCodeLookupBean2.getFormattedZipLocation());
                xml.append(VALUE_END);
                xml.append(ZIP_CODE_LOOKUP_END);
            }
        }
        xml.append(ROOT_ELEMENT_END);
        return xml.toString();
    }

    public void afterPropertiesSet() {
    }
}

