/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.common.model.person.PersonMergeInfo;
import gov.va.med.esr.service.PersonMergeService;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.ui.DelegatingActionUtils;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.web.context.WebApplicationContext;

public class SessionDestroyListener
extends ApplicationObjectSupport
implements HttpSessionListener {
    private static final String PERSON_MERGE_SERVICE = "personMergeService";
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        EntityKey key = (EntityKey)session.getAttribute("LockedMergeInfoEntityKey");
        if (key != null) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Unlocking person merge (from sessionDestroyed) record with ID " + key.getKeyValueAsString() + " on session " + session.getId() + " and lock key removed from session."));
                }
                session.setAttribute("LockedMergeInfoEntityKey", null);
                PersonMergeService mergeService = this.getPersonMergeService(session);
                PersonMergeInfo info = mergeService.getPersonMergeInfo(key);
                if (info != null) {
                    info.setRecordLocked(Boolean.FALSE);
                    mergeService.updatePersonMergeInfo(info);
                }
            }
            catch (ServiceException ex) {
                this.logger.error((Object)("Error to unlock PersonMergeInfo for key: " + key), (Throwable)ex);
            }
        }
    }

    public PersonMergeService getPersonMergeService(HttpSession session) {
        WebApplicationContext appContext = DelegatingActionUtils.findRequiredWebApplicationContext((ServletContext)session.getServletContext());
        return (PersonMergeService)appContext.getBean(PERSON_MERGE_SERVICE, PersonMergeService.class);
    }
}

