/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.ui.admin.action.UserSessionsAbstractAction;
import gov.va.med.fw.util.StringUtils;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SendAsyncMessageAction
extends UserSessionsAbstractAction {
    public static final String SESSION_ID_PARAM = "sessionId";
    public static final String MESSAGE_PARAM = "message";
    public static final String FROM_USERNAME_PARAM = "fromUsername";
    public static final String TO_USERNAME_PARAM = "toUsername";
    public static final String ROOT_ELEMENT_START = "<message>";
    public static final String ROOT_ELEMENT_END = "</message>";
    public static final String USER_MESSAGE_START = "<userMessage>";
    public static final String USER_MESSAGE_END = "</userMessage>";
    public static final String VALUE_START = "<value>";
    public static final String VALUE_END = "</value>";

    public ActionForward sendAsyncMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String sessionId = request.getParameter(SESSION_ID_PARAM);
        String message = request.getParameter(MESSAGE_PARAM);
        String fromUsername = request.getParameter(FROM_USERNAME_PARAM);
        String toUsername = request.getParameter(TO_USERNAME_PARAM);
        if (StringUtils.isBlank((String)fromUsername)) {
            fromUsername = "[UNKNOWN]";
        }
        if (StringUtils.isBlank((String)toUsername)) {
            toUsername = "[UNKNOWN]";
        }
        Validate.notNull((Object)message, (String)"No message was found on the sendAsyncMessage request.");
        String sendMessage = "Message from user " + fromUsername + ": '" + message + "'.";
        String xml = null;
        if (StringUtils.isBlank((String)sessionId)) {
            this.broadcastAsyncMessage(request, sendMessage);
            xml = this.buildResponseXml("Broadcast message successfully placed in queue for all users: '" + message + "'.");
        } else if (this.getSessionById(request, sessionId) != null) {
            this.sendAsyncMessage(request, sessionId, sendMessage);
            xml = this.buildResponseXml("Message successfully placed in queue for user " + toUsername + ": '" + message + "'.");
        } else {
            xml = this.buildResponseXml("Unable to send message to user " + toUsername + " because their session was " + "not found: '" + message + "'.");
        }
        response.setContentType("text/xml");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        out.println(xml);
        out.flush();
        return null;
    }

    protected String buildResponseXml(String returnMessage) {
        StringBuffer xml = new StringBuffer();
        xml.append(ROOT_ELEMENT_START);
        if (StringUtils.isNotBlank((String)returnMessage)) {
            xml.append(USER_MESSAGE_START);
            xml.append(VALUE_START);
            xml.append(returnMessage);
            xml.append(VALUE_END);
            xml.append(USER_MESSAGE_END);
        }
        xml.append(ROOT_ELEMENT_END);
        return xml.toString();
    }

    @Override
    public void afterPropertiesSet() {
    }
}

