/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.MedalOfHonor;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.EmergencyResponse;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.EmergencyResponseIndicator;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.ui.common.action.HistoryAction;
import gov.va.med.fw.model.EntityKey;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;

public class PersonHistoryAction
extends HistoryAction {
    @Override
    public EntityKey getEntityKey(HttpServletRequest request, String className) throws Exception {
        String personId = this.getSelectedPersonId(request);
        Validate.notNull((Object)personId);
        return CommonEntityKeyFactory.createPersonIdEntityKey((String)personId);
    }

    @Override
    protected boolean requiresSelectedPerson() {
        return true;
    }

    public String getEnrollmentPriority(EnrollmentDetermination enroll) {
        if (enroll != null && enroll.getPriorityGroup() != null) {
            String priority = enroll.getPriorityGroup().getDescription();
            if (enroll.getPrioritySubGroup() != null) {
                priority = priority + enroll.getPrioritySubGroup().getDescription();
            }
            priority = priority.replaceAll("Enrollment Priority sub-Group", "");
            return priority.replaceAll("'", "");
        }
        return null;
    }

    public String getEGTPriority(EnrollmentDetermination enrol) {
        if (enrol != null && enrol.getEgtSetting() != null) {
            String priority;
            EnrollmentPriorityGroup group = enrol.getEgtSetting().getPriorityGroup();
            EnrollmentPrioritySubGroup subgroup = enrol.getEgtSetting().getPrioritySubGroup();
            String string = priority = group != null ? group.getDescription() : "";
            if (subgroup != null) {
                priority = priority + subgroup.getDescription();
            }
            priority = priority.replaceAll("Enrollment Priority sub-Group '", "");
            return priority.replaceAll("'", "");
        }
        return null;
    }

    public Integer getCount(Set hbpSet) {
        return hbpSet.size();
    }

    public String getCancelDeclineIndicator(Person person) {
        CancelDecline cancelDecline = person.getCancelDecline();
        if (cancelDecline == null || cancelDecline.getCancelDeclineIndicator() == null) {
            return "No Data";
        }
        return Boolean.TRUE.equals(cancelDecline.getCancelDeclineIndicator()) ? "Yes" : "No";
    }

    public IncomeTest getIncomeTest(Person person) {
        if (person == null) {
            return null;
        }
        Map incomeTests = person.getIncomeTests();
        if (incomeTests != null && incomeTests.size() > 0) {
            Set keys = incomeTests.keySet();
            Object incomeYear = keys.iterator().next();
            return (IncomeTest)incomeTests.get(incomeYear);
        }
        return null;
    }

    public FinancialStatement getFinancialStatement(Person person) {
        if (person == null) {
            return null;
        }
        Map FinancialStatements = person.getFinancialStatements();
        if (FinancialStatements != null && FinancialStatements.size() > 0) {
            Set keys = FinancialStatements.keySet();
            Object incomeYear = keys.iterator().next();
            return (FinancialStatement)FinancialStatements.get(incomeYear);
        }
        return null;
    }

    public Set getSpouses(Person person) {
        HashSet<Spouse> spouses = new HashSet<Spouse>();
        if (person != null) {
            Set sfs = this.getSpouseFinancials(person);
            Iterator i = sfs.iterator();
            while (i.hasNext()) {
                spouses.add(((SpouseFinancials)i.next()).getReportedOn());
            }
        }
        return spouses;
    }

    public Set getSpouseFinancials(Person person) {
        if (person == null) {
            return new HashSet();
        }
        FinancialStatement stmt = this.getFinancialStatement(person);
        return stmt != null ? stmt.getSpouseFinancials() : new HashSet();
    }

    public Set getDependents(Person person) {
        HashSet<Dependent> dependents = new HashSet<Dependent>();
        if (person == null) {
            return dependents;
        }
        Set depFinancials = this.getDependentFinancials(person);
        for (DependentFinancials financials : depFinancials) {
            if (financials.getReportedOn() == null) continue;
            dependents.add(financials.getReportedOn());
        }
        return dependents;
    }

    public Set getDependentFinancials(Person person) {
        if (person == null) {
            return new HashSet();
        }
        FinancialStatement stmt = this.getFinancialStatement(person);
        return stmt != null ? stmt.getDependentFinancials() : new HashSet();
    }

    public Set getBeneficiaryTravels(Person person) {
        Map map = person.getBeneficiaryTravels();
        if (map == null || map.size() == 0) {
            return null;
        }
        return new HashSet(map.values());
    }

    public Set getIncomeTestStatuses(Person person) {
        IncomeTest incomeTest = this.getIncomeTest(person);
        return incomeTest == null ? null : incomeTest.getStatuses();
    }

    public EmergencyResponse getEmergencyResponse(Person person) {
        if (person == null) {
            return null;
        }
        Set emerResps = person.getEmergencyResponseIndicators();
        EmergencyResponseIndicator emerRespInd = emerResps != null && !emerResps.isEmpty() ? (EmergencyResponseIndicator)emerResps.iterator().next() : null;
        return emerRespInd != null ? emerRespInd.getEmergencyResponse() : null;
    }

    public SpecialFactor getAgentOrangeExposure(Person person) {
        if (person == null) {
            return null;
        }
        return person.getSpecialFactorByType(AgentOrangeExposure.class);
    }

    public SpecialFactor getRadiationExposure(Person person) {
        if (person == null) {
            return null;
        }
        return person.getSpecialFactorByType(RadiationExposure.class);
    }

    public String isSHAD(Person person) {
        return person != null && person.getShad() != null && person.getShad().getShadIndicator() != null ? person.getShad().getShadIndicator().getName() : null;
    }

    public MedalOfHonor isMedalOfHonor(Person person) {
        return person != null && person.getMedalOfHonor() != null ? person.getMedalOfHonor() : null;
    }

    public String isEnvironmentalContaminationExposure(Person person) {
        if (person == null) {
            return null;
        }
        EnvironmentalContaminationExposure env = (EnvironmentalContaminationExposure)person.getSpecialFactorByType(EnvironmentalContaminationExposure.class);
        return env != null && env.getEnvironmentalContaminationExposureIndicator() != null ? env.getEnvironmentalContaminationExposureIndicator().getName() : null;
    }

    public String getDeathVerificationDisplay(Person person) {
        String deathVerificationDisplay = null;
        deathVerificationDisplay = person.getDeathRecord().getDodVerifiedInd() == null || person.getDeathRecord().getDodVerifiedInd() != false ? "VERIFIED" : "UNVERIFIED";
        return deathVerificationDisplay;
    }
}

