/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonMergeInfo;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonLockedException;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.common.beans.VeteranHeaderBean;
import gov.va.med.esr.ui.ee.action.EligibilityEnrollmentConversionService;
import gov.va.med.esr.ui.util.NameHelper;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.service.EntityNotChangedException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.ServiceOptimisticLockException;
import gov.va.med.fw.service.TimeoutServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class PersonAbstractAction
extends AbstractAction {
    public static final String FORWARD_PERSON_SEARCH = "person.search.display";
    public static final String PERSON_LOCKED_ERROR_KEY = "error.personLocked";
    public static final String TIMEOUT_ERROR_KEY = "error.timeout";
    public static final String INVALID_ARGUMENT_KEY = "error.invalid.parameter.combination";

    protected PersonAbstractAction() {
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.requiresSelectedPerson()) {
            Person person = this.getSelectedPerson(request);
            boolean isAddAPerson = SessionManager.isAddAPerson(request);
            if (person == null) {
                return mapping.findForward(FORWARD_PERSON_SEARCH);
            }
        }
        return super.execute(mapping, form, request, response);
    }

    protected boolean requiresSelectedPerson() {
        return true;
    }

    protected String getSelectedPersonId(HttpServletRequest request) {
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        if (isAddAPerson) {
            return null;
        }
        Person selectedPerson = this.getSelectedPerson(request);
        String personId = null;
        if (selectedPerson != null) {
            personId = selectedPerson.getEntityKey().getKeyValueAsString();
        }
        return personId;
    }

    protected void updateSelectedPerson(HttpServletRequest request, Person person) throws ServiceException {
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        if (isAddAPerson) {
            this.setSelectedPerson(request, person);
        } else {
            PersonIdEntityKey personEntityKey = CommonEntityKeyFactory.createPersonIdEntityKey((String)person.getEntityKey().getKeyValueAsString());
            Person updatedPerson = this.getPersonService().getPerson((PersonEntityKey)personEntityKey);
            updatedPerson.setOpenCasesCount(this.getWorkflowService().getOpenCasesCount(updatedPerson.getPersonEntityKey()));
            this.setSelectedPerson(request, updatedPerson);
        }
    }

    protected void updateSelectedPerson(HttpServletRequest request, Person person, boolean fromUI) throws ServiceException {
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        if (isAddAPerson) {
            this.setSelectedPerson(request, person);
        } else {
            Person updatedPerson = null;
            PersonIdEntityKey personEntityKey = CommonEntityKeyFactory.createPersonIdEntityKey((String)person.getEntityKey().getKeyValueAsString());
            updatedPerson = fromUI ? this.getPersonService().getPerson((PersonEntityKey)personEntityKey, person.getIdentityTraits()) : this.getPersonService().getPerson((PersonEntityKey)personEntityKey);
            updatedPerson.setOpenCasesCount(this.getWorkflowService().getOpenCasesCount(updatedPerson.getPersonEntityKey()));
            this.setSelectedPerson(request, updatedPerson);
        }
    }

    protected void setSelectedPerson(HttpServletRequest request, Person person) {
        this.putSandboxEntry(request, "SelectedPerson", person);
        this.removeSelectedTraits(request);
        this.updateHeader(request);
    }

    protected Person getSelectedPerson(HttpServletRequest request) {
        return (Person)this.getSandboxEntry(request, "SelectedPerson");
    }

    protected void removeSelectedPerson(HttpServletRequest request) {
        this.removeSandboxEntry(request, "SelectedPerson");
        this.removeSelectedTraits(request);
    }

    protected PersonIdentityTraits getSelectedTraits(HttpServletRequest request) {
        return (PersonIdentityTraits)this.getSandboxEntry(request, "SelectedTraits");
    }

    protected void removeSelectedTraits(HttpServletRequest request) {
        this.removeSandboxEntry(request, "SelectedTraits");
    }

    protected void setUpdatedPerson(HttpServletRequest request, Person person) {
        this.putSandboxEntry(request, "UpdatedPerson", person);
    }

    protected void removeUpdatedPerson(HttpServletRequest request) {
        this.removeSandboxEntry(request, "UpdatedPerson");
    }

    protected Person getUpdatedPerson(HttpServletRequest request) {
        return (Person)this.getSandboxEntry(request, "UpdatedPerson");
    }

    protected void updateHeader(HttpServletRequest request) {
        String priority;
        int shortIndex;
        Person person = this.getSelectedPerson(request);
        if (person == null) {
            return;
        }
        VeteranHeaderBean vetHeader = new VeteranHeaderBean();
        String formattedName = NameHelper.formatNameLastNameFirst((Name)NameHelper.getLegalName((Person)person));
        vetHeader.setName(StringUtils.isBlank((String)formattedName) ? null : formattedName.toUpperCase());
        vetHeader.setDob(person.getBirthRecord() == null ? null : person.getBirthRecord().getBirthDate());
        vetHeader.setDod(person.getDeathRecord() == null ? null : person.getDeathRecord().getDeathDate());
        vetHeader.setSensitiveRecord(person.getSensitiveRecord());
        vetHeader.setOpenCases(person.getOpenCasesCount() > 0 ? Boolean.TRUE : Boolean.FALSE);
        vetHeader.setPersonLockReason(person.isPersonLocked() ? person.getPersonLockedReason().toString().toUpperCase() : null);
        SSN ssn = null;
        if (!SessionManager.isAddAPerson(request)) {
            ssn = person.getOfficialSsn();
        } else {
            Iterator iter = person.getSsns().iterator();
            while (iter.hasNext() && (ssn = (SSN)iter.next()) == null && !ssn.equals((Object)"")) {
            }
        }
        vetHeader.setSsn(ssn == null || ssn.getSsnText() == null ? null : ssn.getSsnText().toUpperCase());
        EnrollmentDetermination enrollDeter = person.getEnrollmentDetermination();
        EnrollmentStatus enrollStatus = null;
        String status = "";
        if (enrollDeter != null) {
            enrollStatus = person.getEnrollmentDetermination().getEnrollmentStatus();
        }
        if (enrollStatus != null && StringUtils.isNotBlank((String)enrollStatus.getDescription()) && (shortIndex = (status = enrollStatus.getDescription()).indexOf(";")) > 0) {
            status = status.substring(0, shortIndex);
        }
        if ((priority = EligibilityEnrollmentConversionService.getEnrollmentPriority(person)) != null && priority.length() > 0) {
            status = status + " (" + priority + ")";
        }
        vetHeader.setStatus(StringUtils.isBlank((String)status) ? null : status.toUpperCase());
        vetHeader.setDataMergePending(false);
        if (!SessionManager.isAddAPerson(request)) {
            try {
                boolean hasPendingMerge = this.getPersonMergeService().hasActiveMerge((PersonIdEntityKey)person.getPersonEntityKey());
                vetHeader.setDataMergePending(hasPendingMerge);
                PersonMergeInfo info = this.getPersonMergeService().getPersonMergeDataInfo((PersonIdEntityKey)person.getPersonEntityKey());
                if (info != null && info.getMergeEndDate() == null) {
                    vetHeader.setDataMergePending(true);
                }
                PersonMergeInfo mergInfoID = this.getPersonMergeService().getPersonMergeInfo((PersonIdEntityKey)person.getPersonEntityKey());
                String mergInfoIDStr = null;
                if (mergInfoID != null && !mergInfoID.equals((Object)"")) {
                    mergInfoIDStr = mergInfoID.getEntityKey().getKeyValueAsString();
                    if (mergInfoIDStr != null && !mergInfoIDStr.equals("")) {
                        vetHeader.setMergInfoID(mergInfoIDStr);
                    } else {
                        mergInfoIDStr = new String("");
                        vetHeader.setMergInfoID(mergInfoIDStr);
                    }
                } else {
                    mergInfoIDStr = new String("");
                    vetHeader.setMergInfoID(mergInfoIDStr);
                }
            }
            catch (ServiceException e) {
                throw new RuntimeException("Problem getting PersonMergeInfo.", e);
            }
        }
        SessionManager.setVeteranHeaderBean(request, vetHeader);
    }

    @Override
    protected void processOptimisticLockException(HttpServletRequest request, ServiceOptimisticLockException ex) throws Exception {
        this.addActionMessage(request, "error.optimisticLock");
        Person person = null;
        person = ex.getEntity() != null ? (Person)ex.getEntity() : this.getSelectedPerson(request);
        if (person == null) {
            throw new Exception("Person could not be re-retrived from the database.");
        }
        this.updateSelectedPerson(request, person);
        this.addActionMessage(request, "error.optimisticLock");
    }

    @Override
    protected void processPersonLockedException(HttpServletRequest request, PersonLockedException ex) throws Exception {
        this.addActionMessage(request, PERSON_LOCKED_ERROR_KEY, ex.getReason() != null ? ex.getReason().getReason() : "Unknown");
    }

    @Override
    protected void processEntityNotChangedException(HttpServletRequest request, EntityNotChangedException ex) throws Exception {
        this.addInformationMessage(request, "message.dataNotChanged");
    }

    @Override
    protected void processTimeoutException(HttpServletRequest request, TimeoutServiceException ex) throws Exception {
        this.addActionMessage(request, TIMEOUT_ERROR_KEY);
    }
}

