/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.ui.common.action.AbstractLogonAction;
import gov.va.med.esr.ui.common.action.UserInfoForm;
import gov.va.med.fw.security.InvalidSecurityCodeException;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserCredentials;
import gov.va.med.fw.util.StringUtils;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LogonAction
extends AbstractLogonAction {
    public ActionForward logon(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserInfoForm userForm = form instanceof UserInfoForm ? (UserInfoForm)form : null;
        ActionForward forward = mapping.getInputForward();
        if (userForm == null) {
            return forward;
        }
        userForm.init(request, this.getUserAdminService().isSsoEnforced(), this.getUserAdminService().getSsoUsername());
        Validate.notNull((Object)"Invalid form bean configured for this action.");
        UserCredentials userCredentials = userForm.getUserCredentials();
        try {
            if (userCredentials.getUserID() == null) {
                throw new LoginException("Login failed due to NULL network_id in http header");
            }
            this.processSignout(request, userCredentials.getUserID().toUpperCase());
            this.getUserAdminService().verifySecurityCode(userCredentials.getUserID(), userCredentials.getSecurityCode());
            forward = this.doAuthentication(mapping, request, userCredentials);
        }
        catch (InvalidSecurityCodeException e) {
            userForm.reset(mapping, request);
            userForm.setSecurityCodeRequired(true);
            if (StringUtils.isEmpty((String)userCredentials.getSecurityCode())) {
                this.addActionMessageForField(request, "message.logon.agreementSignatureCodeRequired", "agreementSignatureCode");
            } else {
                this.addActionMessageForField(request, "message.logon.invalidLoginSecurityCode", "agreementSignatureCode");
            }
        }
        catch (CredentialExpiredException ceEx) {
            userForm.reset(mapping, request);
            log.error((Object)"Credential expired for user ", (Throwable)ceEx);
            this.addActionMessage(request, this.getActionMessage(ceEx));
            forward = mapping.findForward("changePasswordDisplay");
        }
        catch (LoginException e) {
            userForm.reset(mapping, request);
            log.error((Object)"Authentication failed for user ", (Throwable)e);
            this.addActionMessage(request, this.getActionMessage(e));
            forward = mapping.findForward("unauthorized");
        }
        return forward;
    }

    public ActionForward home(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("ESRHome");
    }

    private ActionForward doAuthentication(ActionMapping mapping, HttpServletRequest request, UserCredentials userCredentials) throws LoginException {
        this.establishSecurityContext(mapping, request, userCredentials);
        SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
        ESRUserPrincipal user = (ESRUserPrincipal)securityContext.getUserPrincipal();
        return mapping.findForward("ESRHome");
    }
}

