/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.esr.ui.common.action.AbstractHistoryAction;
import gov.va.med.esr.ui.common.action.HistoryConfiguration;
import gov.va.med.esr.ui.common.action.HistoryForm;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.ui.util.ConvertUtils;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class HistoryAction
extends AbstractHistoryAction {
    public static final String HISTORY = "history";
    public static final String HISTORY_CHANGE_EVENTS = "History_Change_Events";
    public static final String HISTORY_CHANGE_EVENT_KEYS = "History_Change_Event_Keys";
    public static final String HISTORY_CONFIGURATION = "History_Configuration";
    public static final String HISTORY_ACTION_NAME = "History_Action_Name";
    public static final String FWD_HISTORY = "history";
    public static final String BACK_TO_ORIGINATOR = "return";
    public static final String HISTORY_ENTITY_ID = "entityId";
    public static final String HISTORY_RETURN_PATH = "returnPath";

    public ActionForward display(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HistoryForm historyForm = (HistoryForm)form;
        Validate.notNull((Object)((Object)historyForm));
        String cfgName = request.getParameter("history");
        String returnPath = request.getParameter(HISTORY_RETURN_PATH);
        Validate.notNull((Object)cfgName);
        historyForm.setHistoryConfigName(cfgName);
        HistoryConfiguration histConfig = this.getHistoryConfiguration(cfgName);
        histConfig.setReturnPath(returnPath);
        historyForm.setActionName(histConfig.getActionName());
        historyForm.setReturnLinkMessageKey(histConfig.getReturnLinkMessageKey());
        historyForm.setTitle(histConfig.getTitle());
        request.getSession().setAttribute(HISTORY_CONFIGURATION, (Object)histConfig);
        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        Set changeEvents = null;
        if (!isAddAPerson) {
            EntityKey entityKey = this.getEntityKey(request, histConfig.getEntityClassName());
            histConfig = this.updateParameterValues(request, histConfig);
            changeEvents = this.getChangeEvents(histConfig, entityKey);
        }
        if (changeEvents != null && changeEvents.size() != 0) {
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    ChangeEvent event1 = (ChangeEvent)pObject1;
                    ChangeEvent event2 = (ChangeEvent)pObject2;
                    if (event1 == null || event1.getTimeStamp() == null) {
                        return -1;
                    }
                    if (event2 == null || event2.getTimeStamp() == null) {
                        return 1;
                    }
                    return event2.getTimeStamp().compareTo(event1.getTimeStamp());
                }
            };
            ArrayList orderedChangeEvents = new ArrayList(changeEvents);
            Collections.sort(orderedChangeEvents, comparator);
            request.getSession().setAttribute(HISTORY_CHANGE_EVENTS, orderedChangeEvents);
            ArrayList<String> eventKeys = new ArrayList<String>();
            Iterator iter = orderedChangeEvents.iterator();
            while (iter.hasNext()) {
                Timestamp time = ((ChangeEvent)iter.next()).getTimeStamp();
                eventKeys.add(DateUtils.formatWithTime((Date)time, null));
            }
            request.getSession().setAttribute(HISTORY_CHANGE_EVENT_KEYS, eventKeys);
            ChangeEvent changeEvent = (ChangeEvent)orderedChangeEvents.iterator().next();
            String key = DateUtils.formatWithTime((Date)changeEvent.getTimeStamp(), null);
            historyForm.setChangeEventKey(key);
            return this.displayChangeEvent(mapping, form, request, response);
        }
        request.getSession().setAttribute(HISTORY_CHANGE_EVENTS, null);
        request.getSession().setAttribute(HISTORY_CHANGE_EVENT_KEYS, null);
        return mapping.findForward("history");
    }

    public EntityKey getEntityKey(HttpServletRequest request, String className) throws Exception {
        String entityId = request.getParameter(HISTORY_ENTITY_ID);
        if (entityId != null && className != null) {
            Class<?> clazz = Class.forName(className);
            EntityKey returnKey = null;
            try {
                returnKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(entityId), clazz);
            }
            catch (Exception ex) {
                returnKey = EntityKeyFactory.createEntityKey((Serializable)((Object)entityId), clazz);
            }
            return returnKey;
        }
        return null;
    }

    @Override
    protected boolean requiresSelectedPerson() {
        return false;
    }

    public ActionForward displayChangeEvent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List changeEvents = (List)request.getSession().getAttribute(HISTORY_CHANGE_EVENTS);
        HistoryForm historyActionForm = (HistoryForm)form;
        String key = historyActionForm.getChangeEventKey();
        HistoryConfiguration histConfig = (HistoryConfiguration)request.getSession().getAttribute(HISTORY_CONFIGURATION);
        historyActionForm.setActionName(histConfig.getActionName());
        historyActionForm.setReturnLinkMessageKey(histConfig.getReturnLinkMessageKey());
        historyActionForm.setTitle(histConfig.getTitle());
        if (changeEvents == null || changeEvents.size() == 0 || StringUtils.isEmpty((String)key)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"ChangeEvents Empty or Selected Key is Empty");
            }
            return mapping.findForward("history");
        }
        Iterator iter = changeEvents.iterator();
        while (iter.hasNext()) {
            ChangeEvent selectedEvent = (ChangeEvent)iter.next();
            if (!key.equals(DateUtils.formatWithTime((Date)selectedEvent.getTimeStamp(), null))) continue;
            if (iter.hasNext()) {
                selectedEvent.setPrevousChangeEvent((ChangeEvent)iter.next());
            }
            HistoricalInfo historicalInfo = this.getHistoricalInfo(request, histConfig, selectedEvent);
            List list = this.convert(request, histConfig, historicalInfo);
            historyActionForm.setHistoricalInfo(list);
            break;
        }
        return mapping.findForward("history");
    }

    public ActionForward returnToOriginator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HistoryConfiguration histConfig = (HistoryConfiguration)request.getSession().getAttribute(HISTORY_CONFIGURATION);
        if (histConfig != null) {
            request.getSession().setAttribute(HISTORY_CONFIGURATION, null);
            if (StringUtils.isNotEmpty((String)histConfig.getReturnPath())) {
                return mapping.findForward(histConfig.getReturnPath());
            }
            if (StringUtils.isNotEmpty((String)histConfig.getReturnActionForward())) {
                return mapping.findForward(histConfig.getReturnActionForward());
            }
            ActionForward forward = mapping.findForward(BACK_TO_ORIGINATOR);
            if (forward != null) {
                return forward;
            }
        }
        return mapping.findForward("history");
    }

    protected HistoricalInfo getHistoricalInfo(HttpServletRequest request, HistoryConfiguration histConfig, ChangeEvent changeEvent) throws ServiceException {
        return super.getHistoricalInfo(histConfig, changeEvent);
    }

    @Override
    protected Set getChangeEvents(HistoryConfiguration histConfig, EntityKey key) throws ServiceException {
        return super.getChangeEvents(histConfig, key);
    }

    protected Map getKeyMethodMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("button.viewData", "displayChangeEvent");
        map.put("button.display", "display");
        map.put("button.return", "returnToOriginator");
        return map;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public String formatSSN(String ssn) {
        return StringUtils.isNotEmpty((String)ssn) ? JspUtils.displaySSN((String)ssn) : "";
    }

    public String formatDateTime(Date date) {
        return DateUtils.formatWithTime((Date)date, (String)"MM/dd/yyyy h:mm:ssa");
    }

    public String convertBoolean(Boolean bool) {
        return ConvertUtils.convertYesNoNoDataString(bool);
    }
}

