/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.fw.util.StringUtils;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class FormatPhoneNumberAction
extends AbstractAction {
    public static final String PHONE_NUMBER_PARAM = "phoneNumber";
    public static final String FIELD_NAME_PARAM = "fieldName";
    public static final String ROOT_ELEMENT_START = "<message>";
    public static final String ROOT_ELEMENT_END = "</message>";
    public static final String PHONE_NUMBER_START = "<phoneNumber>";
    public static final String PHONE_NUMBER_END = "</phoneNumber>";
    public static final String VALUE_START = "<value>";
    public static final String VALUE_END = "</value>";
    public static final String FIELD_NAME_START = "<fieldName>";
    public static final String FIELD_NAME_END = "</fieldName>";

    public ActionForward format(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String phoneNumber = request.getParameter(PHONE_NUMBER_PARAM);
        String fieldName = request.getParameter(FIELD_NAME_PARAM);
        Validate.notNull((Object)fieldName, (String)"No field name was found on the format phone number request.");
        String xml = this.buildResponseXml(Phone.getFormattedPhone((String)phoneNumber), fieldName);
        response.setContentType("text/xml");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        out.println(xml);
        out.flush();
        return null;
    }

    private String buildResponseXml(String phoneNumber, String fieldName) {
        StringBuffer xml = new StringBuffer();
        xml.append(ROOT_ELEMENT_START);
        if (StringUtils.isNotEmpty((String)phoneNumber)) {
            xml.append(PHONE_NUMBER_START);
            xml.append(VALUE_START);
            xml.append(phoneNumber);
            xml.append(VALUE_END);
            xml.append(FIELD_NAME_START);
            xml.append(fieldName);
            xml.append(FIELD_NAME_END);
            xml.append(PHONE_NUMBER_END);
        }
        xml.append(ROOT_ELEMENT_END);
        return xml.toString();
    }

    public void afterPropertiesSet() {
    }
}

