/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.io.PrintWriter;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class FormatDateTimeAction
extends AbstractAction {
    public static final String DATE_TIME_PARAM = "dateTime";
    public static final String FIELD_NAME_PARAM = "fieldName";
    public static final String FORMAT_PATTERN_PARAM = "formatPattern";
    public static final String ROOT_ELEMENT_START = "<message>";
    public static final String ROOT_ELEMENT_END = "</message>";
    public static final String DATE_TIME_START = "<dateTime>";
    public static final String DATE_TIME_END = "</dateTime>";
    public static final String VALUE_START = "<value>";
    public static final String VALUE_END = "</value>";
    public static final String FIELD_NAME_START = "<fieldName>";
    public static final String FIELD_NAME_END = "</fieldName>";

    public ActionForward format(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String dateTime = request.getParameter(DATE_TIME_PARAM);
        String format = request.getParameter(FORMAT_PATTERN_PARAM);
        String fieldName = request.getParameter(FIELD_NAME_PARAM);
        Validate.notNull((Object)fieldName, (String)"No field name was found on the format date/time request.");
        String xml = this.buildResponseXml(this.getFormattedDateTime(dateTime, format), fieldName);
        response.setContentType("text/xml");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        out.println(xml);
        out.flush();
        return null;
    }

    protected String getFormattedDateTime(String dateTime, String format) {
        ImpreciseDate impreciseDate = new ImpreciseDate(Calendar.getInstance());
        if (StringUtils.isNotEmpty((String)dateTime)) {
            impreciseDate = DateUtils.getImpreciseDate((String)dateTime, (boolean)true);
        }
        return DateUtils.format((ImpreciseDate)impreciseDate, (String)format);
    }

    protected String buildResponseXml(String dateTime, String fieldName) {
        StringBuffer xml = new StringBuffer();
        xml.append(ROOT_ELEMENT_START);
        if (StringUtils.isNotEmpty((String)dateTime)) {
            xml.append(DATE_TIME_START);
            xml.append(VALUE_START);
            xml.append(dateTime);
            xml.append(VALUE_END);
            xml.append(FIELD_NAME_START);
            xml.append(fieldName);
            xml.append(FIELD_NAME_END);
            xml.append(DATE_TIME_END);
        }
        xml.append(ROOT_ELEMENT_END);
        return xml.toString();
    }

    public void afterPropertiesSet() {
    }
}

