/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.ui.common.action.AbstractLogonAction;
import gov.va.med.esr.ui.common.action.ChangePasswordInfoForm;
import gov.va.med.fw.security.InvalidSecurityCodeException;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.UserCredentials;
import gov.va.med.fw.ui.security.ChangePasswordInfo;
import gov.va.med.fw.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class ChangePasswordAction
extends AbstractLogonAction {
    private static Map keyMethodMap;

    public ActionForward display(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ChangePasswordInfoForm form = (ChangePasswordInfoForm)actionForm;
        SecurityContext securityContext = this.getSecurityContext(request);
        if (securityContext != null) {
            ESRUserPrincipal userPrincipal = (ESRUserPrincipal)securityContext.getUserPrincipal();
            form.setUserID(userPrincipal.getName());
            form.setAcceptAgreement(true);
            this.getUserAdminService().isSecurityCodeRequired((ESRUserPrincipalImpl)userPrincipal);
            if (userPrincipal.isPasswordChangeWarningDays()) {
                int dueDays = userPrincipal.getDaysRemainingToExpirePassword();
                ActionMessage message = new ActionMessage("message.passwordExpirationWarning", (Object)String.valueOf(dueDays));
                ActionMessages errors = this.getErrors(request);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", message);
                this.addErrors(request, errors);
            }
        }
        return mapping.findForward("changePassword");
    }

    public ActionForward changePassword(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ChangePasswordInfoForm form = (ChangePasswordInfoForm)actionForm;
        ChangePasswordInfo changePasswordInfo = (ChangePasswordInfo)form.getVO();
        try {
            this.getUserAdminService().verifySecurityCode(changePasswordInfo.getUserID(), changePasswordInfo.getSecurityCode());
            try {
                this.processSignout(request, form.getUserCredentials().getUserID().toUpperCase());
                this.getUserAdminService().changePassword(changePasswordInfo);
                form.setPassword(form.getNewPassword());
                this.establishSecurityContext(mapping, request, form.getUserCredentials());
                this.putSandboxEntry(request, "passwordChangedKey", new Boolean(true));
                return mapping.findForward("ESRHome");
            }
            catch (CredentialExpiredException expEx) {
                UserCredentials userCredentials = form.getUserCredentials();
                userCredentials.setPassword(changePasswordInfo.getNewPassword());
                this.establishSecurityContext(mapping, request, userCredentials);
                return mapping.findForward("ESRHome");
            }
        }
        catch (InvalidSecurityCodeException e) {
            form.reset(mapping, request);
            form.setSecurityCodeRequired(true);
            if (StringUtils.isEmpty((String)changePasswordInfo.getSecurityCode())) {
                this.addActionMessageForField(request, "message.logon.agreementSignatureCodeRequired", "agreementSignatureCode");
            } else {
                this.addActionMessageForField(request, "message.logon.invalidLoginSecurityCode", "agreementSignatureCode");
            }
            return mapping.getInputForward();
        }
        catch (AccountExpiredException accountEx) {
            form.reset(mapping, request);
            this.addActionMessage(request, "message.changePassword.accountExpired");
        }
        catch (LoginException ex) {
            form.reset(mapping, request);
            this.addActionMessage(request, this.getActionMessage(ex));
        }
        return mapping.findForward("changePassword");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SecurityContext securityContext = this.getSecurityContext(request);
        if (securityContext != null) {
            return mapping.findForward("ESRHome");
        }
        return mapping.findForward("logon");
    }

    protected Map getKeyMethodMap() {
        if (keyMethodMap == null) {
            keyMethodMap = new HashMap();
            keyMethodMap.put("button.display", "display");
            keyMethodMap.put("button.logon", "changePassword");
            keyMethodMap.put("button.cancel", "cancel");
        }
        return keyMethodMap;
    }
}

