/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.model.lookup.ZipCode;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.fw.util.StringUtils;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMessage;

public abstract class AddressValidationAction
extends PersonAbstractAction {
    public static final String COUNTRY_INITIALLY_NULL_MESSAGE = "message.address.countryInitiallyNull";
    public static final String INVALID_STATE_MESSAGE = "errors.address.invalidState";
    public static final String STATE_CODE_SUBSTITUTION_MESSAGE = "message.address.stateCodeSubstitution";
    public static final String CITY_STATE_NO_MATCH_ZIP_CODE_MESSAGE = "errors.address.cityStateNoMatchZipCode";
    public static final String CITY_FIELD = "city";
    public static final String CITY2_FIELD = "city2";
    public static final String STATE_FIELD = "state";
    public static final String STATE2_FIELD = "state2";
    public static final String ZIPCODE_FIELD = "zipCode";
    public static final String ZIPCODE2_FIELD = "zipCode2";

    public void validateCountryNull(Address address, HttpServletRequest request) {
        if (address != null && address.getCountry() == null) {
            this.addInformationMessage(request, COUNTRY_INITIALLY_NULL_MESSAGE);
        }
    }

    public boolean stateValid(AddressForm addressForm, Class formClass, String stateFieldName, ActionForward forward, HttpServletRequest request) throws Exception {
        LookupService lookupService = this.getLookupService();
        Class<?> clazz = Class.forName(formClass.getName());
        Method getterMethod = clazz.getDeclaredMethod("get" + StringUtils.capitalize((String)stateFieldName), new Class[0]);
        Method setterMethod = clazz.getDeclaredMethod("set" + StringUtils.capitalize((String)stateFieldName), String.class);
        String stateName = (String)getterMethod.invoke((Object)addressForm, new Object[0]);
        if (!StringUtils.isBlank((String)stateName)) {
            State state = null;
            try {
                state = lookupService.getStateByCode(stateName);
            }
            catch (UnknownLookupCodeException ex) {
                // empty catch block
            }
            if (state == null) {
                state = lookupService.getStateByName(stateName);
                if (state == null) {
                    this.addActionMessageForField(request, new ActionMessage(INVALID_STATE_MESSAGE), stateFieldName);
                    return false;
                }
                setterMethod.invoke((Object)addressForm, state.getPostalName());
                if (forward != null) {
                    forward.setPath(forward.getPath() + "," + STATE_CODE_SUBSTITUTION_MESSAGE);
                }
            }
        }
        return true;
    }

    public boolean zipCodeMatchesCityAndState(AddressForm addressForm, Class formClass, String cityFieldName, String stateFieldName, String zipCodeFieldName, HttpServletRequest request) throws Exception {
        ZipCode zipCodeObject;
        LookupService lookupService = this.getLookupService();
        Class<?> clazz = Class.forName(formClass.getName());
        Method cityGetterMethod = clazz.getDeclaredMethod("get" + StringUtils.capitalize((String)cityFieldName), new Class[0]);
        Method stateGetterMethod = clazz.getDeclaredMethod("get" + StringUtils.capitalize((String)stateFieldName), new Class[0]);
        Method zipCodeGetterMethod = clazz.getDeclaredMethod("get" + StringUtils.capitalize((String)zipCodeFieldName), new Class[0]);
        String cityName = (String)cityGetterMethod.invoke((Object)addressForm, new Object[0]);
        String stateCode = (String)stateGetterMethod.invoke((Object)addressForm, new Object[0]);
        String zipCode = (String)zipCodeGetterMethod.invoke((Object)addressForm, new Object[0]);
        if (!(StringUtils.isBlank((String)cityName) || StringUtils.isBlank((String)stateCode) || StringUtils.isBlank((String)zipCode) || (zipCodeObject = lookupService.getPartialZipCodeByCode(zipCode)) == null)) {
            List zipCodes = lookupService.getPartialZipCodeByCityState(cityName, stateCode);
            boolean invalidZipCode = true;
            for (int i = 0; i < zipCodes.size() && invalidZipCode; ++i) {
                ZipCode zipCodeObj = (ZipCode)zipCodes.get(i);
                if (!zipCode.equals(zipCodeObj.getZipCode())) continue;
                invalidZipCode = false;
            }
            if (invalidZipCode) {
                this.addActionMessageForField(request, new ActionMessage(CITY_STATE_NO_MATCH_ZIP_CODE_MESSAGE), zipCodeFieldName);
                return false;
            }
        }
        return true;
    }
}

