/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;

public class AddressForm
extends AbstractForm {
    private static final long serialVersionUID = -8872170937416822150L;
    public static final String ADDRESS_LINE1 = "addressLine1";
    public static final String CITY = "city";
    public static final String COUNTY = "county";
    public static final String STATE = "state";
    public static final String ZIP_CODE = "zipCode";
    public static final String ZIP_PLUS_4 = "zipPlus4";
    public static final String PROVINCE = "province";
    public static final String POSTAL_CODE = "postalCode";
    public static final String LABEL_ADDRESS_LINE1 = "label.addresses.addressLine1";
    public static final String LABEL_ZIP_CODE = "label.addresses.zipCode";
    public static final String LABEL_CITY = "label.addresses.city";
    public static final String LABEL_STATE = "label.addresses.state";
    public static final String LABEL_PROVINCE = "label.addresses.province";
    public static final String LABEL_POSTAL_CODE = "label.addresses.postalCode";
    private static final ArrayList US_FIELDS = new ArrayList();
    private static final ArrayList NON_US_FIELDS = new ArrayList();
    protected String addressLine1;
    protected String addressLine2;
    protected String addressLine3;
    protected String city;
    protected String county;
    protected String state;
    protected String prevZip;
    protected String zipCode;
    protected String zipPlus4;
    protected String country;
    protected String province;
    protected String postalCode;

    protected void initialize() {
        this.addressLine1 = null;
        this.addressLine2 = null;
        this.addressLine3 = null;
        this.zipCode = null;
        this.prevZip = null;
        this.zipPlus4 = null;
        this.city = null;
        this.state = null;
        this.county = null;
        this.country = null;
        this.province = null;
        this.postalCode = null;
    }

    public void clearForm() {
        this.initialize();
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getAddressLine3() {
        return this.addressLine3;
    }

    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPrevZip() {
        return this.prevZip;
    }

    public void setPrevZip(String prevZip) {
        this.prevZip = prevZip != null ? prevZip.trim() : "";
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode != null ? zipCode.trim() : "";
    }

    public String getZipPlus4() {
        return this.zipPlus4;
    }

    public void setZipPlus4(String zipPlus4) {
        this.zipPlus4 = zipPlus4 != null ? zipPlus4.trim() : "";
    }

    public int getZipCodeLength() {
        return this.zipCode != null ? this.zipCode.length() : 0;
    }

    public int getZipPlus4Length() {
        return this.zipPlus4 != null ? this.zipPlus4.length() : 0;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public boolean isAnyAddressFieldFilled() {
        return this.isUSAddress() ? StringUtils.isNotEmpty((String)this.addressLine1) || StringUtils.isNotEmpty((String)this.addressLine2) || StringUtils.isNotEmpty((String)this.addressLine3) || StringUtils.isNotEmpty((String)this.city) || StringUtils.isNotEmpty((String)this.county) || StringUtils.isNotEmpty((String)this.state) || StringUtils.isNotEmpty((String)this.zipCode) || StringUtils.isNotEmpty((String)this.zipPlus4) : StringUtils.isNotEmpty((String)this.addressLine1) || StringUtils.isNotEmpty((String)this.addressLine2) || StringUtils.isNotEmpty((String)this.addressLine3) || StringUtils.isNotEmpty((String)this.city) || StringUtils.isNotEmpty((String)this.province) || StringUtils.isNotEmpty((String)this.postalCode);
    }

    public boolean isUSAddress() {
        return Country.isUSAddress((String)this.country);
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors validationErrors = super.validate(mapping, request);
        ActionErrors returnErrors = new ActionErrors();
        Iterator fieldIterator = validationErrors.properties();
        while (fieldIterator.hasNext()) {
            String field = (String)fieldIterator.next();
            if ((!this.isUSAddress() || NON_US_FIELDS.contains(field)) && (this.isUSAddress() || US_FIELDS.contains(field))) continue;
            Iterator messageIter = validationErrors.get(field);
            while (messageIter.hasNext()) {
                ActionMessage message = (ActionMessage)messageIter.next();
                returnErrors.add(field, message);
            }
        }
        return returnErrors;
    }

    protected ActionErrors validateOptionalAddress(ActionMapping mapping, HttpServletRequest request, ActionErrors errors) {
        MessageResources messageResources = this.getResources(request);
        if (this.isAnyAddressFieldFilled()) {
            if (StringUtils.isEmpty((String)this.getAddressLine1())) {
                errors.add(ADDRESS_LINE1, new ActionMessage("errors.required", (Object)messageResources.getMessage(LABEL_ADDRESS_LINE1)));
            }
            if (this.isUSAddress()) {
                if (StringUtils.isEmpty((String)this.getZipCode())) {
                    errors.add(ZIP_CODE, new ActionMessage("errors.required", (Object)messageResources.getMessage(LABEL_ZIP_CODE)));
                }
                if (StringUtils.isEmpty((String)this.getCity())) {
                    errors.add(CITY, new ActionMessage("errors.required", (Object)messageResources.getMessage(LABEL_CITY)));
                }
                if (StringUtils.isEmpty((String)this.getState())) {
                    errors.add(STATE, new ActionMessage("errors.required", (Object)messageResources.getMessage(LABEL_STATE)));
                }
            } else {
                if (StringUtils.isEmpty((String)this.getProvince())) {
                    errors.add(PROVINCE, new ActionMessage("errors.required", (Object)messageResources.getMessage(LABEL_PROVINCE)));
                }
                if (StringUtils.isEmpty((String)this.getPostalCode())) {
                    errors.add(POSTAL_CODE, new ActionMessage("errors.required", (Object)messageResources.getMessage(LABEL_POSTAL_CODE)));
                }
            }
        }
        return errors;
    }

    protected ActionErrors validateOptionalAddressIncludingCountry(ActionMapping mapping, HttpServletRequest request, ActionErrors errors) {
        MessageResources messageResources = this.getResources(request);
        if (this.isAnyAddressFieldFilled() || StringUtils.isNotEmpty((String)this.country)) {
            if (StringUtils.isEmpty((String)this.getAddressLine1())) {
                errors.add(ADDRESS_LINE1, new ActionMessage("errors.required", (Object)messageResources.getMessage(LABEL_ADDRESS_LINE1)));
            }
            if (this.isUSAddress()) {
                if (StringUtils.isEmpty((String)this.getZipCode())) {
                    errors.add(ZIP_CODE, new ActionMessage("errors.required", (Object)messageResources.getMessage(LABEL_ZIP_CODE)));
                }
                if (StringUtils.isEmpty((String)this.getCity())) {
                    errors.add(CITY, new ActionMessage("errors.required", (Object)messageResources.getMessage(LABEL_CITY)));
                }
                if (StringUtils.isEmpty((String)this.getState())) {
                    errors.add(STATE, new ActionMessage("errors.required", (Object)messageResources.getMessage(LABEL_STATE)));
                }
            } else {
                if (StringUtils.isEmpty((String)this.getProvince())) {
                    errors.add(PROVINCE, new ActionMessage("errors.required", (Object)messageResources.getMessage(LABEL_PROVINCE)));
                }
                if (StringUtils.isEmpty((String)this.getPostalCode())) {
                    errors.add(POSTAL_CODE, new ActionMessage("errors.required", (Object)messageResources.getMessage(LABEL_POSTAL_CODE)));
                }
            }
        }
        return errors;
    }

    static {
        US_FIELDS.add(COUNTY);
        US_FIELDS.add(STATE);
        US_FIELDS.add(ZIP_CODE);
        US_FIELDS.add(ZIP_PLUS_4);
        NON_US_FIELDS.add(PROVINCE);
        NON_US_FIELDS.add(POSTAL_CODE);
    }
}

