/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.ui.common.action.AddressForm;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.util.StringUtils;

public class AddressConversionService
extends UIConversionServiceImpl {
    protected void convertBean(Object source, Object target) throws ConversionServiceException {
        Address address = null;
        AddressForm form = null;
        if (source instanceof Address) {
            address = (Address)source;
            if (!AddressForm.class.isAssignableFrom(target.getClass())) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type AddressForm.");
            }
            form = (AddressForm)((Object)target);
            this.convertAddressToForm(address, form);
        } else if (source instanceof AddressForm) {
            form = (AddressForm)((Object)source);
            if (!Address.class.isAssignableFrom(target.getClass())) {
                throw new ConversionServiceException("Target object is of type " + target.getClass().getName() + " and must be of type Address.");
            }
            address = (Address)target;
            this.convertFormToAddress(form, address);
        } else {
            throw new ConversionServiceException("Source object is of type " + target.getClass().getName() + " and must be of type Address or AddressForm.");
        }
    }

    protected void convertAddressToForm(Address address, AddressForm form) {
        if (address != null) {
            form.setAddressLine1(address.getLine1());
            form.setAddressLine2(address.getLine2());
            form.setAddressLine3(address.getLine3());
            form.setCity(address.getCity());
            if (address.getCountry() != null) {
                form.setCountry(address.getCountry());
            }
            if (form.isUSAddress()) {
                form.setState(address.getState());
                form.setCounty(address.getCounty());
                form.setPrevZip(address.getZipCode());
                form.setZipCode(address.getZipCode());
                form.setZipPlus4(address.getZipPlus4());
            } else {
                form.setProvince(address.getProvince());
                form.setPostalCode(address.getPostalCode());
            }
        }
    }

    protected void convertFormToAddress(AddressForm form, Address address) {
        address.setCountry(StringUtils.isBlank((String)form.getCountry()) ? null : form.getCountry());
        address.setLine1(StringUtils.isBlank((String)form.getAddressLine1()) ? null : form.getAddressLine1());
        address.setLine2(StringUtils.isBlank((String)form.getAddressLine2()) ? null : form.getAddressLine2());
        address.setLine3(StringUtils.isBlank((String)form.getAddressLine3()) ? null : form.getAddressLine3());
        address.setCity(StringUtils.isBlank((String)form.getCity()) ? null : form.getCity());
        try {
            String countryCode = form.getCountry();
            Country newCountry = this.getLookupCacheService().getLookupService().getCountryByCode(countryCode);
            String countryShortName = newCountry.getShortName();
            Country countryObject = new Country();
            countryObject.setShortName(countryShortName);
            address.setCountryObject(countryObject);
        }
        catch (Exception e) {
            this.logger.error((Object)("lookup service is not avaliable. Error= " + e));
        }
        if (form.isUSAddress()) {
            address.setCounty(StringUtils.isBlank((String)form.getCounty()) ? null : form.getCounty());
            address.setState(StringUtils.isBlank((String)form.getState()) ? null : form.getState());
            address.setZipCode(StringUtils.isBlank((String)form.getZipCode()) ? null : form.getZipCode());
            address.setZipPlus4(StringUtils.isBlank((String)form.getZipPlus4()) ? null : form.getZipPlus4());
            address.setProvince(null);
            address.setPostalCode(null);
        } else {
            address.setCounty(null);
            address.setState(null);
            address.setZipCode(null);
            address.setZipPlus4(null);
            address.setProvince(StringUtils.isBlank((String)form.getProvince()) ? null : form.getProvince());
            address.setPostalCode(StringUtils.isBlank((String)form.getPostalCode()) ? null : form.getPostalCode());
        }
    }
}

