/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.common.action;

import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.service.UserAdminService;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.esr.ui.common.action.HistoryConfiguration;
import gov.va.med.esr.ui.common.action.PersonAbstractAction;
import gov.va.med.esr.ui.common.beans.EntityHistory;
import gov.va.med.esr.ui.common.beans.FieldHistoryInfo;
import gov.va.med.esr.ui.common.beans.FormattingTableRow;
import gov.va.med.esr.ui.common.beans.TableRow;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.AbstractVersionedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.Reflector;
import gov.va.med.fw.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtilsBean;

public abstract class AbstractHistoryAction
extends PersonAbstractAction {
    public static final String NULL_TEXT = "";
    public static final String IS_NOT_NULL_YES_NO = "isNotNullYesorNo";
    public static final String IS_NOT_NULL_TRUE_FALSE = "isNotNullTrueorFalse";
    public static final String TEXT_YES = "Yes";
    public static final String TEXT_NO = "No";
    public static final String TEXT_NO_DATA = "No Data";
    public static final String TEXT_TRUE = "True";
    public static final String TEXT_FALSE = "False";
    public static final String NO_MAPPING = "NO_MAPPING";
    public static final String THIS_OBJECT = "*this";

    public String formatCurrency(BigDecimal value) {
        return "$" + value == null ? NULL_TEXT : NumberFormat.getCurrencyInstance().format(value.doubleValue());
    }

    public String formatCurrency(Integer value) {
        return "$" + value == null ? NULL_TEXT : NumberFormat.getCurrencyInstance().format(value.doubleValue());
    }

    public String getUserName(String userId) {
        try {
            if (this.getUserAdminService() == null) {
                UserAdminService service = (UserAdminService)this.getBean("userAdminService");
                this.setUserAdminService(service);
            }
            if (this.getUserAdminService() != null) {
                Lookup userLookup = this.getUserAdminService().getByCode(userId);
                return userLookup == null ? userId : userLookup.getDescription();
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return userId;
    }

    protected HistoricalInfo getHistoricalInfo(HistoryConfiguration histConfig, ChangeEvent changeEvent) throws ServiceException {
        Object[] objArray = new Object[]{changeEvent};
        Object retValue = this.invokeService(objArray, histConfig.getServiceName(), histConfig.getHistoryMethodName());
        if (retValue != null) {
            return (HistoricalInfo)retValue;
        }
        return null;
    }

    protected Set getChangeEvents(HistoryConfiguration histConfig, EntityKey key) throws ServiceException {
        int numParameters = (key == null ? 0 : 1) + histConfig.getParameterValues().size();
        Object[] objArray = null;
        if (numParameters > 0) {
            objArray = new Object[numParameters];
        }
        int paramCount = 0;
        if (key != null && objArray != null) {
            objArray[paramCount] = key;
            ++paramCount;
        }
        for (int i = paramCount; i < numParameters; ++i) {
            if (objArray == null) continue;
            objArray[i] = histConfig.getParameterValues().get(paramCount - 1);
        }
        Object retValue = this.invokeService(objArray, histConfig.getServiceName(), histConfig.getChangeEventsMethodName());
        if (retValue != null) {
            return (Set)retValue;
        }
        return new HashSet();
    }

    protected HistoryConfiguration updateParameterValues(HttpServletRequest request, HistoryConfiguration histConfig) {
        List parameterNames = histConfig.getParameterNames();
        if (parameterNames != null && parameterNames.size() > 0) {
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            for (int i = 0; i < parameterNames.size(); ++i) {
                Object obj = request.getSession().getAttribute((String)parameterNames.get(i));
                parameterValues.add(obj);
            }
            histConfig.setParameterValues(parameterValues);
        }
        return histConfig;
    }

    protected List convert(HttpServletRequest request, HistoryConfiguration histConfig, HistoricalInfo historicalInfo) throws ServiceException {
        AbstractVersionedEntity current = historicalInfo.getCurrentVersion();
        AbstractVersionedEntity previous = historicalInfo.getPreviousVersion();
        if (current != null && current.isDeleted().booleanValue()) {
            current = null;
        }
        if (previous != null && previous.isDeleted().booleanValue()) {
            previous = null;
        }
        return this.convert(histConfig.getDisplayPropertyMap(), histConfig.getDisplayObjectMap(), current, previous);
    }

    protected List convert(Map propMap, Map displayObjectMap, AbstractVersionedEntity current, AbstractVersionedEntity previous) throws ServiceException {
        if (propMap == null || propMap.size() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Property Map is not configured for History Action");
            }
            return new ArrayList();
        }
        Set keys = propMap.keySet();
        ArrayList<TableRow> list = new ArrayList<TableRow>(propMap.size());
        PropertyUtilsBean propUtils = new PropertyUtilsBean();
        for (String key : keys) {
            Object typeCheck;
            String value = (String)propMap.get(key);
            if (StringUtils.isEmpty((String)value)) {
                FormattingTableRow infoBean = new FormattingTableRow(key);
                list.add(infoBean);
                continue;
            }
            Object curValue = null;
            Object prevValue = null;
            curValue = this.getNestedProperty(propUtils, current, value);
            prevValue = this.getNestedProperty(propUtils, previous, value);
            String curValueAsString = null;
            String prevValueAsString = null;
            Map objectProperties = (Map)displayObjectMap.get(key);
            if (curValue == null && prevValue == null && objectProperties != null) {
                FormattingTableRow tr = new FormattingTableRow();
                tr.setForceColorChange(true);
                list.add(tr);
                list.addAll(this.createEmptyFieldHistoryObjects(objectProperties));
                continue;
            }
            Object object = typeCheck = curValue == null ? prevValue : curValue;
            if (typeCheck instanceof Set) {
                list.addAll(this.convert(objectProperties, displayObjectMap, (Set)curValue, (Set)prevValue));
                continue;
            }
            if (typeCheck instanceof Map && objectProperties != null) {
                list.addAll(this.convert(objectProperties, (Map)curValue, (Map)prevValue));
                continue;
            }
            if (typeCheck instanceof AbstractKeyedEntity && objectProperties != null) {
                list.addAll(this.convert(objectProperties, curValue, prevValue));
                continue;
            }
            if (typeCheck instanceof String) {
                curValueAsString = (String)curValue;
                prevValueAsString = (String)prevValue;
            } else {
                curValueAsString = JspUtils.displayValue((Object)curValue, (String)NULL_TEXT, null);
                prevValueAsString = JspUtils.displayValue((Object)prevValue, (String)NULL_TEXT, null);
            }
            if (objectProperties != null) continue;
            list.add(new FieldHistoryInfo(key, curValueAsString, prevValueAsString));
        }
        return list;
    }

    private List convert(Map propMap, Map current, Map previous) throws ServiceException {
        ArrayList historyList = new ArrayList();
        if (propMap == null || propMap.size() == 0) {
            return historyList;
        }
        return historyList;
    }

    private List convert(Map propMap, Object current, Object previous) throws ServiceException {
        ArrayList<TableRow> historyList = new ArrayList<TableRow>();
        if (propMap == null || propMap.size() == 0) {
            return historyList;
        }
        Set keys = propMap.keySet();
        PropertyUtilsBean propUtils = new PropertyUtilsBean();
        for (String key : keys) {
            String value = (String)propMap.get(key);
            if (StringUtils.isEmpty((String)value)) {
                FormattingTableRow infoBean = new FormattingTableRow(key, true);
                historyList.add(infoBean);
                continue;
            }
            Object curValue = null;
            Object prevValue = null;
            curValue = this.getNestedProperty(propUtils, current, value);
            prevValue = this.getNestedProperty(propUtils, previous, value);
            String curValueAsString = null;
            String prevValueAsString = null;
            if (curValue instanceof String) {
                curValueAsString = (String)curValue;
                prevValueAsString = (String)prevValue;
            } else {
                curValueAsString = JspUtils.displayValue((Object)curValue, (String)NULL_TEXT, null);
                prevValueAsString = JspUtils.displayValue((Object)prevValue, (String)NULL_TEXT, null);
            }
            FieldHistoryInfo infoBean = new FieldHistoryInfo(key, curValueAsString, prevValueAsString);
            historyList.add(infoBean);
        }
        return historyList;
    }

    private List convert(Map propMap, Map displayObjectMap, Set currentSet, Set previousSet) throws ServiceException {
        ArrayList<FormattingTableRow> historyList = new ArrayList<FormattingTableRow>();
        List historyObjects = this.processSets(currentSet, previousSet);
        FormattingTableRow trDisable = new FormattingTableRow();
        trDisable.setDisableColorChange(new Boolean(true));
        historyList.add(trDisable);
        for (int i = 0; i < historyObjects.size(); ++i) {
            String className;
            Map objectPropMap;
            if (i > 0) {
                FormattingTableRow tr = new FormattingTableRow();
                tr.setForceColorChange(true);
                historyList.add(tr);
            }
            EntityHistory entityHistory = (EntityHistory)historyObjects.get(i);
            Object current = entityHistory.getCurrent();
            Object previous = entityHistory.getPrevious();
            if (propMap != null && propMap.size() > 0) {
                historyList.addAll(this.convert(propMap, current, previous));
            }
            if ((objectPropMap = (Map)displayObjectMap.get(className = this.getClassName(current, previous))) == null || objectPropMap.size() <= 0) continue;
            historyList.addAll(this.convert(objectPropMap, current, previous));
        }
        FormattingTableRow trEnable = new FormattingTableRow();
        trEnable.setDisableColorChange(new Boolean(false));
        historyList.add(trEnable);
        return historyList;
    }

    private String getClassName(Object obj1, Object obj2) {
        if (obj1 != null) {
            return obj1.getClass().getName();
        }
        if (obj2 != null) {
            return obj2.getClass().getName();
        }
        return null;
    }

    protected HistoryConfiguration getHistoryConfiguration(String beanId) throws ServiceException {
        return (HistoryConfiguration)this.getBean(beanId);
    }

    private Object getNestedProperty(PropertyUtilsBean propUtils, Object source, String nestedPropName) throws ServiceException {
        if (StringUtils.isEmpty((String)nestedPropName) || nestedPropName.equals(NO_MAPPING)) {
            return null;
        }
        if (nestedPropName.equals(IS_NOT_NULL_YES_NO)) {
            return source == null ? TEXT_NO : TEXT_YES;
        }
        if (nestedPropName.equals(IS_NOT_NULL_TRUE_FALSE)) {
            return source == null ? TEXT_FALSE : TEXT_TRUE;
        }
        String methodName = null;
        String propertyName = nestedPropName;
        if (nestedPropName.indexOf(40) > -1) {
            methodName = nestedPropName.substring(0, nestedPropName.indexOf(40));
            propertyName = nestedPropName.substring(nestedPropName.indexOf(40) + 1, nestedPropName.indexOf(41));
        }
        try {
            Object propertyValue;
            if (source == null) {
                return null;
            }
            Object object = propertyValue = THIS_OBJECT.equals(propertyName) ? source : propUtils.getNestedProperty(source, propertyName);
            if (methodName != null) {
                return this.executeMethod(methodName, propertyValue);
            }
            return propertyValue;
        }
        catch (NestedNullException np) {
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
        catch (Exception ex) {
            throw new ServiceException("Conversion to HistoryInfo failed property:" + nestedPropName + "class " + source.getClass().getName(), (Throwable)ex);
        }
    }

    private Object executeMethod(String methodName, Object propertyValue) throws Exception {
        if (propertyValue != null && methodName != null) {
            Object[] params = new Object[]{propertyValue};
            for (Class<?> currentClass = ((Object)((Object)this)).getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                try {
                    Method method = Reflector.findMethod(currentClass, (String)methodName, (Class[])Reflector.typesOf((Object[])params));
                    return method.invoke((Object)this, params);
                }
                catch (Exception ex) {
                    continue;
                }
            }
            throw new NoSuchMethodException("Unable to find a matching '" + methodName + "' method in the '" + ((Object)((Object)this)).getClass().getName() + "' class hierarchy.");
        }
        return propertyValue;
    }

    private List processSets(Set current, Set previous) {
        return this.matchSets(current, previous);
    }

    private List processMaps(Map current, Map previous) {
        HashSet allKeySet = new HashSet(current.keySet());
        allKeySet.addAll(previous.keySet());
        ArrayList<EntityHistory> list = new ArrayList<EntityHistory>();
        for (Object key : allKeySet) {
            Object objPrevious = previous.get(key);
            Object objCurrent = current.get(key);
            list.add(new EntityHistory(objCurrent, objPrevious));
        }
        return list;
    }

    private boolean match(IncomeTestStatus statusSrc, IncomeTestStatus statusTarget) {
        return statusSrc.getType().getIdentifier().equals(statusTarget.getType().getIdentifier());
    }

    private boolean match(Eligibility eligibilitySrc, Eligibility eligibilityTarget) {
        return eligibilitySrc.getType() != null && eligibilityTarget.getType() != null ? eligibilitySrc.getType().getIdentifier().equals(eligibilityTarget.getType().getIdentifier()) : eligibilitySrc.getFactor() != null && eligibilityTarget.getFactor() != null && eligibilitySrc.getFactor().getIdentifier().equals(eligibilityTarget.getFactor().getIdentifier());
    }

    private boolean match(AbstractKeyedEntity src, AbstractKeyedEntity target) {
        return src.getEntityKey().getKeyValue().equals(target.getEntityKey().getKeyValue());
    }

    private boolean match(AbstractLookup src, AbstractLookup target) {
        return src.getIdentifier().equals(target.getIdentifier()) && src.getClass().getName().equals(target.getClass().getName());
    }

    @Override
    public boolean match(Object src, Object target) {
        if (src instanceof Eligibility) {
            return this.match((Eligibility)src, (Eligibility)target);
        }
        if (src instanceof IncomeTestStatus) {
            return this.match((IncomeTestStatus)src, (IncomeTestStatus)target);
        }
        if (src instanceof AbstractKeyedEntity) {
            return this.match((AbstractKeyedEntity)src, (AbstractKeyedEntity)target);
        }
        if (src instanceof AbstractLookup) {
            return this.match((AbstractLookup)src, (AbstractLookup)target);
        }
        return src.equals(target);
    }

    private List createEmptyFieldHistoryObjects(Map propMap) {
        ArrayList<FieldHistoryInfo> historyList = new ArrayList<FieldHistoryInfo>();
        if (propMap == null || propMap.size() == 0) {
            return historyList;
        }
        Set keys = propMap.keySet();
        for (String key : keys) {
            historyList.add(new FieldHistoryInfo(key, null, null));
        }
        return historyList;
    }
}

