/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.ui.admin.beans;

import gov.va.med.fw.util.StringUtils;
import java.io.Serializable;
import java.util.Date;

public class UserSessionBean
implements Serializable,
Comparable {
    private static final long serialVersionUID = 8833745341340401676L;
    public static final int IDLE_SECONDS = 600;
    private Date creationTime;
    private Date lastAccessedTime;
    private String id;
    private int maxInactiveInterval;
    private String username;
    private String remoteIpAddress;
    private boolean currentSession;

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setLastAccessedTime(Date lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getRemoteIpAddress() {
        return this.remoteIpAddress;
    }

    public void setRemoteIpAddress(String remoteIpAddress) {
        this.remoteIpAddress = remoteIpAddress;
    }

    public boolean isCurrentSession() {
        return this.currentSession;
    }

    public void setCurrentSession(boolean currentSession) {
        this.currentSession = currentSession;
    }

    public String getSecondsUntilExpire() {
        if (this.maxInactiveInterval <= 0) {
            return "";
        }
        int remainingTime = this.maxInactiveInterval - this.getIdleSeconds();
        return String.valueOf(remainingTime < 0 ? 0 : remainingTime);
    }

    public int getIdleSeconds() {
        if (this.lastAccessedTime == null) {
            return 0;
        }
        return (int)((new Date().getTime() - this.lastAccessedTime.getTime()) / 1000L);
    }

    public boolean isIdle() {
        return this.getIdleSeconds() > 600;
    }

    public int compareTo(Object object) {
        if (object != null || object instanceof UserSessionBean) {
            UserSessionBean objBean = (UserSessionBean)object;
            return StringUtils.compareTo((String)this.getUsername(), (String)objBean.getUsername());
        }
        return 0;
    }

    public String toString() {
        return "Username: " + this.username;
    }
}

